/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDropAdapter
implements DropTargetListener {
    private List listeners = new ArrayList();
    private TransferDropTargetListener currentListener;
    private int originalDropType;

    public void addDropTargetListener(TransferDropTargetListener transferDropTargetListener) {
        this.listeners.add(transferDropTargetListener);
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.originalDropType = dropTargetEvent.detail;
        this.updateCurrentListener(dropTargetEvent);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.setCurrentListener(null, dropTargetEvent);
    }

    public void dragOperationChanged(final DropTargetEvent dropTargetEvent) {
        this.originalDropType = dropTargetEvent.detail;
        TransferDropTargetListener transferDropTargetListener = this.getCurrentListener();
        this.updateCurrentListener(dropTargetEvent);
        final TransferDropTargetListener transferDropTargetListener2 = this.getCurrentListener();
        if (transferDropTargetListener2 != null && transferDropTargetListener2 == transferDropTargetListener) {
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    transferDropTargetListener2.dragOperationChanged(dropTargetEvent);
                }
            });
        }
    }

    public void dragOver(final DropTargetEvent dropTargetEvent) {
        TransferDropTargetListener transferDropTargetListener = this.getCurrentListener();
        this.updateCurrentListener(dropTargetEvent);
        final TransferDropTargetListener transferDropTargetListener2 = this.getCurrentListener();
        if (transferDropTargetListener2 != null && transferDropTargetListener2 == transferDropTargetListener) {
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    transferDropTargetListener2.dragOver(dropTargetEvent);
                }
            });
        }
    }

    public void drop(final DropTargetEvent dropTargetEvent) {
        this.updateCurrentListener(dropTargetEvent);
        if (this.getCurrentListener() != null) {
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().drop(dropTargetEvent);
                }
            });
        }
        this.setCurrentListener(null, dropTargetEvent);
    }

    public void dropAccept(final DropTargetEvent dropTargetEvent) {
        if (this.getCurrentListener() != null) {
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().dropAccept(dropTargetEvent);
                }
            });
        }
    }

    private TransferDropTargetListener getCurrentListener() {
        return this.currentListener;
    }

    private TransferData getSupportedTransferType(TransferData[] transferDataArray, TransferDropTargetListener transferDropTargetListener) {
        int n = 0;
        while (n < transferDataArray.length) {
            if (transferDropTargetListener.getTransfer().isSupportedType(transferDataArray[n])) {
                return transferDataArray[n];
            }
            ++n;
        }
        return null;
    }

    public Transfer[] getTransfers() {
        Transfer[] transferArray = new Transfer[this.listeners.size()];
        int n = 0;
        while (n < this.listeners.size()) {
            TransferDropTargetListener transferDropTargetListener = (TransferDropTargetListener)this.listeners.get(n);
            transferArray[n] = transferDropTargetListener.getTransfer();
            ++n;
        }
        return transferArray;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void removeDropTargetListener(TransferDropTargetListener transferDropTargetListener) {
        if (this.currentListener == transferDropTargetListener) {
            this.currentListener = null;
        }
        this.listeners.remove(transferDropTargetListener);
    }

    private boolean setCurrentListener(TransferDropTargetListener transferDropTargetListener, final DropTargetEvent dropTargetEvent) {
        if (this.currentListener == transferDropTargetListener) {
            return false;
        }
        if (this.currentListener != null) {
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.currentListener.dragLeave(dropTargetEvent);
                }
            });
        }
        this.currentListener = transferDropTargetListener;
        if (this.currentListener != null) {
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.currentListener.dragEnter(dropTargetEvent);
                }
            });
        }
        return true;
    }

    private void updateCurrentListener(DropTargetEvent dropTargetEvent) {
        int n = dropTargetEvent.detail;
        dropTargetEvent.detail = this.originalDropType;
        for (TransferDropTargetListener transferDropTargetListener : this.listeners) {
            TransferData transferData = this.getSupportedTransferType(dropTargetEvent.dataTypes, transferDropTargetListener);
            if (transferData == null) continue;
            TransferData transferData2 = dropTargetEvent.currentDataType;
            dropTargetEvent.currentDataType = transferData;
            if (transferDropTargetListener.isEnabled(dropTargetEvent)) {
                if (!this.setCurrentListener(transferDropTargetListener, dropTargetEvent)) {
                    dropTargetEvent.detail = n;
                }
                return;
            }
            dropTargetEvent.currentDataType = transferData2;
        }
        this.setCurrentListener(null, dropTargetEvent);
        dropTargetEvent.detail = 0;
        dropTargetEvent.feedback = 24;
    }
}

