/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

public class DelegatingDragAdapter
implements DragSourceListener {
    private List listeners = new ArrayList();
    private List activeListeners = new ArrayList();
    private TransferDragSourceListener currentListener;

    public void addDragSourceListener(TransferDragSourceListener transferDragSourceListener) {
        this.listeners.add(transferDragSourceListener);
    }

    public void dragFinished(final DragSourceEvent dragSourceEvent) {
        SafeRunnable.run(new SafeRunnable(){

            public void run() throws Exception {
                if (DelegatingDragAdapter.this.currentListener != null) {
                    DelegatingDragAdapter.this.currentListener.dragFinished(dragSourceEvent);
                } else {
                    Iterator iterator = DelegatingDragAdapter.this.activeListeners.iterator();
                    while (iterator.hasNext()) {
                        ((TransferDragSourceListener)iterator.next()).dragFinished(dragSourceEvent);
                    }
                }
            }
        });
        this.currentListener = null;
        this.activeListeners.clear();
    }

    public void dragSetData(final DragSourceEvent dragSourceEvent) {
        this.updateCurrentListener(dragSourceEvent);
        if (this.currentListener != null) {
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDragAdapter.this.currentListener.dragSetData(dragSourceEvent);
                }
            });
        }
    }

    public void dragStart(final DragSourceEvent dragSourceEvent) {
        boolean bl = false;
        ArrayList<Transfer> arrayList = new ArrayList<Transfer>(this.listeners.size());
        this.activeListeners.clear();
        int n = 0;
        while (n < this.listeners.size()) {
            final TransferDragSourceListener transferDragSourceListener = (TransferDragSourceListener)this.listeners.get(n);
            dragSourceEvent.doit = true;
            SafeRunnable.run(new SafeRunnable(){

                public void run() throws Exception {
                    transferDragSourceListener.dragStart(dragSourceEvent);
                }
            });
            if (dragSourceEvent.doit) {
                arrayList.add(transferDragSourceListener.getTransfer());
                this.activeListeners.add(transferDragSourceListener);
            }
            bl |= dragSourceEvent.doit;
            ++n;
        }
        if (bl) {
            ((DragSource)dragSourceEvent.widget).setTransfer(arrayList.toArray(new Transfer[arrayList.size()]));
        }
        dragSourceEvent.doit = bl;
    }

    public Transfer[] getTransfers() {
        Transfer[] transferArray = new Transfer[this.listeners.size()];
        int n = 0;
        while (n < this.listeners.size()) {
            TransferDragSourceListener transferDragSourceListener = (TransferDragSourceListener)this.listeners.get(n);
            transferArray[n] = transferDragSourceListener.getTransfer();
            ++n;
        }
        return transferArray;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void removeDragSourceListener(TransferDragSourceListener transferDragSourceListener) {
        this.listeners.remove(transferDragSourceListener);
        if (this.currentListener == transferDragSourceListener) {
            this.currentListener = null;
        }
        if (this.activeListeners.contains(transferDragSourceListener)) {
            this.activeListeners.remove(transferDragSourceListener);
        }
    }

    private void updateCurrentListener(DragSourceEvent dragSourceEvent) {
        this.currentListener = null;
        if (dragSourceEvent.dataType == null) {
            return;
        }
        for (TransferDragSourceListener transferDragSourceListener : this.activeListeners) {
            if (!transferDragSourceListener.getTransfer().isSupportedType(dragSourceEvent.dataType)) continue;
            this.currentListener = transferDragSourceListener;
            return;
        }
    }
}

