/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ConfigureColumns {
    public static boolean forTree(Tree tree, IShellProvider iShellProvider) {
        return new ConfigureColumnsDialog(iShellProvider, tree).open() == 0;
    }

    public static boolean forTable(Table table, IShellProvider iShellProvider) {
        return new ConfigureColumnsDialog(iShellProvider, table).open() == 0;
    }

    static class ConfigureColumnsDialog
    extends Dialog {
        private Control targetControl;
        private ColumnObject[] columnObjects;
        private Table table;
        private Button upButton;
        private Button downButton;
        private Text text;
        private boolean moveableColumnsFound;

        public ConfigureColumnsDialog(IShellProvider iShellProvider, Table table) {
            this(iShellProvider, (Control)table);
        }

        public ConfigureColumnsDialog(IShellProvider iShellProvider, Tree tree) {
            this(iShellProvider, (Control)tree);
        }

        private ConfigureColumnsDialog(IShellProvider iShellProvider, Control control) {
            super(iShellProvider);
            this.targetControl = control;
            this.moveableColumnsFound = this.createColumnObjects();
        }

        @Override
        protected boolean isResizable() {
            return true;
        }

        @Override
        public void create() {
            super.create();
            this.getShell().setText(JFaceResources.getString("ConfigureColumnsDialog_Title"));
        }

        @Override
        protected void initializeBounds() {
            super.initializeBounds();
            this.table.setSelection(0);
            this.handleSelectionChanged(0);
        }

        private boolean createColumnObjects() {
            boolean bl = true;
            Item[] itemArray = this.getViewerColumns();
            ColumnObject[] columnObjectArray = new ColumnObject[itemArray.length];
            int n = 0;
            while (n < itemArray.length) {
                Item item = itemArray[n];
                boolean bl2 = this.getMoveable(item);
                bl = bl && bl2;
                columnObjectArray[n] = new ColumnObject(item, n, this.getColumnName(item), this.getColumnImage(item), this.getColumnWidth(item), bl2, this.getResizable(item), true);
                ++n;
            }
            int[] nArray = this.getColumnOrder();
            this.columnObjects = new ColumnObject[itemArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                this.columnObjects[n2] = columnObjectArray[nArray[n2]];
                ++n2;
            }
            return bl;
        }

        private Image getColumnImage(Item item) {
            if (item instanceof TableColumn) {
                return ((TableColumn)item).getImage();
            }
            if (item instanceof TreeColumn) {
                return ((TreeColumn)item).getImage();
            }
            return null;
        }

        private int[] getColumnOrder() {
            if (this.targetControl instanceof Table) {
                return ((Table)this.targetControl).getColumnOrder();
            }
            if (this.targetControl instanceof Tree) {
                return ((Tree)this.targetControl).getColumnOrder();
            }
            return new int[0];
        }

        private boolean getMoveable(Item item) {
            if (item instanceof TableColumn) {
                return ((TableColumn)item).getMoveable();
            }
            if (item instanceof TreeColumn) {
                return ((TreeColumn)item).getMoveable();
            }
            return false;
        }

        private boolean getResizable(Item item) {
            if (item instanceof TableColumn) {
                return ((TableColumn)item).getResizable();
            }
            if (item instanceof TreeColumn) {
                return ((TreeColumn)item).getResizable();
            }
            return false;
        }

        @Override
        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.table = new Table(composite2, 2820);
            int n = 0;
            while (n < this.columnObjects.length) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(this.columnObjects[n].name);
                tableItem.setImage(this.columnObjects[n].image);
                tableItem.setData((Object)this.columnObjects[n]);
                ++n;
            }
            GridDataFactory.defaultsFor((Control)this.table).span(1, this.moveableColumnsFound ? 3 : 1).applyTo((Control)this.table);
            if (this.moveableColumnsFound) {
                this.upButton = new Button(composite2, 8);
                this.upButton.setText(JFaceResources.getString("ConfigureColumnsDialog_up"));
                this.upButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        ConfigureColumnsDialog.this.handleMove(ConfigureColumnsDialog.this.table, true);
                    }
                });
                this.setButtonLayoutData(this.upButton);
                this.downButton = new Button(composite2, 8);
                this.downButton.setText(JFaceResources.getString("ConfigureColumnsDialog_down"));
                this.downButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        ConfigureColumnsDialog.this.handleMove(ConfigureColumnsDialog.this.table, false);
                    }
                });
                this.setButtonLayoutData(this.downButton);
                this.createLabel(composite2, "");
            }
            Composite composite3 = new Composite(composite2, 0);
            this.createLabel(composite3, JFaceResources.getString("ConfigureColumnsDialog_WidthOfSelectedColumn"));
            this.text = new Text(composite3, 2052);
            this.text.setText(Integer.toString(1000));
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite3);
            int n2 = this.moveableColumnsFound ? 2 : 1;
            GridDataFactory.defaultsFor((Control)composite3).grab(false, false).span(n2, 1).applyTo((Control)composite3);
            GridLayoutFactory.swtDefaults().numColumns(n2).applyTo(composite2);
            this.table.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ConfigureColumnsDialog.this.handleSelectionChanged(ConfigureColumnsDialog.this.table.indexOf((TableItem)event.item));
                }
            });
            this.text.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    ColumnObject columnObject = ConfigureColumnsDialog.this.columnObjects[ConfigureColumnsDialog.this.table.getSelectionIndex()];
                    if (!columnObject.resizable) {
                        return;
                    }
                    try {
                        int n;
                        columnObject.width = n = Integer.parseInt(ConfigureColumnsDialog.this.text.getText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            });
            Dialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        protected void handleMove(Table table, boolean bl) {
            int n = table.getSelectionIndex();
            int n2 = n + (bl ? -1 : 1);
            if (n < 0 || n >= table.getItemCount()) {
                return;
            }
            ColumnObject columnObject = this.columnObjects[n];
            this.columnObjects[n] = this.columnObjects[n2];
            this.columnObjects[n2] = columnObject;
            table.getItem(n).dispose();
            TableItem tableItem = new TableItem(table, 0, n2);
            tableItem.setText(columnObject.name);
            tableItem.setImage(columnObject.image);
            tableItem.setData((Object)columnObject);
            table.setSelection(n2);
            this.handleSelectionChanged(n2);
        }

        private void createLabel(Composite composite, String string) {
            Label label = new Label(composite, 0);
            label.setText(string);
        }

        private String getColumnName(Item item) {
            String string = "";
            if (item instanceof TableColumn) {
                string = ((TableColumn)item).getText();
                if (string.trim().equals("")) {
                    string = ((TableColumn)item).getToolTipText();
                }
            } else if (item instanceof TreeColumn && (string = ((TreeColumn)item).getText()).trim().equals("")) {
                string = ((TreeColumn)item).getToolTipText();
            }
            return string;
        }

        private int getColumnWidth(Item item) {
            if (item instanceof TableColumn) {
                return ((TableColumn)item).getWidth();
            }
            if (item instanceof TreeColumn) {
                return ((TreeColumn)item).getWidth();
            }
            return 0;
        }

        private Item[] getViewerColumns() {
            if (this.targetControl instanceof Table) {
                return ((Table)this.targetControl).getColumns();
            }
            if (this.targetControl instanceof Tree) {
                return ((Tree)this.targetControl).getColumns();
            }
            return new Item[0];
        }

        private void handleSelectionChanged(int n) {
            ColumnObject columnObject = this.columnObjects[n];
            this.text.setText(Integer.toString(columnObject.width));
            this.text.setEnabled(columnObject.resizable);
            if (this.moveableColumnsFound) {
                this.upButton.setEnabled(columnObject.moveable && n > 0);
                this.downButton.setEnabled(columnObject.moveable && n + 1 < this.table.getItemCount());
            }
        }

        @Override
        protected void okPressed() {
            int[] nArray = new int[this.columnObjects.length];
            int n = 0;
            while (n < this.columnObjects.length) {
                ColumnObject columnObject = this.columnObjects[n];
                nArray[n] = columnObject.index;
                this.setColumnWidth(columnObject.column, columnObject.width);
                ++n;
            }
            this.setColumnOrder(nArray);
            super.okPressed();
        }

        private void setColumnWidth(Item item, int n) {
            if (item instanceof TableColumn) {
                ((TableColumn)item).setWidth(n);
            } else if (item instanceof TreeColumn) {
                ((TreeColumn)item).setWidth(n);
            }
        }

        private void setColumnOrder(int[] nArray) {
            if (this.targetControl instanceof Table) {
                ((Table)this.targetControl).setColumnOrder(nArray);
            } else if (this.targetControl instanceof Tree) {
                ((Tree)this.targetControl).setColumnOrder(nArray);
            }
        }

        class ColumnObject {
            Item column;
            int index;
            String name;
            Image image;
            boolean visible;
            int width;
            boolean moveable;
            boolean resizable;

            ColumnObject(Item item, int n, String string, Image image, int n2, boolean bl, boolean bl2, boolean bl3) {
                this.column = item;
                this.index = n;
                this.name = string;
                this.image = image;
                this.width = n2;
                this.moveable = bl;
                this.resizable = bl2;
                this.visible = bl3;
            }
        }
    }
}

