/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

class URLImageDescriptor
extends ImageDescriptor {
    private static final Logger LOG = Logger.getLogger(ImageDescriptor.class.getName());
    private static final String FILE_PROTOCOL = "file";
    private URL url;

    URLImageDescriptor(URL uRL) {
        this.url = uRL;
    }

    public boolean equals(Object object) {
        if (!(object instanceof URLImageDescriptor)) {
            return false;
        }
        return ((URLImageDescriptor)object).url.toExternalForm().equals(this.url.toExternalForm());
    }

    @Override
    public ImageData getImageData() {
        ImageData imageData = null;
        InputStream inputStream = this.getStream();
        if (inputStream != null) {
            try {
                try {
                    imageData = new ImageData(inputStream);
                }
                catch (SWTException sWTException) {
                    if (sWTException.code != 40) {
                        throw sWTException;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", iOException.getLocalizedMessage(), (Throwable)iOException));
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", iOException.getLocalizedMessage(), (Throwable)iOException));
                }
            }
        }
        return imageData;
    }

    protected InputStream getStream() {
        try {
            return new BufferedInputStream(this.url.openStream());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.url.toExternalForm().hashCode();
    }

    public String toString() {
        return "URLImageDescriptor(" + this.url + ")";
    }

    private String getFilePath() {
        block12: {
            try {
                if (InternalPolicy.OSGI_AVAILABLE) break block12;
                if (FILE_PROTOCOL.equalsIgnoreCase(this.url.getProtocol())) {
                    return new Path(this.url.getFile()).toOSString();
                }
                return null;
            }
            catch (IOException iOException) {
                Policy.logException(iOException);
                return null;
            }
        }
        URL uRL = FileLocator.toFileURL((URL)this.url);
        final Display[] displayArray = new Display[]{Display.getCurrent()};
        if (displayArray[0] == null) {
            displayArray[0] = Display.getDefault();
        }
        final Point[] pointArray = new Point[1];
        if (displayArray[0].getThread().equals(Thread.currentThread())) {
            pointArray[0] = displayArray[0].getDPI();
        } else {
            displayArray[0].syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!displayArray[0].isDisposed()) {
                        pointArray[0] = displayArray[0].getDPI();
                    }
                }
            });
        }
        if (pointArray[0].x >= 144 || pointArray[0].y >= 144) {
            String string = this.url.getFile();
            int n = string.length();
            int n2 = string.lastIndexOf(46);
            if (n2 > 0 && n2 < n - 1) {
                String string2 = String.valueOf(string.substring(0, n2)) + "@2x" + string.substring(n2);
                try {
                    FileLocator.toFileURL((URL)new URL(this.url.getProtocol(), this.url.getHost(), string2));
                }
                catch (IOException iOException) {
                    LOG.info(String.valueOf(string2) + " cannot be found.");
                }
            }
        }
        if (FILE_PROTOCOL.equalsIgnoreCase(uRL.getProtocol())) {
            return new Path(uRL.getPath()).toOSString();
        }
        return null;
    }

    @Override
    public Image createImage(boolean bl, Device device) {
        String string = this.getFilePath();
        if (string == null) {
            return super.createImage(bl, device);
        }
        try {
            return new Image(device, string);
        }
        catch (SWTException sWTException) {
            return super.createImage(bl, device);
        }
    }
}

