/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

class RGBColorDescriptor
extends ColorDescriptor {
    private RGB color;
    private Color originalColor = null;

    public RGBColorDescriptor(RGB rGB) {
        this.color = rGB;
    }

    public RGBColorDescriptor(Color color) {
        this(color.getRGB());
        this.originalColor = color;
    }

    public boolean equals(Object object) {
        if (object instanceof RGBColorDescriptor) {
            RGBColorDescriptor rGBColorDescriptor = (RGBColorDescriptor)object;
            return rGBColorDescriptor.color.equals((Object)this.color) && rGBColorDescriptor.originalColor == this.originalColor;
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    @Override
    public Color createColor(Device device) {
        if (this.originalColor != null && this.originalColor.getDevice() == device) {
            return this.originalColor;
        }
        return new Color(device, this.color);
    }

    @Override
    public void destroyColor(Color color) {
        if (color == this.originalColor) {
            return;
        }
        color.dispose();
    }
}

