/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.internal.JFaceActivator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class JFaceResources {
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private static final Map registries = new HashMap();
    public static final String BANNER_FONT = "org.eclipse.jface.bannerfont";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.jface.messages");
    private static ColorRegistry colorRegistry;
    public static final String DEFAULT_FONT = "org.eclipse.jface.defaultfont";
    public static final String DIALOG_FONT = "org.eclipse.jface.dialogfont";
    private static FontRegistry fontRegistry;
    public static final String HEADER_FONT = "org.eclipse.jface.headerfont";
    private static ImageRegistry imageRegistry;
    public static final String TEXT_FONT = "org.eclipse.jface.textfont";
    public static final String VIEWER_FONT = "org.eclipse.jface.viewerfont";
    public static final String WINDOW_FONT = "org.eclipse.jface.windowfont";

    static {
        fontRegistry = null;
        imageRegistry = null;
    }

    public static String format(String string, Object[] objectArray) {
        return MessageFormat.format(JFaceResources.getString(string), objectArray);
    }

    public static Font getBannerFont() {
        return JFaceResources.getFontRegistry().get(BANNER_FONT);
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry();
            JFaceResources.initializeDefaultColors();
        }
        return colorRegistry;
    }

    public static ResourceManager getResources(final Display display) {
        ResourceManager resourceManager = (ResourceManager)registries.get(display);
        if (resourceManager == null) {
            final DeviceResourceManager deviceResourceManager = new DeviceResourceManager((Device)display);
            resourceManager = deviceResourceManager;
            registries.put(display, resourceManager);
            display.disposeExec(new Runnable(){

                @Override
                public void run() {
                    deviceResourceManager.dispose();
                    registries.remove(display);
                }
            });
        }
        return resourceManager;
    }

    public static ResourceManager getResources() {
        return JFaceResources.getResources(Display.getCurrent());
    }

    public static Font getDefaultFont() {
        return JFaceResources.getFontRegistry().defaultFont();
    }

    public static FontDescriptor getDefaultFontDescriptor() {
        return JFaceResources.getFontRegistry().defaultFontDescriptor();
    }

    public static Font getDialogFont() {
        return JFaceResources.getFontRegistry().get(DIALOG_FONT);
    }

    public static FontDescriptor getDialogFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(DIALOG_FONT);
    }

    public static Font getFont(String string) {
        return JFaceResources.getFontRegistry().get(string);
    }

    public static FontDescriptor getFontDescriptor(String string) {
        return JFaceResources.getFontRegistry().getDescriptor(string);
    }

    public static FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry("org.eclipse.jface.resource.jfacefonts");
        }
        return fontRegistry;
    }

    public static Font getHeaderFont() {
        return JFaceResources.getFontRegistry().get(HEADER_FONT);
    }

    public static FontDescriptor getHeaderFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(HEADER_FONT);
    }

    public static Image getImage(String string) {
        return JFaceResources.getImageRegistry().get(string);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(JFaceResources.getResources(Display.getCurrent()));
            JFaceResources.initializeDefaultImages();
        }
        return imageRegistry;
    }

    private static void initializeDefaultImages() {
        Bundle bundle = null;
        try {
            bundle = JFaceActivator.getBundle();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        JFaceResources.declareImage(bundle, "org.eclipse.jface.wizard.Wizard.pageImage", "$nl$/icons/full/page.gif", Wizard.class, "images/page.gif");
        JFaceResources.declareImage(bundle, "dialog_messasge_info_image", "$nl$/icons/full/dialog-info.png", Dialog.class, "images/dialog-info.png");
        JFaceResources.declareImage(bundle, "dialog_messasge_warning_image", "$nl$/icons/full/dialog-warning.png", Dialog.class, "images/dialog-warning.png");
        JFaceResources.declareImage(bundle, "dialog_message_error_image", "$nl$/icons/full/dialog-error.png", Dialog.class, "images/dialog-error.png");
        JFaceResources.declareImage(bundle, "dialog_help_image", "$nl$/icons/full/dialog-help.png", Dialog.class, "images/dialog-help.png");
        JFaceResources.declareImage(bundle, "dialog_title_banner_image", "$nl$/icons/full/title_banner.png", TitleAreaDialog.class, "images/title_banner.gif");
        JFaceResources.declareImage(bundle, "preference_dialog_title_image", "$nl$/icons/full/pref_dialog_title.gif", PreferenceDialog.class, "images/pref_dialog_title.gif");
        JFaceResources.declareImage(bundle, "popup_menu_image", "$nl$/icons/full/popup_menu.gif", PopupDialog.class, "images/popup_menu.gif");
        JFaceResources.declareImage(bundle, "popup_menu_image_diabled", "$nl$/icons/full/popup_menu_disabled.gif", PopupDialog.class, "images/popup_menu_disabled.gif");
    }

    private static final void declareImage(Object object, String string, String string2, Class clazz, String string3) {
        URL uRL;
        ImageDescriptor imageDescriptor = null;
        if (object != null && (uRL = FileLocator.find((Bundle)((Bundle)object), (IPath)new Path(string2), null)) != null) {
            imageDescriptor = ImageDescriptor.createFromURL(uRL);
        }
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.createFromFile(clazz, string3);
        }
        imageRegistry.put(string, imageDescriptor);
    }

    public static String getString(String string) {
        try {
            return bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String[] getStrings(String[] stringArray) {
        Assert.isNotNull((Object)stringArray);
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = JFaceResources.getString(stringArray[n2]);
            ++n2;
        }
        return stringArray2;
    }

    public static Font getTextFont() {
        return JFaceResources.getFontRegistry().get(TEXT_FONT);
    }

    public static FontDescriptor getTextFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(TEXT_FONT);
    }

    public static Font getViewerFont() {
        return JFaceResources.getFontRegistry().get(VIEWER_FONT);
    }

    public static void setFontRegistry(FontRegistry fontRegistry) {
        Assert.isTrue((JFaceResources.fontRegistry == null ? 1 : 0) != 0, (String)"Font registry can only be set once.");
        JFaceResources.fontRegistry = fontRegistry;
    }

    private JFaceResources() {
    }

    private static void initializeDefaultColors() {
    }
}

