/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ImageRegistry {
    private Display display;
    private ResourceManager manager;
    private Map table;
    private Runnable disposeRunnable = new Runnable(){

        @Override
        public void run() {
            ImageRegistry.this.dispose();
        }
    };

    public ImageRegistry() {
        this(Display.getCurrent());
    }

    public ImageRegistry(ResourceManager resourceManager) {
        Assert.isNotNull((Object)resourceManager);
        Device device = resourceManager.getDevice();
        if (device instanceof Display) {
            this.display = (Display)device;
        }
        this.manager = resourceManager;
        resourceManager.disposeExec(this.disposeRunnable);
    }

    public ImageRegistry(Display display) {
        this(JFaceResources.getResources(display));
    }

    public Image get(String string) {
        Entry entry;
        if (string == null) {
            return null;
        }
        if (this.display != null) {
            int n = -1;
            if (string.equals("dialog_info_imageg")) {
                n = 2;
            }
            if (string.equals("dialog_question_image")) {
                n = 4;
            }
            if (string.equals("dialog_warning_image")) {
                n = 8;
            }
            if (string.equals("dialog_error_image")) {
                n = 1;
            }
            if (n != -1) {
                final Image[] imageArray = new Image[1];
                final int n2 = n;
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageArray[0] = ImageRegistry.this.display.getSystemImage(n2);
                    }
                });
                return imageArray[0];
            }
        }
        if ((entry = this.getEntry(string)) == null) {
            return null;
        }
        if (entry.image == null) {
            entry.image = this.manager.createImageWithDefault(entry.descriptor);
        }
        return entry.image;
    }

    public ImageDescriptor getDescriptor(String string) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.descriptor;
    }

    public void put(String string, ImageDescriptor imageDescriptor) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            entry = new Entry();
            this.getTable().put(string, entry);
        }
        if (entry.image != null) {
            throw new IllegalArgumentException("ImageRegistry key already in use: " + string);
        }
        entry.descriptor = imageDescriptor;
    }

    public void put(String string, Image image) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            entry = new Entry();
            this.putEntry(string, entry);
        }
        if (entry.image != null || entry.descriptor != null) {
            throw new IllegalArgumentException("ImageRegistry key already in use: " + string);
        }
        Assert.isNotNull((Object)image, (String)"Cannot register a null image.");
        entry.image = image;
        entry.descriptor = new OriginalImageDescriptor(image, this.manager.getDevice());
        try {
            this.manager.create(entry.descriptor);
        }
        catch (DeviceResourceException deviceResourceException) {}
    }

    public void remove(String string) {
        ImageDescriptor imageDescriptor = this.getDescriptor(string);
        if (imageDescriptor != null) {
            this.manager.destroy(imageDescriptor);
            this.getTable().remove(string);
        }
    }

    private Entry getEntry(String string) {
        return (Entry)this.getTable().get(string);
    }

    private void putEntry(String string, Entry entry) {
        this.getTable().put(string, entry);
    }

    private Map getTable() {
        if (this.table == null) {
            this.table = new HashMap(10);
        }
        return this.table;
    }

    public void dispose() {
        this.manager.cancelDisposeExec(this.disposeRunnable);
        if (this.table != null) {
            for (Entry entry : this.table.values()) {
                if (entry.image == null) continue;
                this.manager.destroyImage(entry.descriptor);
            }
            this.table = null;
        }
        this.display = null;
    }

    private static class Entry {
        protected Image image;
        protected ImageDescriptor descriptor;

        private Entry() {
        }
    }

    private static class OriginalImageDescriptor
    extends ImageDescriptor {
        private Image original;
        private int refCount = 0;
        private Device originalDisplay;

        public OriginalImageDescriptor(Image image, Device device) {
            this.original = image;
            this.originalDisplay = device;
        }

        @Override
        public Object createResource(Device device) throws DeviceResourceException {
            if (device == this.originalDisplay) {
                ++this.refCount;
                return this.original;
            }
            return super.createResource(device);
        }

        @Override
        public void destroyResource(Object object) {
            if (this.original == object) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.original.dispose();
                    this.original = null;
                }
            } else {
                super.destroyResource(object);
            }
        }

        @Override
        public ImageData getImageData() {
            return this.original.getImageData();
        }
    }
}

