/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

class ImageDataImageDescriptor
extends ImageDescriptor {
    private ImageData data;
    private Image originalImage = null;

    ImageDataImageDescriptor(Image image) {
        this(image.getImageData());
        this.originalImage = image;
    }

    ImageDataImageDescriptor(ImageData imageData) {
        this.data = imageData;
    }

    @Override
    public Object createResource(Device device) throws DeviceResourceException {
        if (this.originalImage != null && this.originalImage.getDevice() == device) {
            return this.originalImage;
        }
        return super.createResource(device);
    }

    @Override
    public void destroyResource(Object object) {
        if (object == this.originalImage) {
            return;
        }
        super.destroyResource(object);
    }

    @Override
    public ImageData getImageData() {
        return this.data;
    }

    public int hashCode() {
        if (this.originalImage != null) {
            return System.identityHashCode(this.originalImage);
        }
        return this.data.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageDataImageDescriptor)) {
            return false;
        }
        ImageDataImageDescriptor imageDataImageDescriptor = (ImageDataImageDescriptor)object;
        if (this.originalImage != null) {
            return imageDataImageDescriptor.originalImage == this.originalImage;
        }
        return imageDataImageDescriptor.originalImage == null && this.data.equals(imageDataImageDescriptor.data);
    }
}

