/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

class FileImageDescriptor
extends ImageDescriptor {
    private Class location;
    private String name;

    FileImageDescriptor(Class clazz, String string) {
        this.location = clazz;
        this.name = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileImageDescriptor)) {
            return false;
        }
        FileImageDescriptor fileImageDescriptor = (FileImageDescriptor)object;
        if (this.location != null ? !this.location.equals(fileImageDescriptor.location) : fileImageDescriptor.location != null) {
            return false;
        }
        return this.name.equals(fileImageDescriptor.name);
    }

    @Override
    public ImageData getImageData() {
        ImageData imageData;
        block13: {
            InputStream inputStream = this.getStream();
            imageData = null;
            if (inputStream != null) {
                try {
                    try {
                        imageData = new ImageData(inputStream);
                    }
                    catch (SWTException sWTException) {
                        if (sWTException.code != 40) {
                            throw sWTException;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageData;
    }

    private InputStream getStream() {
        InputStream inputStream = null;
        if (this.location != null) {
            inputStream = this.location.getResourceAsStream(this.name);
        } else {
            try {
                inputStream = new FileInputStream(this.name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (inputStream == null) {
            return null;
        }
        return new BufferedInputStream(inputStream);
    }

    public int hashCode() {
        int n = this.name.hashCode();
        if (this.location != null) {
            n += this.location.hashCode();
        }
        return n;
    }

    public String toString() {
        return "FileImageDescriptor(location=" + this.location + ", name=" + this.name + ")";
    }

    @Override
    public Image createImage(boolean bl, Device device) {
        String string = this.getFilePath();
        if (string == null) {
            return this.createDefaultImage(bl, device);
        }
        try {
            return new Image(device, string);
        }
        catch (SWTException sWTException) {
            return super.createImage(bl, device);
        }
    }

    private Image createDefaultImage(boolean bl, Device device) {
        try {
            if (bl) {
                return new Image(device, DEFAULT_IMAGE_DATA);
            }
        }
        catch (SWTException sWTException) {
            return null;
        }
        return null;
    }

    private String getFilePath() {
        if (this.location == null) {
            return new Path(this.name).toOSString();
        }
        URL uRL = this.location.getResource(this.name);
        if (uRL == null) {
            return null;
        }
        try {
            if (!InternalPolicy.OSGI_AVAILABLE) {
                return new Path(uRL.getFile()).toOSString();
            }
            return new Path(FileLocator.toFileURL((URL)uRL).getPath()).toOSString();
        }
        catch (IOException iOException) {
            Policy.logException(iOException);
            return null;
        }
    }
}

