/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public abstract class CompositeImageDescriptor
extends ImageDescriptor {
    private ImageData imageData;

    protected CompositeImageDescriptor() {
    }

    protected abstract void drawCompositeImage(int var1, int var2);

    protected final void drawImage(ImageData imageData, int n, int n2) {
        ImageData imageData2 = this.imageData;
        PaletteData paletteData = imageData.palette;
        ImageData imageData3 = null;
        int n3 = 0;
        int n4 = 0;
        if (imageData.maskData != null) {
            imageData3 = imageData.getTransparencyMask();
            if (imageData.depth == 32) {
                n3 = ~(paletteData.redMask | paletteData.greenMask | paletteData.blueMask);
                while (n3 != 0 && (n3 >>> n4 & 1) == 0) {
                    ++n4;
                }
            }
        }
        int n5 = 0;
        int n6 = n5 + n2;
        while (n5 < imageData.height) {
            int n7 = 0;
            int n8 = n7 + n;
            while (n7 < imageData.width) {
                if (n8 >= 0 && n8 < imageData2.width && n6 >= 0 && n6 < imageData2.height) {
                    int n9 = imageData.getPixel(n7, n5);
                    int n10 = 255;
                    if (imageData.maskData != null) {
                        if (imageData.depth == 32) {
                            n10 = (n9 & n3) >>> n4;
                            if (n10 == 0) {
                                n10 = imageData3.getPixel(n7, n5) != 0 ? 255 : 0;
                            }
                        } else if (imageData3.getPixel(n7, n5) == 0) {
                            n10 = 0;
                        }
                    } else if (imageData.transparentPixel != -1) {
                        if (imageData.transparentPixel == n9) {
                            n10 = 0;
                        }
                    } else if (imageData.alpha != -1) {
                        n10 = imageData.alpha;
                    } else if (imageData.alphaData != null) {
                        n10 = imageData.getAlpha(n7, n5);
                    }
                    if (n10 != 0) {
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        if (paletteData.isDirect) {
                            n17 = n9 & paletteData.redMask;
                            n17 = paletteData.redShift < 0 ? n17 >>> -paletteData.redShift : n17 << paletteData.redShift;
                            n16 = n9 & paletteData.greenMask;
                            n16 = paletteData.greenShift < 0 ? n16 >>> -paletteData.greenShift : n16 << paletteData.greenShift;
                            n15 = n9 & paletteData.blueMask;
                            n15 = paletteData.blueShift < 0 ? n15 >>> -paletteData.blueShift : n15 << paletteData.blueShift;
                        } else {
                            RGB rGB = paletteData.getRGB(n9);
                            n17 = rGB.red;
                            n16 = rGB.green;
                            n15 = rGB.blue;
                        }
                        if (n10 == 255) {
                            n14 = n17;
                            n13 = n16;
                            n12 = n15;
                            n11 = n10;
                        } else {
                            int n18 = imageData2.getPixel(n8, n6);
                            n11 = imageData2.getAlpha(n8, n6);
                            n14 = (n18 & 0xFF) >>> 0;
                            n13 = (n18 & 0xFF00) >>> 8;
                            n12 = (n18 & 0xFF0000) >>> 16;
                            if (n11 == 255) {
                                n14 += (n17 - n14) * n10 / 255;
                                n13 += (n16 - n13) * n10 / 255;
                                n12 += (n15 - n12) * n10 / 255;
                            } else {
                                n14 = n17 * n10 * 255 + n14 * n11 * (255 - n10);
                                n13 = n16 * n10 * 255 + n13 * n11 * (255 - n10);
                                n12 = n15 * n10 * 255 + n12 * n11 * (255 - n10);
                                if ((n11 = n10 * 255 + n11 * (255 - n10)) != 0) {
                                    n14 /= n11;
                                    n13 /= n11;
                                    n12 /= n11;
                                    n11 /= 255;
                                }
                            }
                        }
                        imageData2.setPixel(n8, n6, (n14 & 0xFF) << 0 | (n13 & 0xFF) << 8 | (n12 & 0xFF) << 16);
                        imageData2.setAlpha(n8, n6, n11);
                    }
                }
                ++n7;
                ++n8;
            }
            ++n5;
            ++n6;
        }
    }

    @Override
    public ImageData getImageData() {
        Point point = this.getSize();
        this.imageData = new ImageData(point.x, point.y, 24, new PaletteData(255, 65280, 0xFF0000));
        this.imageData.alphaData = new byte[this.imageData.width * this.imageData.height];
        this.drawCompositeImage(point.x, point.y);
        boolean bl = false;
        byte[] byArray = this.imageData.alphaData;
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 != 0 && n2 != 255) {
                return this.imageData;
            }
            if (!bl && n2 == 0) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            PaletteData paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
            ImageData imageData = new ImageData(this.imageData.width, this.imageData.height, 1, paletteData);
            int n3 = 0;
            while (n3 < imageData.height) {
                int n4 = 0;
                while (n4 < imageData.width) {
                    imageData.setPixel(n4, n3, this.imageData.getAlpha(n4, n3) == 255 ? 1 : 0);
                    ++n4;
                }
                ++n3;
            }
        } else {
            this.imageData.alphaData = null;
        }
        return this.imageData;
    }

    protected int getTransparentPixel() {
        return 0;
    }

    protected abstract Point getSize();

    protected void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }
}

