/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

final class ArrayFontDescriptor
extends FontDescriptor {
    private FontData[] data;
    private Font originalFont = null;

    public ArrayFontDescriptor(FontData[] fontDataArray) {
        this.data = fontDataArray;
    }

    public ArrayFontDescriptor(Font font) {
        this(font.getFontData());
        this.originalFont = font;
    }

    @Override
    public FontData[] getFontData() {
        return ArrayFontDescriptor.copy(this.data);
    }

    @Override
    public Font createFont(Device device) {
        if (this.originalFont != null && this.originalFont.getDevice() == device) {
            return this.originalFont;
        }
        return new Font(device, this.data);
    }

    public boolean equals(Object object) {
        if (object.getClass() == ArrayFontDescriptor.class) {
            ArrayFontDescriptor arrayFontDescriptor = (ArrayFontDescriptor)object;
            if (arrayFontDescriptor.originalFont != this.originalFont) {
                return false;
            }
            if (this.originalFont != null) {
                return true;
            }
            if (this.data.length != arrayFontDescriptor.data.length) {
                return false;
            }
            int n = 0;
            while (n < this.data.length) {
                FontData fontData = this.data[n];
                FontData fontData2 = arrayFontDescriptor.data[n];
                if (!fontData.equals((Object)fontData2)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.originalFont != null) {
            return this.originalFont.hashCode();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.data.length) {
            FontData fontData = this.data[n2];
            n += fontData.hashCode();
            ++n2;
        }
        return n;
    }

    @Override
    public void destroyFont(Font font) {
        if (font == this.originalFont) {
            return;
        }
        font.dispose();
    }
}

