/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ResourceManager;

abstract class AbstractResourceManager
extends ResourceManager {
    private HashMap map = null;

    AbstractResourceManager() {
    }

    protected abstract Object allocate(DeviceResourceDescriptor var1) throws DeviceResourceException;

    protected abstract void deallocate(Object var1, DeviceResourceDescriptor var2);

    @Override
    public final Object create(DeviceResourceDescriptor deviceResourceDescriptor) throws DeviceResourceException {
        RefCount refCount;
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((refCount = (RefCount)this.map.get(deviceResourceDescriptor)) != null) {
            ++refCount.count;
            return refCount.resource;
        }
        Object object = this.allocate(deviceResourceDescriptor);
        refCount = new RefCount(object);
        this.map.put(deviceResourceDescriptor, refCount);
        return object;
    }

    @Override
    public final void destroy(DeviceResourceDescriptor deviceResourceDescriptor) {
        if (this.map == null) {
            return;
        }
        RefCount refCount = (RefCount)this.map.get(deviceResourceDescriptor);
        if (refCount != null) {
            --refCount.count;
            if (refCount.count == 0) {
                this.deallocate(refCount.resource, deviceResourceDescriptor);
                this.map.remove(deviceResourceDescriptor);
            }
        }
        if (this.map.isEmpty()) {
            this.map = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.map == null) {
            return;
        }
        Set set = this.map.entrySet();
        for (Map.Entry entry : set) {
            Object k = entry.getKey();
            RefCount refCount = (RefCount)entry.getValue();
            this.deallocate(refCount.resource, (DeviceResourceDescriptor)k);
        }
        this.map = null;
    }

    @Override
    public Object find(DeviceResourceDescriptor deviceResourceDescriptor) {
        if (this.map == null) {
            return null;
        }
        RefCount refCount = (RefCount)this.map.get(deviceResourceDescriptor);
        if (refCount == null) {
            return null;
        }
        return refCount.resource;
    }

    private static class RefCount {
        Object resource;
        int count = 1;

        RefCount(Object object) {
            this.resource = object;
        }
    }
}

