/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class StringFieldEditor
extends FieldEditor {
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    protected String oldValue;
    Text textField;
    private int widthInChars = UNLIMITED;
    private int textLimit = UNLIMITED;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private int validateStrategy = 0;

    protected StringFieldEditor() {
    }

    public StringFieldEditor(String string, String string2, int n, int n2, Composite composite) {
        this.init(string, string2);
        this.widthInChars = n;
        this.setValidateStrategy(n2);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString("StringFieldEditor.errorMessage");
        this.createControl(composite);
    }

    public StringFieldEditor(String string, String string2, int n, Composite composite) {
        this(string, string2, n, 0, composite);
    }

    public StringFieldEditor(String string, String string2, Composite composite) {
        this(string, string2, UNLIMITED, composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        GridData gridData = (GridData)this.textField.getLayoutData();
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = gridData.horizontalSpan == 1;
    }

    protected boolean checkState() {
        String string;
        boolean bl = false;
        if (this.emptyStringAllowed) {
            bl = true;
        }
        if (this.textField == null) {
            bl = false;
        }
        bl = (string = this.textField.getText()).trim().length() > 0 || this.emptyStringAllowed;
        boolean bl2 = bl = bl && this.doCheckState();
        if (bl) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return bl;
    }

    protected boolean doCheckState() {
        return true;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        this.getLabelControl(composite);
        this.textField = this.getTextControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n - 1;
        if (this.widthInChars != UNLIMITED) {
            GC gC = new GC((Drawable)this.textField);
            try {
                Point point = gC.textExtent("X");
                gridData.widthHint = this.widthInChars * point.x;
            }
            finally {
                gC.dispose();
            }
        } else {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        this.textField.setLayoutData((Object)gridData);
    }

    @Override
    protected void doLoad() {
        if (this.textField != null) {
            String string = this.getPreferenceStore().getString(this.getPreferenceName());
            this.textField.setText(string);
            this.oldValue = string;
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.textField != null) {
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.textField.setText(string);
        }
        this.valueChanged();
    }

    @Override
    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.textField.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Text getTextControl() {
        return this.textField;
    }

    public Text getTextControl(Composite composite) {
        if (this.textField == null) {
            this.textField = new Text(composite, 2052);
            this.textField.setFont(composite.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent keyEvent) {
                            StringFieldEditor.this.valueChanged();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent focusEvent) {
                            StringFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent keyEvent) {
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent focusEvent) {
                            StringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent focusEvent) {
                            StringFieldEditor.this.valueChanged();
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    StringFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, composite);
        }
        return this.textField;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean bl) {
        this.emptyStringAllowed = bl;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    @Override
    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String string) {
        if (this.textField != null) {
            if (string == null) {
                string = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(string)) {
                this.textField.setText(string);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int n) {
        this.textLimit = n;
        if (this.textField != null) {
            this.textField.setTextLimit(n);
        }
    }

    public void setValidateStrategy(int n) {
        Assert.isTrue((n == 1 || n == 0 ? 1 : 0) != 0);
        this.validateStrategy = n;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String string;
        this.setPresentsDefaultValue(false);
        boolean bl = this.isValid;
        this.refreshValidState();
        if (this.isValid != bl) {
            this.fireStateChanged("field_editor_is_valid", bl, this.isValid);
        }
        if (!(string = this.textField.getText()).equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, string);
            this.oldValue = string;
        }
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.getTextControl(composite).setEnabled(bl);
    }
}

