/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class StringButtonFieldEditor
extends StringFieldEditor {
    private Button changeButton;
    private String changeButtonText;

    protected StringButtonFieldEditor() {
    }

    protected StringButtonFieldEditor(String string, String string2, Composite composite) {
        this.init(string, string2);
        this.createControl(composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        ((GridData)this.getTextControl().getLayoutData()).horizontalSpan = n - 2;
    }

    protected abstract String changePressed();

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        super.doFillIntoGrid(composite, n - 1);
        this.changeButton = this.getChangeControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        int n2 = this.convertHorizontalDLUsToPixels((Control)this.changeButton, 61);
        gridData.widthHint = Math.max(n2, this.changeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeButton.setLayoutData((Object)gridData);
    }

    protected Button getChangeControl(Composite composite) {
        if (this.changeButton == null) {
            this.changeButton = new Button(composite, 8);
            if (this.changeButtonText == null) {
                this.changeButtonText = JFaceResources.getString("openChange");
            }
            this.changeButton.setText(this.changeButtonText);
            this.changeButton.setFont(composite.getFont());
            this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = StringButtonFieldEditor.this.changePressed();
                    if (string != null) {
                        StringButtonFieldEditor.this.setStringValue(string);
                    }
                }
            });
            this.changeButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    StringButtonFieldEditor.this.changeButton = null;
                }
            });
        } else {
            this.checkParent((Control)this.changeButton, composite);
        }
        return this.changeButton;
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    protected Shell getShell() {
        if (this.changeButton == null) {
            return null;
        }
        return this.changeButton.getShell();
    }

    public void setChangeButtonText(String string) {
        Assert.isNotNull((Object)string);
        this.changeButtonText = string;
        if (this.changeButton != null) {
            this.changeButton.setText(string);
            Point point = this.changeButton.computeSize(-1, -1);
            GridData gridData = (GridData)this.changeButton.getLayoutData();
            gridData.widthHint = Math.max(-1, point.x);
        }
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        if (this.changeButton != null) {
            this.changeButton.setEnabled(bl);
        }
    }
}

