/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;

public class ScaleFieldEditor
extends FieldEditor {
    private int incrementValue;
    private int maxValue;
    private int minValue;
    private int oldValue;
    private int pageIncrementValue;
    protected Scale scale;

    public ScaleFieldEditor(String string, String string2, Composite composite) {
        super(string, string2, composite);
        this.setDefaultValues();
    }

    public ScaleFieldEditor(String string, String string2, Composite composite, int n, int n2, int n3, int n4) {
        super(string, string2, composite);
        this.setValues(n, n2, n3, n4);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        ((GridData)this.scale.getLayoutData()).horizontalSpan = n - 1;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.scale = this.getScaleControl(composite);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = true;
        this.scale.setLayoutData((Object)gridData);
        this.updateScale();
    }

    @Override
    protected void doLoad() {
        if (this.scale != null) {
            int n = this.getPreferenceStore().getInt(this.getPreferenceName());
            this.scale.setSelection(n);
            this.oldValue = n;
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.scale != null) {
            int n = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            this.scale.setSelection(n);
        }
        this.valueChanged();
    }

    @Override
    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.scale.getSelection());
    }

    public int getIncrement() {
        return this.incrementValue;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public int getMinimum() {
        return this.minValue;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public int getPageIncrement() {
        return this.pageIncrementValue;
    }

    public Scale getScaleControl() {
        return this.scale;
    }

    private Scale getScaleControl(Composite composite) {
        if (this.scale == null) {
            this.scale = new Scale(composite, 256);
            this.scale.setFont(composite.getFont());
            this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ScaleFieldEditor.this.valueChanged();
                }
            });
            this.scale.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ScaleFieldEditor.this.scale = null;
                }
            });
        } else {
            this.checkParent((Control)this.scale, composite);
        }
        return this.scale;
    }

    private void setDefaultValues() {
        this.setValues(0, 10, 1, 1);
    }

    @Override
    public void setFocus() {
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setFocus();
        }
    }

    public void setIncrement(int n) {
        this.incrementValue = n;
        this.updateScale();
    }

    public void setMaximum(int n) {
        this.maxValue = n;
        this.updateScale();
    }

    public void setMinimum(int n) {
        this.minValue = n;
        this.updateScale();
    }

    public void setPageIncrement(int n) {
        this.pageIncrementValue = n;
        this.updateScale();
    }

    private void setValues(int n, int n2, int n3, int n4) {
        this.incrementValue = n3;
        this.maxValue = n2;
        this.minValue = n;
        this.pageIncrementValue = n4;
        this.updateScale();
    }

    private void updateScale() {
        if (this.scale != null && !this.scale.isDisposed()) {
            this.scale.setMinimum(this.getMinimum());
            this.scale.setMaximum(this.getMaximum());
            this.scale.setIncrement(this.getIncrement());
            this.scale.setPageIncrement(this.getPageIncrement());
        }
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        int n = this.scale.getSelection();
        if (n != this.oldValue) {
            this.fireStateChanged("field_editor_is_valid", false, true);
            this.fireValueChanged("field_editor_value", new Integer(this.oldValue), new Integer(n));
            this.oldValue = n;
        }
    }
}

