/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RadioGroupFieldEditor
extends FieldEditor {
    private String[][] labelsAndValues;
    private int numColumns;
    private int indent = 8;
    private String value;
    private Composite radioBox;
    private Button[] radioButtons;
    private boolean useGroup;

    protected RadioGroupFieldEditor() {
    }

    public RadioGroupFieldEditor(String string, String string2, int n, String[][] stringArray, Composite composite) {
        this(string, string2, n, stringArray, composite, false);
    }

    public RadioGroupFieldEditor(String string, String string2, int n, String[][] stringArray, Composite composite, boolean bl) {
        this.init(string, string2);
        Assert.isTrue((boolean)this.checkArray(stringArray));
        this.labelsAndValues = stringArray;
        this.numColumns = n;
        this.useGroup = bl;
        this.createControl(composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        Label label = this.getLabelControl();
        if (label != null) {
            ((GridData)label.getLayoutData()).horizontalSpan = n;
        }
        ((GridData)this.radioBox.getLayoutData()).horizontalSpan = n;
    }

    private boolean checkArray(String[][] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null || stringArray2.length != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        if (this.useGroup) {
            Composite composite2 = this.getRadioBoxControl(composite);
            GridData gridData = new GridData(768);
            composite2.setLayoutData((Object)gridData);
        } else {
            Label label = this.getLabelControl(composite);
            GridData gridData = new GridData();
            gridData.horizontalSpan = n;
            label.setLayoutData((Object)gridData);
            label = this.getRadioBoxControl(composite);
            gridData = new GridData();
            gridData.horizontalSpan = n;
            gridData.horizontalIndent = this.indent;
            label.setLayoutData((Object)gridData);
        }
    }

    @Override
    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    @Override
    protected void doStore() {
        if (this.value == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    public Composite getRadioBoxControl(Composite composite) {
        if (this.radioBox == null) {
            String[] stringArray;
            String string;
            Group group;
            Font font = composite.getFont();
            if (this.useGroup) {
                group = new Group(composite, 0);
                group.setFont(font);
                string = this.getLabelText();
                if (string != null) {
                    group.setText(string);
                }
                this.radioBox = group;
                stringArray = new GridLayout();
                stringArray.horizontalSpacing = 8;
                stringArray.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)stringArray);
            } else {
                this.radioBox = new Composite(composite, 0);
                group = new GridLayout();
                group.marginWidth = 0;
                group.marginHeight = 0;
                group.horizontalSpacing = 8;
                group.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)group);
                this.radioBox.setFont(font);
            }
            this.radioButtons = new Button[this.labelsAndValues.length];
            int n = 0;
            while (n < this.labelsAndValues.length) {
                string = new Button(this.radioBox, 16400);
                this.radioButtons[n] = string;
                stringArray = this.labelsAndValues[n];
                string.setText(stringArray[0]);
                string.setData((Object)stringArray[1]);
                string.setFont(font);
                string.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        String string = RadioGroupFieldEditor.this.value;
                        RadioGroupFieldEditor.this.value = (String)selectionEvent.widget.getData();
                        RadioGroupFieldEditor.this.setPresentsDefaultValue(false);
                        RadioGroupFieldEditor.this.fireValueChanged("field_editor_value", string, RadioGroupFieldEditor.this.value);
                    }
                });
                ++n;
            }
            this.radioBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    RadioGroupFieldEditor.this.radioBox = null;
                    RadioGroupFieldEditor.this.radioButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.radioBox, composite);
        }
        return this.radioBox;
    }

    public void setIndent(int n) {
        this.indent = n < 0 ? 0 : n;
    }

    private void updateValue(String string) {
        this.value = string;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean bl = false;
            int n = 0;
            while (n < this.radioButtons.length) {
                Button button = this.radioButtons[n];
                boolean bl2 = false;
                if (((String)button.getData()).equals(this.value)) {
                    bl2 = true;
                    bl = true;
                }
                button.setSelection(bl2);
                ++n;
            }
            if (bl) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        if (!this.useGroup) {
            super.setEnabled(bl, composite);
        }
        int n = 0;
        while (n < this.radioButtons.length) {
            this.radioButtons[n].setEnabled(bl);
            ++n;
        }
    }
}

