/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

public class PreferenceStore
extends EventManager
implements IPersistentPreferenceStore {
    private Properties properties;
    private Properties defaultProperties = new Properties();
    private boolean dirty = false;
    private String filename;

    public PreferenceStore() {
        this.properties = new Properties(this.defaultProperties);
    }

    public PreferenceStore(String string) {
        this();
        Assert.isNotNull((Object)string);
        this.filename = string;
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    @Override
    public boolean contains(String string) {
        return this.properties.containsKey(string) || this.defaultProperties.containsKey(string);
    }

    @Override
    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.getListeners();
        if (!(objectArray.length <= 0 || object != null && object.equals(object2))) {
            final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            int n = 0;
            while (n < objectArray.length) {
                final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
                SafeRunnable.run(new SafeRunnable(JFaceResources.getString("PreferenceStore.changeError")){

                    public void run() {
                        iPropertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                });
                ++n;
            }
        }
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(this.properties, string);
    }

    private boolean getBoolean(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return false;
        }
        return string2.equals("true");
    }

    @Override
    public boolean getDefaultBoolean(String string) {
        return this.getBoolean(this.defaultProperties, string);
    }

    @Override
    public double getDefaultDouble(String string) {
        return this.getDouble(this.defaultProperties, string);
    }

    @Override
    public float getDefaultFloat(String string) {
        return this.getFloat(this.defaultProperties, string);
    }

    @Override
    public int getDefaultInt(String string) {
        return this.getInt(this.defaultProperties, string);
    }

    @Override
    public long getDefaultLong(String string) {
        return this.getLong(this.defaultProperties, string);
    }

    @Override
    public String getDefaultString(String string) {
        return this.getString(this.defaultProperties, string);
    }

    @Override
    public double getDouble(String string) {
        return this.getDouble(this.properties, string);
    }

    private double getDouble(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0.0;
        }
        double d = 0.0;
        try {
            d = new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return d;
    }

    @Override
    public float getFloat(String string) {
        return this.getFloat(this.properties, string);
    }

    private float getFloat(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0.0f;
        }
        float f = 0.0f;
        try {
            f = new Float(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return f;
    }

    @Override
    public int getInt(String string) {
        return this.getInt(this.properties, string);
    }

    private int getInt(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    @Override
    public long getLong(String string) {
        return this.getLong(this.properties, string);
    }

    private long getLong(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0L;
        }
        long l = 0L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return l;
    }

    @Override
    public String getString(String string) {
        return this.getString(this.properties, string);
    }

    private String getString(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    @Override
    public boolean isDefault(String string) {
        return !this.properties.containsKey(string) && this.defaultProperties.containsKey(string);
    }

    public void list(PrintStream printStream) {
        this.properties.list(printStream);
    }

    public void list(PrintWriter printWriter) {
        this.properties.list(printWriter);
    }

    public void load() throws IOException {
        if (this.filename == null) {
            throw new IOException("File name not specified");
        }
        FileInputStream fileInputStream = new FileInputStream(this.filename);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public void load(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        this.dirty = false;
    }

    @Override
    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        ArrayList arrayList = new ArrayList();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void putValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.setValue(this.properties, string, string2);
            this.dirty = true;
        }
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    @Override
    public void save() throws IOException {
        if (this.filename == null) {
            throw new IOException("File name not specified");
        }
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(this.filename);
            this.save(fileOutputStream, null);
        }
    }

    public void save(OutputStream outputStream, String string) throws IOException {
        this.properties.store(outputStream, string);
        this.dirty = false;
    }

    @Override
    public void setDefault(String string, double d) {
        this.setValue(this.defaultProperties, string, d);
    }

    @Override
    public void setDefault(String string, float f) {
        this.setValue(this.defaultProperties, string, f);
    }

    @Override
    public void setDefault(String string, int n) {
        this.setValue(this.defaultProperties, string, n);
    }

    @Override
    public void setDefault(String string, long l) {
        this.setValue(this.defaultProperties, string, l);
    }

    @Override
    public void setDefault(String string, String string2) {
        this.setValue(this.defaultProperties, string, string2);
    }

    @Override
    public void setDefault(String string, boolean bl) {
        this.setValue(this.defaultProperties, string, bl);
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    @Override
    public void setToDefault(String string) {
        if (!this.properties.containsKey(string)) {
            return;
        }
        Object object = this.properties.get(string);
        this.properties.remove(string);
        this.dirty = true;
        Object object2 = null;
        if (this.defaultProperties != null) {
            object2 = this.defaultProperties.get(string);
        }
        this.firePropertyChangeEvent(string, object, object2);
    }

    @Override
    public void setValue(String string, double d) {
        double d2 = this.getDouble(string);
        if (d2 != d) {
            this.setValue(this.properties, string, d);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Double(d2), new Double(d));
        }
    }

    @Override
    public void setValue(String string, float f) {
        float f2 = this.getFloat(string);
        if (f2 != f) {
            this.setValue(this.properties, string, f);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Float(f2), new Float(f));
        }
    }

    @Override
    public void setValue(String string, int n) {
        int n2 = this.getInt(string);
        if (n2 != n) {
            this.setValue(this.properties, string, n);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Integer(n2), new Integer(n));
        }
    }

    @Override
    public void setValue(String string, long l) {
        long l2 = this.getLong(string);
        if (l2 != l) {
            this.setValue(this.properties, string, l);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Long(l2), new Long(l));
        }
    }

    @Override
    public void setValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.setValue(this.properties, string, string2);
            this.dirty = true;
            this.firePropertyChangeEvent(string, string3, string2);
        }
    }

    @Override
    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl2 != bl) {
            this.setValue(this.properties, string, bl);
            this.dirty = true;
            this.firePropertyChangeEvent(string, bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private void setValue(Properties properties, String string, double d) {
        Assert.isTrue((properties != null ? 1 : 0) != 0);
        properties.put(string, Double.toString(d));
    }

    private void setValue(Properties properties, String string, float f) {
        Assert.isTrue((properties != null ? 1 : 0) != 0);
        properties.put(string, Float.toString(f));
    }

    private void setValue(Properties properties, String string, int n) {
        Assert.isTrue((properties != null ? 1 : 0) != 0);
        properties.put(string, Integer.toString(n));
    }

    private void setValue(Properties properties, String string, long l) {
        Assert.isTrue((properties != null ? 1 : 0) != 0);
        properties.put(string, Long.toString(l));
    }

    private void setValue(Properties properties, String string, String string2) {
        Assert.isTrue((properties != null && string2 != null ? 1 : 0) != 0);
        properties.put(string, string2);
    }

    private void setValue(Properties properties, String string, boolean bl) {
        Assert.isTrue((properties != null ? 1 : 0) != 0);
        properties.put(string, bl ? "true" : "false");
    }
}

