/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class PreferencePage
extends DialogPage
implements IPreferencePage {
    private IPreferenceStore preferenceStore;
    private boolean isValid = true;
    private Control body;
    private boolean createApplyBtn = false;
    private boolean createDefaultsBtn = true;
    private Button defaultsButton = null;
    private IPreferencePageContainer container = null;
    private Button applyButton = null;
    private Label descriptionLabel;
    private Point size = null;

    protected PreferencePage() {
        this("");
    }

    protected PreferencePage(String string) {
        super(string);
    }

    protected PreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    @Override
    public Point computeSize() {
        if (this.size != null) {
            return this.size;
        }
        Control control = this.getControl();
        if (control != null) {
            this.size = this.doComputeSize();
            return this.size;
        }
        return new Point(0, 0);
    }

    protected void contributeButtons(Composite composite) {
    }

    protected abstract Control createContents(Composite var1);

    @Override
    public void createControl(Composite composite) {
        Point point;
        GridData gridData;
        int n;
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.applyDialogFont(composite2);
        this.initializeDialogUnits((Control)composite2);
        this.descriptionLabel = this.createDescriptionLabel(composite2);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setLayoutData((Object)new GridData(768));
        }
        this.body = this.createContents(composite2);
        if (this.body != null) {
            this.body.setLayoutData((Object)new GridData(1808));
        }
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginRight = 6;
        gridLayout.makeColumnsEqualWidth = false;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(128);
        composite3.setLayoutData((Object)gridData2);
        this.contributeButtons(composite3);
        if (this.createDefaultsBtn) {
            ++gridLayout.numColumns;
            n = this.convertHorizontalDLUsToPixels(61);
            this.defaultsButton = new Button(composite3, 8);
            this.defaultsButton.setText(JFaceResources.getString("defaults"));
            Dialog.applyDialogFont((Control)this.defaultsButton);
            gridData = new GridData(256);
            point = this.defaultsButton.computeSize(-1, -1, true);
            gridData.widthHint = Math.max(n, point.x);
            this.defaultsButton.setLayoutData((Object)gridData);
            this.defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PreferencePage.this.performDefaults();
                }
            });
        }
        if (this.createApplyBtn) {
            ++gridLayout.numColumns;
            n = this.convertHorizontalDLUsToPixels(61);
            this.applyButton = new Button(composite3, 8);
            this.applyButton.setText(JFaceResources.getString("apply"));
            Dialog.applyDialogFont((Control)this.applyButton);
            gridData = new GridData(256);
            point = this.applyButton.computeSize(-1, -1, true);
            gridData.widthHint = Math.max(n, point.x);
            this.applyButton.setLayoutData((Object)gridData);
            this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PreferencePage.this.performApply();
                }
            });
            this.applyButton.setEnabled(this.isValid());
        }
        if (composite3.getChildren().length < 1) {
            composite3.dispose();
        } else {
            this.applyDialogFont(composite3);
        }
    }

    protected void applyDialogFont(Composite composite) {
        Dialog.applyDialogFont((Control)composite);
    }

    protected Label createDescriptionLabel(Composite composite) {
        Label label = null;
        String string = this.getDescription();
        if (string != null) {
            label = new Label(composite, 64);
            label.setFont(composite.getFont());
            label.setText(string);
        }
        return label;
    }

    protected Point doComputeSize() {
        if (this.descriptionLabel != null && this.body != null) {
            Point point = this.body.computeSize(-1, -1, true);
            GridData gridData = (GridData)this.descriptionLabel.getLayoutData();
            gridData.widthHint = point.x;
        }
        return this.getControl().computeSize(-1, -1, true);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return null;
    }

    public IPreferencePageContainer getContainer() {
        return this.container;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = this.doGetPreferenceStore();
        }
        if (this.preferenceStore != null) {
            return this.preferenceStore;
        }
        if (this.container != null) {
            return this.container.getPreferenceStore();
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    protected void noApplyButton() {
        this.createApplyBtn = false;
    }

    protected void noDefaultsButton() {
        this.createDefaultsBtn = false;
    }

    protected void noDefaultAndApplyButton() {
        this.noApplyButton();
        this.noDefaultsButton();
    }

    @Override
    public boolean okToLeave() {
        return this.isValid();
    }

    protected void performApply() {
        this.performOk();
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    protected void performDefaults() {
        this.updateApplyButton();
    }

    @Override
    public boolean performOk() {
        return true;
    }

    @Override
    public void setContainer(IPreferencePageContainer iPreferencePageContainer) {
        this.container = iPreferencePageContainer;
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        this.preferenceStore = iPreferenceStore;
    }

    @Override
    public void setSize(Point point) {
        Control control = this.getControl();
        if (control != null) {
            control.setSize(point);
            this.size = point;
        }
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.getContainer() != null) {
            this.getContainer().updateTitle();
        }
    }

    public void setValid(boolean bl) {
        boolean bl2 = this.isValid;
        this.isValid = bl;
        if (bl2 != this.isValid) {
            if (this.getContainer() != null) {
                this.getContainer().updateButtons();
            }
            this.updateApplyButton();
        }
    }

    public String toString() {
        return this.getTitle();
    }

    protected void updateApplyButton() {
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.isValid());
        }
    }

    protected Composite createNoteComposite(Font font, Composite composite, String string, String string2) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setFont(font);
        Label label = new Label(composite2, 1);
        label.setText(string);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        label.setLayoutData((Object)new GridData(2));
        Label label2 = new Label(composite2, 64);
        label2.setText(string2);
        label2.setFont(font);
        return composite2;
    }

    protected Button getApplyButton() {
        return this.applyButton;
    }

    protected Button getDefaultsButton() {
        return this.defaultsButton;
    }

    @Override
    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    public void applyData(Object object) {
    }

    @Override
    public void setErrorMessage(String string) {
        super.setErrorMessage(string);
        if (this.getContainer() != null) {
            this.getContainer().updateMessage();
        }
    }

    @Override
    public void setMessage(String string, int n) {
        super.setMessage(string, n);
        if (this.getContainer() != null) {
            this.getContainer().updateMessage();
        }
    }
}

