/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PreferenceNode
implements IPreferenceNode {
    private IPreferencePage page;
    private List subNodes;
    private String classname;
    private String id;
    private String label;
    private ImageDescriptor imageDescriptor;
    private Image image;

    public PreferenceNode(String string) {
        Assert.isNotNull((Object)string);
        this.id = string;
    }

    public PreferenceNode(String string, String string2, ImageDescriptor imageDescriptor, String string3) {
        this(string);
        this.imageDescriptor = imageDescriptor;
        Assert.isNotNull((Object)string2);
        this.label = string2;
        this.classname = string3;
    }

    public PreferenceNode(String string, IPreferencePage iPreferencePage) {
        this(string);
        Assert.isNotNull((Object)iPreferencePage);
        this.page = iPreferencePage;
    }

    @Override
    public void add(IPreferenceNode iPreferenceNode) {
        if (this.subNodes == null) {
            this.subNodes = new ArrayList();
        }
        this.subNodes.add(iPreferenceNode);
    }

    private Object createObject(String string) {
        Assert.isNotNull((Object)string);
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                return clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
        return null;
    }

    @Override
    public void createPage() {
        this.page = (IPreferencePage)this.createObject(this.classname);
        if (this.getLabelImage() != null) {
            this.page.setImageDescriptor(this.imageDescriptor);
        }
        this.page.setTitle(this.label);
    }

    @Override
    public void disposeResources() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }

    @Override
    public IPreferenceNode findSubNode(String string) {
        Assert.isNotNull((Object)string);
        Assert.isTrue((string.length() > 0 ? 1 : 0) != 0);
        if (this.subNodes == null) {
            return null;
        }
        int n = this.subNodes.size();
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode iPreferenceNode = (IPreferenceNode)this.subNodes.get(n2);
            if (string.equals(iPreferenceNode.getId())) {
                return iPreferenceNode;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public Image getLabelImage() {
        if (this.image == null && this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    @Override
    public String getLabelText() {
        if (this.page != null) {
            return this.page.getTitle();
        }
        return this.label;
    }

    @Override
    public IPreferencePage getPage() {
        return this.page;
    }

    @Override
    public IPreferenceNode[] getSubNodes() {
        if (this.subNodes == null) {
            return new IPreferenceNode[0];
        }
        return this.subNodes.toArray(new IPreferenceNode[this.subNodes.size()]);
    }

    @Override
    public IPreferenceNode remove(String string) {
        IPreferenceNode iPreferenceNode = this.findSubNode(string);
        if (iPreferenceNode != null) {
            this.remove(iPreferenceNode);
        }
        return iPreferenceNode;
    }

    @Override
    public boolean remove(IPreferenceNode iPreferenceNode) {
        if (this.subNodes == null) {
            return false;
        }
        return this.subNodes.remove(iPreferenceNode);
    }

    public void setPage(IPreferencePage iPreferencePage) {
        this.page = iPreferencePage;
    }
}

