/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceNode;

public class PreferenceManager {
    public static final int PRE_ORDER = 0;
    public static final int POST_ORDER = 1;
    private static final String ROOT_NODE_ID = "";
    PreferenceNode root;
    String separator;

    public PreferenceManager() {
        this('.', new PreferenceNode(ROOT_NODE_ID));
    }

    public PreferenceManager(char c) {
        this(c, new PreferenceNode(ROOT_NODE_ID));
    }

    public PreferenceManager(char c, PreferenceNode preferenceNode) {
        this.separator = new String(new char[]{c});
        this.root = preferenceNode;
    }

    public boolean addTo(String string, IPreferenceNode iPreferenceNode) {
        IPreferenceNode iPreferenceNode2 = this.find(string);
        if (iPreferenceNode2 == null) {
            return false;
        }
        iPreferenceNode2.add(iPreferenceNode);
        return true;
    }

    public void addToRoot(IPreferenceNode iPreferenceNode) {
        Assert.isNotNull((Object)iPreferenceNode);
        this.root.add(iPreferenceNode);
    }

    protected void buildSequence(IPreferenceNode iPreferenceNode, List list, int n) {
        if (n == 0) {
            list.add(iPreferenceNode);
        }
        IPreferenceNode[] iPreferenceNodeArray = iPreferenceNode.getSubNodes();
        int n2 = 0;
        while (n2 < iPreferenceNodeArray.length) {
            this.buildSequence(iPreferenceNodeArray[n2], list, n);
            ++n2;
        }
        if (n == 1) {
            list.add(iPreferenceNode);
        }
    }

    public IPreferenceNode find(String string) {
        return this.find(string, this.root);
    }

    protected IPreferenceNode find(String string, IPreferenceNode iPreferenceNode) {
        Assert.isNotNull((Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.separator);
        IPreferenceNode iPreferenceNode2 = iPreferenceNode;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((iPreferenceNode2 = iPreferenceNode2.findSubNode(string2)) != null) continue;
            return null;
        }
        if (iPreferenceNode2 == iPreferenceNode) {
            return null;
        }
        return iPreferenceNode2;
    }

    public List getElements(int n) {
        Assert.isTrue((n == 0 || n == 1 ? 1 : 0) != 0, (String)"invalid traversal order");
        ArrayList arrayList = new ArrayList();
        IPreferenceNode[] iPreferenceNodeArray = this.getRoot().getSubNodes();
        int n2 = 0;
        while (n2 < iPreferenceNodeArray.length) {
            this.buildSequence(iPreferenceNodeArray[n2], arrayList, n);
            ++n2;
        }
        return arrayList;
    }

    public IPreferenceNode getRoot() {
        return this.root;
    }

    public final IPreferenceNode[] getRootSubNodes() {
        return this.getRoot().getSubNodes();
    }

    public IPreferenceNode remove(String string) {
        Assert.isNotNull((Object)string);
        int n = string.lastIndexOf(this.separator);
        if (n == -1) {
            return this.root.remove(string);
        }
        Assert.isTrue((n < string.length() - 1 ? 1 : 0) != 0, (String)"Path can not end with a dot");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        IPreferenceNode iPreferenceNode = this.find(string2);
        if (iPreferenceNode == null) {
            return null;
        }
        return iPreferenceNode.remove(string3);
    }

    public boolean remove(IPreferenceNode iPreferenceNode) {
        Assert.isNotNull((Object)iPreferenceNode);
        return this.root.remove(iPreferenceNode);
    }

    public void removeAll() {
        this.root = new PreferenceNode(ROOT_NODE_ID);
    }
}

