/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceContentProvider;
import org.eclipse.jface.preference.PreferenceLabelProvider;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class PreferenceDialog
extends TrayDialog
implements IPreferencePageContainer,
IPageChangeProvider {
    private static String lastPreferenceId = null;
    private static int lastTreeWidth = 180;
    public static final String PREF_DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    public static final String PREF_DLG_TITLE_IMG = "preference_dialog_title_image";
    protected static final int FAILED = 2;
    private IPreferencePage currentPage;
    private DialogMessageArea messageArea;
    private Point lastShellSize;
    private IPreferenceNode lastSuccessfulNode;
    private Point minimumPageSize = new Point(400, 400);
    private Button okButton;
    private Composite pageContainer;
    private PreferenceManager preferenceManager;
    private boolean showingError = false;
    private IPreferenceStore preferenceStore;
    private Composite titleArea;
    private TreeViewer treeViewer;
    private ListenerList pageChangedListeners = new ListenerList();
    Composite formTitleComposite;
    private ScrolledComposite scrolled;

    public PreferenceDialog(Shell shell, PreferenceManager preferenceManager) {
        super(shell);
        this.preferenceManager = preferenceManager;
    }

    @Override
    protected void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.okPressed();
                return;
            }
            case 1: {
                this.cancelPressed();
                return;
            }
            case 17: {
                this.helpPressed();
                return;
            }
        }
    }

    @Override
    protected void cancelPressed() {
        Iterator iterator = this.preferenceManager.getElements(0).iterator();
        final boolean[] blArray = new boolean[]{true};
        while (iterator.hasNext()) {
            final IPreferenceNode iPreferenceNode = (IPreferenceNode)iterator.next();
            if (this.getPage(iPreferenceNode) == null) continue;
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    if (!PreferenceDialog.this.getPage(iPreferenceNode).performCancel()) {
                        blArray[0] = false;
                    }
                }
            });
            if (blArray[0]) continue;
            return;
        }
        this.handleSave();
        this.setReturnCode(1);
        this.close();
    }

    void clearSelectedNode() {
        this.setSelectedNodePreference(null);
    }

    @Override
    public boolean close() {
        SafeRunnable safeRunnable = new SafeRunnable(){

            public void run() throws Exception {
                List list = PreferenceDialog.this.preferenceManager.getElements(0);
                int n = 0;
                while (n < list.size()) {
                    IPreferenceNode iPreferenceNode = (IPreferenceNode)list.get(n);
                    iPreferenceNode.disposeResources();
                    ++n;
                }
            }

            @Override
            public void handleException(Throwable throwable) {
                super.handleException(throwable);
                PreferenceDialog.this.clearSelectedNode();
            }
        };
        SafeRunner.run((ISafeRunnable)safeRunnable);
        return super.close();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JFaceResources.getString("PreferenceDialog.title"));
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent shellEvent) {
                if (PreferenceDialog.this.lastShellSize == null) {
                    PreferenceDialog.this.lastShellSize = PreferenceDialog.this.getShell().getSize();
                }
            }
        });
    }

    @Override
    protected void constrainShellSize() {
        super.constrainShellSize();
        if (this.lastShellSize == null) {
            this.lastShellSize = this.getShell().getSize();
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.getShell().setDefaultButton(this.okButton);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    protected Control createContents(final Composite composite) {
        final Control[] controlArray = new Control[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                controlArray[0] = PreferenceDialog.super.createContents(composite);
                PreferenceDialog.this.selectSavedItem();
            }
        });
        return controlArray[0];
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setBackground(composite.getDisplay().getSystemColor(25));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setBackground(composite.getDisplay().getSystemColor(25));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(1040);
        gridData.widthHint = this.getLastRightWidth();
        gridData.verticalSpan = 1;
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        label.setText("Service:");
        Control control = this.createTreeAreaContents(composite3);
        this.createSash(composite2, control);
        Label label2 = new Label(composite2, 514);
        GridData gridData2 = new GridData(1040);
        label2.setLayoutData((Object)gridData2);
        label2.setLayoutData((Object)new GridData(16384, 4, false, true));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout3 = new GridLayout(1, true);
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        gridLayout3.verticalSpacing = 0;
        composite4.setLayout((Layout)gridLayout3);
        this.formTitleComposite = new Composite(composite4, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        this.formTitleComposite.setLayout((Layout)formLayout);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalIndent = 7;
        this.formTitleComposite.setLayoutData((Object)gridData3);
        Composite composite5 = new Composite(this.formTitleComposite, 0);
        gridLayout3 = new GridLayout();
        gridLayout3.marginBottom = 5;
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        gridLayout3.horizontalSpacing = 0;
        composite5.setLayout((Layout)gridLayout3);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        composite5.setLayoutData((Object)formData);
        this.createTitleArea(composite5);
        Label label3 = new Label(composite4, 258);
        label3.setLayoutData((Object)new GridData(768));
        this.pageContainer = this.createPageContainer(composite4);
        GridData gridData4 = new GridData(1808);
        gridData4.horizontalIndent = 7;
        this.pageContainer.setLayoutData((Object)gridData4);
        Label label4 = new Label(composite, 258);
        label4.setLayoutData((Object)new GridData(768));
        return composite2;
    }

    protected Sash createSash(final Composite composite, final Control control) {
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        sash.setBackground(composite.getDisplay().getSystemColor(25));
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point point;
                if (event.detail == 1) {
                    return;
                }
                int n = event.x - sash.getBounds().x;
                GridData gridData = (GridData)control.getLayoutData();
                int n2 = gridData.widthHint + n;
                if (n2 < 20) {
                    return;
                }
                Point point2 = PreferenceDialog.this.getShell().computeSize(-1, -1);
                boolean bl = !point2.equals((Object)(point = PreferenceDialog.this.getShell().getSize()));
                gridData.widthHint = n2;
                PreferenceDialog.this.setLastTreeWidth(n2);
                composite.layout(true);
                point2 = PreferenceDialog.this.getShell().computeSize(-1, -1);
                if (bl) {
                    point2.x = Math.max(point2.x, point.x);
                }
                point2.y = Math.max(point2.y, point.y);
                if (point2.equals((Object)point)) {
                    return;
                }
                PreferenceDialog.this.setShellSize(point2.x, point2.y);
                PreferenceDialog.this.lastShellSize = PreferenceDialog.this.getShell().getSize();
            }
        });
        return sash;
    }

    protected Composite createPageContainer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 7;
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)gridData);
        this.scrolled = new ScrolledComposite(composite2, 768);
        this.scrolled.setShowFocusedControl(true);
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        GridData gridData2 = new GridData(1808);
        this.scrolled.setLayoutData((Object)gridData2);
        Composite composite3 = new Composite((Composite)this.scrolled, 0);
        GridData gridData3 = new GridData(1808);
        composite3.setLayout(this.getPageLayout());
        composite3.setLayoutData((Object)gridData3);
        this.scrolled.setContent((Control)composite3);
        return composite3;
    }

    protected Layout getPageLayout() {
        return new PageLayout();
    }

    protected Composite createTitleArea(Composite composite) {
        int n = 2;
        this.titleArea = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = n;
        this.titleArea.setLayout((Layout)formLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        this.titleArea.setLayoutData((Object)gridData);
        this.messageArea = new DialogMessageArea();
        this.messageArea.createContents(this.titleArea);
        this.titleArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                PreferenceDialog.this.updateMessage();
            }
        });
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.eclipse.jface.bannerfont".equals(propertyChangeEvent.getProperty())) {
                    PreferenceDialog.this.updateMessage();
                }
                if ("org.eclipse.jface.dialogfont".equals(propertyChangeEvent.getProperty())) {
                    PreferenceDialog.this.updateMessage();
                    Font font = JFaceResources.getDialogFont();
                    PreferenceDialog.this.updateTreeFont(font);
                    Control[] controlArray = ((Composite)PreferenceDialog.this.buttonBar).getChildren();
                    int n = 0;
                    while (n < controlArray.length) {
                        controlArray[n].setFont(font);
                        ++n;
                    }
                }
            }
        };
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        this.messageArea.setTitleLayoutData(this.createMessageAreaData());
        this.messageArea.setMessageLayoutData(this.createMessageAreaData());
        return this.titleArea;
    }

    private FormData createMessageAreaData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.right = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        return formData;
    }

    protected Control createTreeAreaContents(Composite composite) {
        this.treeViewer = this.createTreeViewer(composite);
        this.treeViewer.setInput(this.getPreferenceManager());
        this.updateTreeFont(JFaceResources.getDialogFont());
        this.layoutTreeAreaControl(this.treeViewer.getControl());
        return this.treeViewer.getControl();
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite, 0);
        this.addListeners(treeViewer);
        treeViewer.setLabelProvider(new PreferenceLabelProvider());
        treeViewer.setContentProvider(new PreferenceContentProvider());
        return treeViewer;
    }

    protected void addListeners(final TreeViewer treeViewer) {
        treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            private void handleError() {
                try {
                    treeViewer.removePostSelectionChangedListener(this);
                    PreferenceDialog.this.showPageFlippingAbortDialog();
                    PreferenceDialog.this.selectCurrentPageAgain();
                    PreferenceDialog.this.clearSelectedNode();
                }
                finally {
                    treeViewer.addPostSelectionChangedListener(this);
                }
            }

            @Override
            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                final IPreferenceNode iPreferenceNode = PreferenceDialog.this.getSingleSelection(selectionChangedEvent.getSelection());
                if (iPreferenceNode instanceof IPreferenceNode) {
                    BusyIndicator.showWhile((Display)PreferenceDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!PreferenceDialog.this.isCurrentPageValid()) {
                                this.handleError();
                            } else if (!PreferenceDialog.this.showPage((IPreferenceNode)iPreferenceNode)) {
                                this.handleError();
                            } else {
                                PreferenceDialog.this.lastSuccessfulNode = (IPreferenceNode)iPreferenceNode;
                            }
                        }
                    });
                }
            }
        });
        ((Tree)treeViewer.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                IPreferenceNode iPreferenceNode;
                ISelection iSelection = treeViewer.getSelection();
                if (iSelection.isEmpty()) {
                    return;
                }
                boolean bl = treeViewer.getExpandedState(iPreferenceNode = PreferenceDialog.this.getSingleSelection(iSelection));
                treeViewer.setExpandedState(iPreferenceNode, !bl);
            }
        });
        treeViewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                if (PreferenceDialog.this.currentPage == null) {
                    this.openDialogHelp();
                    return;
                }
                Control control = PreferenceDialog.this.currentPage.getControl();
                if (control != null && control.isListening(28)) {
                    PreferenceDialog.this.currentPage.performHelp();
                    return;
                }
                this.openDialogHelp();
                PreferenceDialog.this.currentPage.performHelp();
            }

            private void openDialogHelp() {
                if (PreferenceDialog.this.pageContainer == null) {
                    return;
                }
                Composite composite = PreferenceDialog.this.pageContainer;
                while (composite != null) {
                    if (composite.isListening(28)) {
                        composite.notifyListeners(28, new Event());
                        break;
                    }
                    composite = composite.getParent();
                }
            }
        });
    }

    protected IPreferenceNode findNodeMatching(String string) {
        List list = this.preferenceManager.getElements(1);
        for (IPreferenceNode iPreferenceNode : list) {
            if (!iPreferenceNode.getId().equals(string)) continue;
            return iPreferenceNode;
        }
        return null;
    }

    protected int getLastRightWidth() {
        return lastTreeWidth;
    }

    public PreferenceManager getPreferenceManager() {
        return this.preferenceManager;
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    protected String getSelectedNodePreference() {
        return lastPreferenceId;
    }

    protected IPreferenceNode getSingleSelection(ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof IPreferenceNode) {
            return (IPreferenceNode)iStructuredSelection.getFirstElement();
        }
        return null;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void handleSave() {
        for (IPreferenceNode iPreferenceNode : this.preferenceManager.getElements(0)) {
            IPreferenceStore iPreferenceStore;
            IPreferencePage iPreferencePage = iPreferenceNode.getPage();
            if (!(iPreferencePage instanceof PreferencePage) || (iPreferenceStore = ((PreferencePage)iPreferencePage).getPreferenceStore()) == null || !iPreferenceStore.needsSaving() || !(iPreferenceStore instanceof IPersistentPreferenceStore)) continue;
            try {
                ((IPersistentPreferenceStore)iPreferenceStore).save();
            }
            catch (IOException iOException) {
                String string = JFaceResources.format("PreferenceDialog.saveErrorMessage", new Object[]{iPreferencePage.getTitle(), iOException.getMessage()});
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.jface", string, (Throwable)iOException), JFaceResources.getString("PreferenceDialog.saveErrorTitle"));
            }
        }
    }

    @Override
    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    @Override
    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected boolean isCurrentPageValid() {
        if (this.currentPage == null) {
            return true;
        }
        return this.currentPage.isValid();
    }

    protected void layoutTreeAreaControl(Control control) {
        GridData gridData = new GridData(1040);
        gridData.widthHint = this.getLastRightWidth();
        gridData.verticalSpan = 1;
        control.setLayoutData((Object)gridData);
    }

    @Override
    protected void okPressed() {
        SafeRunnable.run(new SafeRunnable(){
            private boolean errorOccurred;

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            public void handleException(Throwable throwable) {
                this.errorOccurred = true;
                Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 0, throwable.toString(), throwable));
                PreferenceDialog.this.clearSelectedNode();
                String string = JFaceResources.getString("SafeRunnable.errorMessage");
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.jface", string, throwable), JFaceResources.getString("Error"));
            }
        });
    }

    void selectCurrentPageAgain() {
        if (this.lastSuccessfulNode == null) {
            return;
        }
        this.getTreeViewer().setSelection(new StructuredSelection(this.lastSuccessfulNode));
        this.currentPage.setVisible(true);
    }

    protected void selectSavedItem() {
        Object object = this.findNodeMatching(this.getSelectedNodePreference());
        if (object == null) {
            Object[] objectArray = this.preferenceManager.getRootSubNodes();
            ViewerComparator viewerComparator = this.getTreeViewer().getComparator();
            if (viewerComparator != null) {
                viewerComparator.sort(null, objectArray);
            }
            ViewerFilter[] viewerFilterArray = this.getTreeViewer().getFilters();
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                int n2 = 0;
                while (n2 < viewerFilterArray.length) {
                    if (!viewerFilterArray[n2].select(this.treeViewer, this.preferenceManager.getRoot(), object2)) {
                        object2 = null;
                        break;
                    }
                    ++n2;
                }
                if (object2 != null) {
                    object = object2;
                    break;
                }
                ++n;
            }
        }
        if (object != null) {
            this.getTreeViewer().setSelection(new StructuredSelection(object), true);
            this.getTreeViewer().getControl().setFocus();
        }
    }

    public void setErrorMessage(String string) {
        if (string == null) {
            this.messageArea.clearErrorMessage();
        } else {
            this.messageArea.updateText(string, 3);
        }
    }

    private void setLastTreeWidth(int n) {
        lastTreeWidth = n;
    }

    public void setMessage(String string) {
        this.setMessage(string, 0);
    }

    public void setMessage(String string, int n) {
        this.messageArea.updateText(string, n);
    }

    public void setMinimumPageSize(int n, int n2) {
        this.minimumPageSize.x = n;
        this.minimumPageSize.y = n2;
    }

    public void setMinimumPageSize(Point point) {
        this.minimumPageSize.x = point.x;
        this.minimumPageSize.y = point.y;
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        Assert.isNotNull((Object)iPreferenceStore);
        this.preferenceStore = iPreferenceStore;
    }

    private void setSelectedNode() {
        String string = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (iStructuredSelection.size() == 1) {
            IPreferenceNode iPreferenceNode = (IPreferenceNode)iStructuredSelection.getFirstElement();
            string = iPreferenceNode.getId();
        }
        this.setSelectedNodePreference(string);
    }

    public void setSelectedNode(String string) {
        this.setSelectedNodePreference(string);
    }

    protected void setSelectedNodePreference(String string) {
        lastPreferenceId = string;
    }

    private void setShellSize(int n, int n2) {
        Rectangle rectangle = this.getShell().getBounds();
        rectangle.width = n;
        rectangle.height = n2;
        this.getShell().setBounds(this.getConstrainedShellBounds(rectangle));
    }

    @Override
    protected void setShellStyle(int n) {
        super.setShellStyle(n | 0x10000000);
    }

    protected boolean showPage(IPreferenceNode iPreferenceNode) {
        int n;
        Point point;
        Control[] controlArray;
        Object[] objectArray;
        if (iPreferenceNode == null) {
            return false;
        }
        if (iPreferenceNode.getPage() == null) {
            this.createPage(iPreferenceNode);
        }
        if (iPreferenceNode.getPage() == null) {
            return false;
        }
        IPreferencePage iPreferencePage = this.getPage(iPreferenceNode);
        if (iPreferencePage == this.currentPage) {
            return true;
        }
        if (this.currentPage != null && !this.currentPage.okToLeave()) {
            return false;
        }
        IPreferencePage iPreferencePage2 = this.currentPage;
        this.currentPage = iPreferencePage;
        this.currentPage.setContainer(this);
        if (this.currentPage.getControl() == null) {
            objectArray = new boolean[1];
            SafeRunnable.run(new ISafeRunnable((boolean[])objectArray){
                private final /* synthetic */ boolean[] val$failed;
                {
                    this.val$failed = blArray;
                }

                public void handleException(Throwable throwable) {
                    this.val$failed[0] = true;
                }

                public void run() {
                    PreferenceDialog.this.createPageControl(PreferenceDialog.this.currentPage, PreferenceDialog.this.pageContainer);
                }
            });
            if (objectArray[0]) {
                return false;
            }
            Assert.isNotNull((Object)this.currentPage.getControl());
        }
        objectArray = new Point[1];
        Point point2 = new Point(-1, -1);
        SafeRunnable.run(new ISafeRunnable((Point[])objectArray, point2){
            private final /* synthetic */ Point[] val$size;
            private final /* synthetic */ Point val$failed;
            {
                this.val$size = pointArray;
                this.val$failed = point;
            }

            public void handleException(Throwable throwable) {
                this.val$size[0] = this.val$failed;
            }

            public void run() {
                this.val$size[0] = PreferenceDialog.this.currentPage.computeSize();
            }
        });
        if (objectArray[0].equals((Object)point2)) {
            return false;
        }
        boolean bl = objectArray[0];
        Shell shell = this.getShell();
        Point point3 = shell.getSize();
        if (iPreferencePage2 != null) {
            controlArray = this.pageContainer.getClientArea();
            point = new Point(controlArray.width, controlArray.height);
            n = bl.x - point.x;
            int n2 = bl.y - point.y;
            if ((n > 0 || n2 > 0) && point3.equals((Object)this.lastShellSize)) {
                n = Math.max(0, n);
                n2 = Math.max(0, n2);
                this.setShellSize(point3.x + n, point3.y + n2);
                this.lastShellSize = shell.getSize();
                if (this.currentPage.getControl().getSize().x == 0) {
                    this.currentPage.getControl().setSize(point);
                }
            } else {
                this.currentPage.setSize(point);
            }
        }
        this.scrolled.setMinSize((Point)bl);
        controlArray = this.pageContainer.getChildren();
        point = this.currentPage.getControl();
        n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] != point) {
                controlArray[n].setVisible(false);
            }
            ++n;
        }
        this.currentPage.setVisible(true);
        if (iPreferencePage2 != null) {
            iPreferencePage2.setVisible(false);
        }
        this.update();
        return true;
    }

    protected void createPage(IPreferenceNode iPreferenceNode) {
        iPreferenceNode.createPage();
    }

    protected IPreferencePage getPage(IPreferenceNode iPreferenceNode) {
        return iPreferenceNode.getPage();
    }

    void showPageFlippingAbortDialog() {
        MessageDialog.open(1, this.getShell(), JFaceResources.getString("AbortPageFlippingDialog.title"), JFaceResources.getString("AbortPageFlippingDialog.message"), 0x10000000);
    }

    protected void update() {
        this.updateTitle();
        this.updateMessage();
        this.updateButtons();
        this.setSelectedNode();
        this.firePageChanged(new PageChangedEvent(this, this.getCurrentPage()));
    }

    @Override
    public void updateButtons() {
        this.okButton.setEnabled(this.isCurrentPageValid());
    }

    @Override
    public void updateMessage() {
        String string = null;
        String string2 = null;
        if (this.currentPage != null) {
            string = this.currentPage.getMessage();
            string2 = this.currentPage.getErrorMessage();
        }
        int n = 0;
        if (string != null && this.currentPage instanceof IMessageProvider) {
            n = ((IMessageProvider)((Object)this.currentPage)).getMessageType();
        }
        if (string2 == null) {
            if (this.showingError) {
                this.showingError = false;
            }
        } else {
            string = string2;
            n = 3;
            if (!this.showingError) {
                this.showingError = true;
            }
        }
        this.messageArea.updateText(string, n);
    }

    @Override
    public void updateTitle() {
        if (this.currentPage == null) {
            return;
        }
        this.messageArea.showTitle(this.currentPage.getTitle(), this.currentPage.getImage());
    }

    protected void updateTreeFont(Font font) {
        this.getTreeViewer().getControl().setFont(font);
    }

    protected IPreferencePage getCurrentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(IPreferencePage iPreferencePage) {
        this.currentPage = iPreferencePage;
    }

    protected void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    protected Composite getPageContainer() {
        return this.pageContainer;
    }

    protected void setPageContainer(Composite composite) {
        this.pageContainer = composite;
    }

    protected void createPageControl(IPreferencePage iPreferencePage, Composite composite) {
        iPreferencePage.createControl(composite);
    }

    @Override
    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    @Override
    public void addPageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangedListeners.add((Object)iPageChangedListener);
    }

    @Override
    public void removePageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangedListeners.remove((Object)iPageChangedListener);
    }

    protected void firePageChanged(final PageChangedEvent pageChangedEvent) {
        Object[] objectArray = this.pageChangedListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPageChangedListener iPageChangedListener = (IPageChangedListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iPageChangedListener.pageChanged(pageChangedEvent);
                }
            });
            ++n;
        }
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    static /* synthetic */ Button access$10(PreferenceDialog preferenceDialog, int n) {
        return preferenceDialog.getButton(n);
    }

    static /* synthetic */ void access$11(PreferenceDialog preferenceDialog, int n) {
        preferenceDialog.setReturnCode(n);
    }

    private class PageLayout
    extends Layout {
        private PageLayout() {
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            int n3 = ((PreferenceDialog)PreferenceDialog.this).minimumPageSize.x;
            int n4 = ((PreferenceDialog)PreferenceDialog.this).minimumPageSize.y;
            Control[] controlArray = composite.getChildren();
            int n5 = 0;
            while (n5 < controlArray.length) {
                Point point = controlArray[n5].computeSize(-1, -1, bl);
                n3 = Math.max(n3, point.x);
                n4 = Math.max(n4, point.y);
                ++n5;
            }
            if (PreferenceDialog.this.currentPage != null) {
                Point point = PreferenceDialog.this.currentPage.computeSize();
                n3 = Math.max(n3, point.x);
                n4 = Math.max(n4, point.y);
            }
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            return new Point(n3, n4);
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setSize(rectangle.width, rectangle.height);
                ++n;
            }
        }
    }
}

