/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class PathEditor
extends ListEditor {
    private String lastPath;
    private String dirChooserLabelText;

    protected PathEditor() {
    }

    public PathEditor(String string, String string2, String string3, Composite composite) {
        this.init(string, string2);
        this.dirChooserLabelText = string3;
        this.createControl(composite);
    }

    @Override
    protected String createList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(File.pathSeparator);
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getNewInputObject() {
        String string;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 0x10000000);
        if (this.dirChooserLabelText != null) {
            directoryDialog.setMessage(this.dirChooserLabelText);
        }
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            directoryDialog.setFilterPath(this.lastPath);
        }
        if ((string = directoryDialog.open()) != null) {
            if ((string = string.trim()).length() == 0) {
                return null;
            }
            this.lastPath = string;
        }
        return string;
    }

    @Override
    protected String[] parseString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

