/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class ListEditor
extends FieldEditor {
    private List list;
    private Composite buttonBox;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;

    protected ListEditor() {
    }

    protected ListEditor(String string, String string2, Composite composite) {
        this.init(string, string2);
        this.createControl(composite);
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String string = this.getNewInputObject();
        if (string != null) {
            int n = this.list.getSelectionIndex();
            if (n >= 0) {
                this.list.add(string, n + 1);
            } else {
                this.list.add(string, 0);
            }
            this.selectionChanged();
        }
    }

    @Override
    protected void adjustForNumColumns(int n) {
        Label label = this.getLabelControl();
        ((GridData)label.getLayoutData()).horizontalSpan = n;
        ((GridData)this.list.getLayoutData()).horizontalSpan = n - 1;
    }

    private void createButtons(Composite composite) {
        this.addButton = this.createPushButton(composite, "ListEditor.add");
        this.removeButton = this.createPushButton(composite, "ListEditor.remove");
        this.upButton = this.createPushButton(composite, "ListEditor.up");
        this.downButton = this.createPushButton(composite, "ListEditor.down");
    }

    protected abstract String createList(String[] var1);

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(JFaceResources.getString(string));
        button.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        int n = this.convertHorizontalDLUsToPixels((Control)button, 61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Widget widget = selectionEvent.widget;
                if (widget == ListEditor.this.addButton) {
                    ListEditor.this.addPressed();
                } else if (widget == ListEditor.this.removeButton) {
                    ListEditor.this.removePressed();
                } else if (widget == ListEditor.this.upButton) {
                    ListEditor.this.upPressed();
                } else if (widget == ListEditor.this.downButton) {
                    ListEditor.this.downPressed();
                } else if (widget == ListEditor.this.list) {
                    ListEditor.this.selectionChanged();
                }
            }
        };
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        this.list = this.getListControl(composite);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gridData);
        this.buttonBox = this.getButtonBoxControl(composite);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gridData);
    }

    @Override
    protected void doLoad() {
        if (this.list != null) {
            String string = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            int n = 0;
            while (n < stringArray.length) {
                this.list.add(stringArray[n]);
                ++n;
            }
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            int n = 0;
            while (n < stringArray.length) {
                this.list.add(stringArray[n]);
                ++n;
            }
        }
    }

    @Override
    protected void doStore() {
        String string = this.createList(this.list.getItems());
        if (string != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), string);
        }
    }

    private void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite composite) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)gridLayout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ListEditor.this.addButton = null;
                    ListEditor.this.removeButton = null;
                    ListEditor.this.upButton = null;
                    ListEditor.this.downButton = null;
                    ListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, composite);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite composite) {
        if (this.list == null) {
            this.list = new List(composite, 2820);
            this.list.setFont(composite.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ListEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, composite);
        }
        return this.list;
    }

    protected abstract String getNewInputObject();

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected abstract String[] parseString(String var1);

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int n = this.list.getSelectionIndex();
        if (n >= 0) {
            this.list.remove(n);
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int n = this.list.getSelectionIndex();
        int n2 = this.list.getItemCount();
        this.removeButton.setEnabled(n >= 0);
        this.upButton.setEnabled(n2 > 1 && n > 0);
        this.downButton.setEnabled(n2 > 1 && n >= 0 && n < n2 - 1);
    }

    @Override
    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    private void swap(boolean bl) {
        int n;
        this.setPresentsDefaultValue(false);
        int n2 = this.list.getSelectionIndex();
        int n3 = n = bl ? n2 - 1 : n2 + 1;
        if (n2 >= 0) {
            String[] stringArray = this.list.getSelection();
            Assert.isTrue((stringArray.length == 1 ? 1 : 0) != 0);
            this.list.remove(n2);
            this.list.add(stringArray[0], n);
            this.list.setSelection(n);
        }
        this.selectionChanged();
    }

    private void upPressed() {
        this.swap(true);
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.getListControl(composite).setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getUpButton() {
        return this.upButton;
    }

    protected Button getDownButton() {
        return this.downButton;
    }

    protected List getList() {
        return this.list;
    }
}

