/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class IntegerFieldEditor
extends StringFieldEditor {
    private int minValidValue = 0;
    private int maxValidValue = Integer.MAX_VALUE;
    private static final int DEFAULT_TEXT_LIMIT = 10;

    protected IntegerFieldEditor() {
    }

    public IntegerFieldEditor(String string, String string2, Composite composite) {
        this(string, string2, composite, 10);
    }

    public IntegerFieldEditor(String string, String string2, Composite composite, int n) {
        this.init(string, string2);
        this.setTextLimit(n);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.getString("IntegerFieldEditor.errorMessage"));
        this.createControl(composite);
    }

    public void setValidRange(int n, int n2) {
        this.minValidValue = n;
        this.maxValidValue = n2;
        this.setErrorMessage(JFaceResources.format("IntegerFieldEditor.errorMessageRange", new Object[]{new Integer(n), new Integer(n2)}));
    }

    @Override
    protected boolean checkState() {
        block4: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String string = text.getText();
            try {
                int n = Integer.valueOf(string);
                if (n < this.minValidValue || n > this.maxValidValue) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    @Override
    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            int n = this.getPreferenceStore().getInt(this.getPreferenceName());
            text.setText("" + n);
            this.oldValue = "" + n;
        }
    }

    @Override
    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            int n = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            text.setText("" + n);
        }
        this.valueChanged();
    }

    @Override
    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            Integer n = new Integer(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), n);
        }
    }

    public int getIntValue() throws NumberFormatException {
        return new Integer(this.getStringValue());
    }
}

