/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FontFieldEditor
extends FieldEditor {
    private Button changeFontButton = null;
    private String changeButtonText;
    private String previewText;
    private FontData[] chosenFont;
    private Label valueControl;
    private DefaultPreviewer previewer;

    protected FontFieldEditor() {
    }

    public FontFieldEditor(String string, String string2, String string3, Composite composite) {
        this.init(string, string2);
        this.previewText = string3;
        this.changeButtonText = JFaceResources.getString("openChange");
        this.createControl(composite);
    }

    public FontFieldEditor(String string, String string2, Composite composite) {
        this(string, string2, null, composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        GridData gridData = new GridData();
        if (this.valueControl.getLayoutData() != null) {
            gridData = (GridData)this.valueControl.getLayoutData();
        }
        gridData.horizontalSpan = n - this.getNumberOfControls() + 1;
        this.valueControl.setLayoutData((Object)gridData);
    }

    @Override
    protected void applyFont() {
        if (this.chosenFont != null && this.previewer != null) {
            this.previewer.setFont(this.chosenFont);
        }
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        this.getLabelControl(composite);
        this.valueControl = this.getValueControl(composite);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n - this.getNumberOfControls() + 1;
        this.valueControl.setLayoutData((Object)gridData);
        if (this.previewText != null) {
            this.previewer = new DefaultPreviewer(this.previewText, composite);
            gridData = new GridData(768);
            gridData.heightHint = this.previewer.getPreferredExtent();
            gridData.widthHint = this.previewer.getPreferredExtent();
            this.previewer.getControl().setLayoutData((Object)gridData);
        }
        this.changeFontButton = this.getChangeControl(composite);
        gridData = new GridData();
        int n2 = this.convertHorizontalDLUsToPixels((Control)this.changeFontButton, 61);
        gridData.widthHint = Math.max(n2, this.changeFontButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeFontButton.setLayoutData((Object)gridData);
    }

    @Override
    protected void doLoad() {
        if (this.changeFontButton == null) {
            return;
        }
        this.updateFont(PreferenceConverter.getFontDataArray(this.getPreferenceStore(), this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        if (this.changeFontButton == null) {
            return;
        }
        this.updateFont(PreferenceConverter.getDefaultFontDataArray(this.getPreferenceStore(), this.getPreferenceName()));
    }

    @Override
    protected void doStore() {
        if (this.chosenFont != null) {
            PreferenceConverter.setValue(this.getPreferenceStore(), this.getPreferenceName(), this.chosenFont);
        }
    }

    protected Button getChangeControl(Composite composite) {
        if (this.changeFontButton == null) {
            this.changeFontButton = new Button(composite, 8);
            if (this.changeButtonText != null) {
                this.changeFontButton.setText(this.changeButtonText);
            }
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FontData fontData;
                    FontDialog fontDialog = new FontDialog(FontFieldEditor.this.changeFontButton.getShell());
                    if (FontFieldEditor.this.chosenFont != null) {
                        fontDialog.setFontList(FontFieldEditor.this.chosenFont);
                    }
                    if ((fontData = fontDialog.open()) != null) {
                        FontData[] fontDataArray = FontFieldEditor.this.chosenFont;
                        if (fontDataArray == null) {
                            fontDataArray = JFaceResources.getDefaultFont().getFontData();
                        }
                        FontFieldEditor.this.setPresentsDefaultValue(false);
                        FontData[] fontDataArray2 = new FontData[]{fontData};
                        FontFieldEditor.this.updateFont(fontDataArray2);
                        FontFieldEditor.this.fireValueChanged("field_editor_value", fontDataArray[0], fontData);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    FontFieldEditor.this.changeFontButton = null;
                }
            });
            this.changeFontButton.setFont(composite.getFont());
            this.setButtonLayoutData(this.changeFontButton);
        } else {
            this.checkParent((Control)this.changeFontButton, composite);
        }
        return this.changeFontButton;
    }

    @Override
    public int getNumberOfControls() {
        if (this.previewer == null) {
            return 3;
        }
        return 4;
    }

    public int getPreferredPreviewHeight() {
        if (this.previewer == null) {
            return -1;
        }
        return this.previewer.getPreferredExtent();
    }

    public Control getPreviewControl() {
        if (this.previewer == null) {
            return null;
        }
        return this.previewer.getControl();
    }

    protected Label getValueControl(Composite composite) {
        if (this.valueControl == null) {
            this.valueControl = new Label(composite, 16384);
            this.valueControl.setFont(composite.getFont());
            this.valueControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    FontFieldEditor.this.valueControl = null;
                }
            });
        } else {
            this.checkParent((Control)this.valueControl, composite);
        }
        return this.valueControl;
    }

    public void setChangeButtonText(String string) {
        Assert.isNotNull((Object)string);
        this.changeButtonText = string;
        if (this.changeFontButton != null) {
            this.changeFontButton.setText(string);
        }
    }

    private void updateFont(FontData[] fontDataArray) {
        FontData[] fontDataArray2 = JFaceResources.getFontRegistry().filterData(fontDataArray, this.valueControl.getDisplay());
        if (fontDataArray2 == null) {
            fontDataArray2 = this.getDefaultFontData();
        }
        this.chosenFont = fontDataArray2;
        if (this.valueControl != null) {
            this.valueControl.setText(StringConverter.asString(this.chosenFont[0]));
        }
        if (this.previewer != null) {
            this.previewer.setFont(fontDataArray2);
        }
    }

    protected void setToDefault() {
        FontData[] fontDataArray = PreferenceConverter.getDefaultFontDataArray(this.getPreferenceStore(), this.getPreferenceName());
        PreferenceConverter.setValue(this.getPreferenceStore(), this.getPreferenceName(), fontDataArray);
    }

    private FontData[] getDefaultFontData() {
        return this.valueControl.getDisplay().getSystemFont().getFontData();
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.getChangeControl(composite).setEnabled(bl);
        this.getValueControl(composite).setEnabled(bl);
    }

    private static class DefaultPreviewer {
        private Text text;
        private String string;
        private Font font;

        public DefaultPreviewer(String string, Composite composite) {
            this.string = string;
            this.text = new Text(composite, 2056);
            this.text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (DefaultPreviewer.this.font != null) {
                        DefaultPreviewer.this.font.dispose();
                    }
                }
            });
            if (this.string != null) {
                this.text.setText(this.string);
            }
        }

        public Control getControl() {
            return this.text;
        }

        public void setFont(FontData[] fontDataArray) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontDataArray);
            this.text.setFont(this.font);
        }

        public int getPreferredExtent() {
            return 40;
        }
    }
}

