/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.File;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class FileFieldEditor
extends StringButtonFieldEditor {
    private String[] extensions = null;
    private File filterPath = null;
    private boolean enforceAbsolute = false;

    protected FileFieldEditor() {
    }

    public FileFieldEditor(String string, String string2, Composite composite) {
        this(string, string2, false, composite);
    }

    public FileFieldEditor(String string, String string2, boolean bl, Composite composite) {
        this(string, string2, bl, 1, composite);
    }

    public FileFieldEditor(String string, String string2, boolean bl, int n, Composite composite) {
        this.init(string, string2);
        this.enforceAbsolute = bl;
        this.setErrorMessage(JFaceResources.getString("FileFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString("openBrowse"));
        this.setValidateStrategy(n);
        this.createControl(composite);
    }

    @Override
    protected String changePressed() {
        File file;
        File file2 = new File(this.getTextControl().getText());
        if (!file2.exists()) {
            file2 = null;
        }
        if ((file = this.getFile(file2)) == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    @Override
    protected boolean checkState() {
        String string = null;
        String string2 = this.getTextControl().getText();
        string2 = string2 != null ? string2.trim() : "";
        if (string2.length() == 0) {
            if (!this.isEmptyStringAllowed()) {
                string = this.getErrorMessage();
            }
        } else {
            File file = new File(string2);
            if (file.isFile()) {
                if (this.enforceAbsolute && !file.isAbsolute()) {
                    string = JFaceResources.getString("FileFieldEditor.errorMessage2");
                }
            } else {
                string = this.getErrorMessage();
            }
        }
        if (string != null) {
            this.showErrorMessage(string);
            return false;
        }
        if (this.doCheckState()) {
            this.clearErrorMessage();
            return true;
        }
        string = this.getErrorMessage();
        if (string != null) {
            this.showErrorMessage(string);
        }
        return false;
    }

    private File getFile(File file) {
        String string;
        FileDialog fileDialog = new FileDialog(this.getShell(), 0x10001000);
        if (file != null) {
            fileDialog.setFileName(file.getPath());
        } else if (this.filterPath != null) {
            fileDialog.setFilterPath(this.filterPath.getPath());
        }
        if (this.extensions != null) {
            fileDialog.setFilterExtensions(this.extensions);
        }
        if ((string = fileDialog.open()) != null && (string = string.trim()).length() > 0) {
            return new File(string);
        }
        return null;
    }

    public void setFileExtensions(String[] stringArray) {
        this.extensions = stringArray;
    }

    public void setFilterPath(File file) {
        this.filterPath = file;
    }
}

