/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class FieldEditorPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    public static final int FLAT = 0;
    public static final int GRID = 1;
    protected static final int VERTICAL_SPACING = 10;
    protected static final int MARGIN_WIDTH = 0;
    protected static final int MARGIN_HEIGHT = 0;
    private List fields = null;
    private int style;
    private FieldEditor invalidFieldEditor = null;
    private Composite fieldEditorParent;

    public FieldEditorPreferencePage() {
        this(0);
    }

    protected FieldEditorPreferencePage(int n) {
        this.style = n;
    }

    protected FieldEditorPreferencePage(String string, int n) {
        super(string);
        this.style = n;
    }

    protected FieldEditorPreferencePage(String string, ImageDescriptor imageDescriptor, int n) {
        super(string, imageDescriptor);
        this.style = n;
    }

    protected void addField(FieldEditor fieldEditor) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(fieldEditor);
    }

    protected void adjustGridLayout() {
        int n;
        ((GridLayout)this.fieldEditorParent.getLayout()).numColumns = n = this.calcNumberOfColumns();
        if (this.fields != null) {
            int n2 = 0;
            while (n2 < this.fields.size()) {
                FieldEditor fieldEditor = (FieldEditor)this.fields.get(n2);
                fieldEditor.adjustForNumColumns(n);
                ++n2;
            }
        }
    }

    protected void applyFont() {
        if (this.fields != null) {
            for (FieldEditor fieldEditor : this.fields) {
                fieldEditor.applyFont();
            }
        }
    }

    private int calcNumberOfColumns() {
        int n = 0;
        if (this.fields != null) {
            for (FieldEditor fieldEditor : this.fields) {
                n = Math.max(n, fieldEditor.getNumberOfControls());
            }
        }
        return n;
    }

    protected void checkState() {
        boolean bl = true;
        this.invalidFieldEditor = null;
        if (this.fields != null) {
            int n = this.fields.size();
            int n2 = 0;
            while (n2 < n) {
                FieldEditor fieldEditor = (FieldEditor)this.fields.get(n2);
                boolean bl2 = bl = bl && fieldEditor.isValid();
                if (!bl) {
                    this.invalidFieldEditor = fieldEditor;
                    break;
                }
                ++n2;
            }
        }
        this.setValid(bl);
    }

    @Override
    protected Control createContents(Composite composite) {
        this.fieldEditorParent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fieldEditorParent.setLayout((Layout)gridLayout);
        this.fieldEditorParent.setFont(composite.getFont());
        this.createFieldEditors();
        if (this.style == 1) {
            this.adjustGridLayout();
        }
        this.initialize();
        this.checkState();
        return this.fieldEditorParent;
    }

    protected abstract void createFieldEditors();

    @Override
    public void dispose() {
        super.dispose();
        if (this.fields != null) {
            for (FieldEditor fieldEditor : this.fields) {
                fieldEditor.setPage(null);
                fieldEditor.setPropertyChangeListener(null);
                fieldEditor.setPreferenceStore(null);
            }
        }
    }

    protected Composite getFieldEditorParent() {
        if (this.style == 0) {
            Composite composite = new Composite(this.fieldEditorParent, 0);
            composite.setLayoutData((Object)new GridData(768));
            return composite;
        }
        return this.fieldEditorParent;
    }

    protected void initialize() {
        if (this.fields != null) {
            for (FieldEditor fieldEditor : this.fields) {
                fieldEditor.setPage(this);
                fieldEditor.setPropertyChangeListener(this);
                fieldEditor.setPreferenceStore(this.getPreferenceStore());
                fieldEditor.load();
            }
        }
    }

    @Override
    protected void performDefaults() {
        if (this.fields != null) {
            for (FieldEditor fieldEditor : this.fields) {
                fieldEditor.loadDefault();
            }
        }
        this.checkState();
        super.performDefaults();
    }

    @Override
    public boolean performOk() {
        if (this.fields != null) {
            for (FieldEditor fieldEditor : this.fields) {
                fieldEditor.store();
                fieldEditor.setPresentsDefaultValue(false);
            }
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.checkState();
            } else {
                this.invalidFieldEditor = (FieldEditor)propertyChangeEvent.getSource();
                this.setValid(bl);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.invalidFieldEditor != null) {
            this.invalidFieldEditor.setFocus();
        }
    }
}

