/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class FieldEditor {
    public static final String IS_VALID = "field_editor_is_valid";
    public static final String VALUE = "field_editor_value";
    protected static final int HORIZONTAL_GAP = 8;
    private IPreferenceStore preferenceStore = null;
    private String preferenceName;
    private boolean isDefaultPresented = false;
    private String labelText;
    private Label label;
    private IPropertyChangeListener propertyChangeListener;
    private DialogPage page;

    protected FieldEditor() {
    }

    protected FieldEditor(String string, String string2, Composite composite) {
        this.init(string, string2);
        this.createControl(composite);
    }

    protected abstract void adjustForNumColumns(int var1);

    protected void applyFont() {
    }

    protected void checkParent(Control control, Composite composite) {
        Assert.isTrue((control.getParent() == composite ? 1 : 0) != 0, (String)"Different parents");
    }

    protected void clearErrorMessage() {
        if (this.page != null) {
            this.page.setErrorMessage(null);
        }
    }

    protected void clearMessage() {
        if (this.page != null) {
            this.page.setMessage(null);
        }
    }

    protected int convertHorizontalDLUsToPixels(Control control, int n) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        int n2 = gC.getFontMetrics().getAverageCharWidth();
        gC.dispose();
        double d = (double)n2 * 0.25;
        return (int)Math.round((double)n * d);
    }

    protected int convertVerticalDLUsToPixels(Control control, int n) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        int n2 = gC.getFontMetrics().getHeight();
        gC.dispose();
        double d = (double)n2 * 0.125;
        return (int)Math.round((double)n * d);
    }

    protected void createControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.getNumberOfControls();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 8;
        composite.setLayout((Layout)gridLayout);
        this.doFillIntoGrid(composite, gridLayout.numColumns);
    }

    public void dispose() {
    }

    protected abstract void doFillIntoGrid(Composite var1, int var2);

    protected abstract void doLoad();

    protected abstract void doLoadDefault();

    protected abstract void doStore();

    public void fillIntoGrid(Composite composite, int n) {
        Assert.isTrue((n >= this.getNumberOfControls() ? 1 : 0) != 0);
        Assert.isTrue((boolean)(composite.getLayout() instanceof GridLayout));
        this.doFillIntoGrid(composite, n);
    }

    protected void fireStateChanged(String string, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        this.fireValueChanged(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void fireValueChanged(String string, Object object, Object object2) {
        if (this.propertyChangeListener == null) {
            return;
        }
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
    }

    public String getFieldEditorFontName() {
        return "org.eclipse.jface.dialogfont";
    }

    protected Label getLabelControl() {
        return this.label;
    }

    public Label getLabelControl(Composite composite) {
        if (this.label == null) {
            this.label = new Label(composite, 16384);
            this.label.setFont(composite.getFont());
            String string = this.getLabelText();
            if (string != null) {
                this.label.setText(string);
            }
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    FieldEditor.this.label = null;
                }
            });
        } else {
            this.checkParent((Control)this.label, composite);
        }
        return this.label;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public abstract int getNumberOfControls();

    public String getPreferenceName() {
        return this.preferenceName;
    }

    protected PreferencePage getPreferencePage() {
        if (this.page != null && this.page instanceof PreferencePage) {
            return (PreferencePage)this.page;
        }
        return null;
    }

    protected DialogPage getPage() {
        return this.page;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    protected void init(String string, String string2) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.preferenceName = string;
        this.labelText = string2;
    }

    public boolean isValid() {
        return true;
    }

    public void load() {
        if (this.preferenceStore != null) {
            this.isDefaultPresented = false;
            this.doLoad();
            this.refreshValidState();
        }
    }

    public void loadDefault() {
        if (this.preferenceStore != null) {
            this.isDefaultPresented = true;
            this.doLoadDefault();
            this.refreshValidState();
        }
    }

    public boolean presentsDefaultValue() {
        return this.isDefaultPresented;
    }

    protected void refreshValidState() {
    }

    public void setFocus() {
    }

    public void setLabelText(String string) {
        Assert.isNotNull((Object)string);
        this.labelText = string;
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    public void setPreferenceName(String string) {
        this.preferenceName = string;
    }

    public void setPreferencePage(PreferencePage preferencePage) {
        this.setPage(preferencePage);
    }

    public void setPage(DialogPage dialogPage) {
        this.page = dialogPage;
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        this.preferenceStore = iPreferenceStore;
    }

    protected void setPresentsDefaultValue(boolean bl) {
        this.isDefaultPresented = bl;
    }

    public void setPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListener = iPropertyChangeListener;
    }

    protected void showErrorMessage(String string) {
        if (this.page != null) {
            this.page.setErrorMessage(string);
        }
    }

    protected void showMessage(String string) {
        if (this.page != null) {
            this.page.setErrorMessage(string);
        }
    }

    public void store() {
        if (this.preferenceStore == null) {
            return;
        }
        if (this.isDefaultPresented) {
            this.preferenceStore.setToDefault(this.preferenceName);
        } else {
            this.doStore();
        }
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        GC gC = new GC((Drawable)button);
        gC.setFont(button.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n = Dialog.convertVerticalDLUsToPixels(fontMetrics, 61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
    }

    public void setEnabled(boolean bl, Composite composite) {
        this.getLabelControl(composite).setEnabled(bl);
    }
}

