/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.File;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class DirectoryFieldEditor
extends StringButtonFieldEditor {
    private File filterPath = null;

    protected DirectoryFieldEditor() {
    }

    public DirectoryFieldEditor(String string, String string2, Composite composite) {
        this.init(string, string2);
        this.setErrorMessage(JFaceResources.getString("DirectoryFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString("openBrowse"));
        this.setValidateStrategy(1);
        this.createControl(composite);
    }

    @Override
    protected String changePressed() {
        File file;
        File file2 = new File(this.getTextControl().getText());
        if (!file2.exists()) {
            file2 = null;
        }
        if ((file = this.getDirectory(file2)) == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    @Override
    protected boolean doCheckState() {
        String string = this.getTextControl().getText();
        if ((string = string.trim()).length() == 0 && this.isEmptyStringAllowed()) {
            return true;
        }
        File file = new File(string);
        return file.isDirectory();
    }

    private File getDirectory(File file) {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 0x10001000);
        if (file != null) {
            directoryDialog.setFilterPath(file.getPath());
        } else if (this.filterPath != null) {
            directoryDialog.setFilterPath(this.filterPath.getPath());
        }
        String string = directoryDialog.open();
        if (string != null && (string = string.trim()).length() > 0) {
            return new File(string);
        }
        return null;
    }

    public void setFilterPath(File file) {
        this.filterPath = file;
    }
}

