/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo;
    private String fValue;
    private String[][] fEntryNamesAndValues;

    public ComboFieldEditor(String string, String string2, String[][] stringArray, Composite composite) {
        this.init(string, string2);
        Assert.isTrue((boolean)this.checkArray(stringArray));
        this.fEntryNamesAndValues = stringArray;
        this.createControl(composite);
    }

    private boolean checkArray(String[][] stringArray) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null || stringArray2.length != 2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    protected void adjustForNumColumns(int n) {
        if (n > 1) {
            Label label = this.getLabelControl();
            int n2 = n;
            if (label != null) {
                ((GridData)label.getLayoutData()).horizontalSpan = 1;
                --n2;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = n2;
        } else {
            Label label = this.getLabelControl();
            if (label != null) {
                ((GridData)label.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        int n2 = 1;
        if (n > 1) {
            n2 = n - 1;
        }
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = this.getComboBoxControl(composite);
        gridData = new GridData();
        gridData.horizontalSpan = n2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        label.setFont(composite.getFont());
    }

    @Override
    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    @Override
    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    private Combo getComboBoxControl(Composite composite) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(composite, 8);
            this.fCombo.setFont(composite.getFont());
            int n = 0;
            while (n < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[n][0], n);
                ++n;
            }
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = ComboFieldEditor.this.fValue;
                    String string2 = ComboFieldEditor.this.fCombo.getText();
                    ComboFieldEditor.this.fValue = ComboFieldEditor.this.getValueForName(string2);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fireValueChanged("field_editor_value", string, ComboFieldEditor.this.fValue);
                }
            });
        }
        return this.fCombo;
    }

    private String getValueForName(String string) {
        int n = 0;
        while (n < this.fEntryNamesAndValues.length) {
            String[] stringArray = this.fEntryNamesAndValues[n];
            if (string.equals(stringArray[0])) {
                return stringArray[1];
            }
            ++n;
        }
        return this.fEntryNamesAndValues[0][0];
    }

    private void updateComboForValue(String string) {
        this.fValue = string;
        int n = 0;
        while (n < this.fEntryNamesAndValues.length) {
            if (string.equals(this.fEntryNamesAndValues[n][1])) {
                this.fCombo.setText(this.fEntryNamesAndValues[n][0]);
                return;
            }
            ++n;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            this.fValue = this.fEntryNamesAndValues[0][1];
            this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
        }
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.getComboBoxControl(composite).setEnabled(bl);
    }
}

