/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ColorSelector
extends EventManager {
    public static final String PROP_COLORCHANGE = "colorValue";
    private Button fButton;
    private Color fColor;
    private RGB fColorValue;
    private Point fExtent;
    private Image fImage;

    public ColorSelector(Composite composite) {
        this.fButton = new Button(composite, 8);
        this.fExtent = this.computeImageSize((Control)composite);
        this.fImage = new Image((Device)composite.getDisplay(), this.fExtent.x, this.fExtent.y);
        GC gC = new GC((Drawable)this.fImage);
        gC.setBackground(this.fButton.getBackground());
        gC.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        gC.dispose();
        this.fButton.setImage(this.fImage);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorSelector.this.open();
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ColorSelector.this.fImage != null) {
                    ColorSelector.this.fImage.dispose();
                    ColorSelector.this.fImage = null;
                }
                if (ColorSelector.this.fColor != null) {
                    ColorSelector.this.fColor.dispose();
                    ColorSelector.this.fColor = null;
                }
            }
        });
        this.fButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = JFaceResources.getString("ColorSelector.Name");
            }
        });
    }

    public void addListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    private Point computeImageSize(Control control) {
        GC gC = new GC((Drawable)control);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont");
        gC.setFont(font);
        int n = gC.getFontMetrics().getHeight();
        gC.dispose();
        Point point = new Point(n * 3 - 6, n);
        return point;
    }

    public Button getButton() {
        return this.fButton;
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void removeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    public void setColorValue(RGB rGB) {
        this.fColorValue = rGB;
        this.updateColorImage();
    }

    public void setEnabled(boolean bl) {
        this.getButton().setEnabled(bl);
    }

    protected void updateColorImage() {
        Display display = this.fButton.getDisplay();
        GC gC = new GC((Drawable)this.fImage);
        gC.setForeground(display.getSystemColor(2));
        gC.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        this.fColor = new Color((Device)display, this.fColorValue);
        gC.setBackground(this.fColor);
        gC.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        gC.dispose();
        this.fButton.setImage(this.fImage);
    }

    public void open() {
        ColorDialog colorDialog = new ColorDialog(this.fButton.getShell());
        colorDialog.setRGB(this.fColorValue);
        RGB rGB = colorDialog.open();
        if (rGB != null) {
            RGB rGB2 = this.fColorValue;
            this.fColorValue = rGB;
            Object[] objectArray = this.getListeners();
            if (objectArray.length > 0) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, PROP_COLORCHANGE, rGB2, rGB);
                int n = 0;
                while (n < objectArray.length) {
                    IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
                    iPropertyChangeListener.propertyChange(propertyChangeEvent);
                    ++n;
                }
            }
            this.updateColorImage();
        }
    }
}

