/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ColorFieldEditor
extends FieldEditor {
    private ColorSelector colorSelector;

    protected ColorFieldEditor() {
    }

    public ColorFieldEditor(String string, String string2, Composite composite) {
        super(string, string2, composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        ((GridData)this.colorSelector.getButton().getLayoutData()).horizontalSpan = n - 1;
    }

    protected Point computeImageSize(Control control) {
        GC gC = new GC((Drawable)control);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gC.setFont(font);
        int n = gC.getFontMetrics().getHeight();
        gC.dispose();
        Point point = new Point(n * 3 - 6, n);
        return point;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        Label label = this.getLabelControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n - 1;
        label.setLayoutData((Object)gridData);
        Button button = this.getChangeControl(composite);
        button.setLayoutData((Object)new GridData());
    }

    @Override
    protected void doLoad() {
        if (this.colorSelector == null) {
            return;
        }
        this.colorSelector.setColorValue(PreferenceConverter.getColor(this.getPreferenceStore(), this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        if (this.colorSelector == null) {
            return;
        }
        this.colorSelector.setColorValue(PreferenceConverter.getDefaultColor(this.getPreferenceStore(), this.getPreferenceName()));
    }

    @Override
    protected void doStore() {
        PreferenceConverter.setValue(this.getPreferenceStore(), this.getPreferenceName(), this.colorSelector.getColorValue());
    }

    public ColorSelector getColorSelector() {
        return this.colorSelector;
    }

    protected Button getChangeControl(Composite composite) {
        if (this.colorSelector == null) {
            this.colorSelector = new ColorSelector(composite);
            this.colorSelector.addListener(new IPropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ColorFieldEditor.this.fireValueChanged(propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    ColorFieldEditor.this.setPresentsDefaultValue(false);
                }
            });
        } else {
            this.checkParent((Control)this.colorSelector.getButton(), composite);
        }
        return this.colorSelector.getButton();
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.getChangeControl(composite).setEnabled(bl);
    }
}

