/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class BooleanFieldEditor
extends FieldEditor {
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    private int style;
    private boolean wasSelected;
    private Button checkBox = null;

    protected BooleanFieldEditor() {
    }

    public BooleanFieldEditor(String string, String string2, int n, Composite composite) {
        this.init(string, string2);
        this.style = n;
        this.createControl(composite);
    }

    public BooleanFieldEditor(String string, String string2, Composite composite) {
        this(string, string2, 0, composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        if (this.style == 1) {
            --n;
        }
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = n;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        String string = this.getLabelText();
        switch (this.style) {
            case 1: {
                this.getLabelControl(composite);
                --n;
                string = null;
            }
        }
        this.checkBox = this.getChangeControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        this.checkBox.setLayoutData((Object)gridData);
        if (string != null) {
            this.checkBox.setText(string);
        }
    }

    public Control getDescriptionControl(Composite composite) {
        if (this.style == 1) {
            return this.getLabelControl(composite);
        }
        return this.getChangeControl(composite);
    }

    @Override
    protected void doLoad() {
        if (this.checkBox != null) {
            boolean bl = this.getPreferenceStore().getBoolean(this.getPreferenceName());
            this.checkBox.setSelection(bl);
            this.wasSelected = bl;
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.checkBox != null) {
            boolean bl = this.getPreferenceStore().getDefaultBoolean(this.getPreferenceName());
            this.checkBox.setSelection(bl);
            this.wasSelected = bl;
        }
    }

    @Override
    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.checkBox.getSelection());
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getChangeControl(Composite composite) {
        if (this.checkBox == null) {
            this.checkBox = new Button(composite, 16416);
            this.checkBox.setFont(composite.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = BooleanFieldEditor.this.checkBox.getSelection();
                    BooleanFieldEditor.this.valueChanged(BooleanFieldEditor.this.wasSelected, bl);
                    BooleanFieldEditor.this.wasSelected = bl;
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    BooleanFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, composite);
        }
        return this.checkBox;
    }

    @Override
    public int getNumberOfControls() {
        switch (this.style) {
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    @Override
    public void setLabelText(String string) {
        super.setLabelText(string);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(string);
        }
    }

    protected void valueChanged(boolean bl, boolean bl2) {
        this.setPresentsDefaultValue(false);
        if (bl != bl2) {
            this.fireStateChanged("field_editor_value", bl, bl2);
        }
    }

    @Override
    public void setEnabled(boolean bl, Composite composite) {
        if (this.style == 1) {
            super.setEnabled(bl, composite);
        }
        this.getChangeControl(composite).setEnabled(bl);
    }
}

