/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.AccumulatingProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.widgets.Display;

public class ModalContext {
    private static boolean debug = false;
    private static int modalLevel = 0;
    private static boolean runInSeparateThread = true;

    /*
     * Unable to fully structure code
     */
    public static boolean canProgressMonitorBeUsed(IProgressMonitor var0, IProgressMonitor var1_1) {
        if (var0 != var1_1) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((var0 = ((ProgressMonitorWrapper)var0).getWrappedProgressMonitor()) != var1_1) continue;
            return true;
lbl5:
            // 2 sources

            ** while (var0 instanceof ProgressMonitorWrapper)
        }
lbl6:
        // 1 sources

        return false;
    }

    public static void checkCanceled(IProgressMonitor iProgressMonitor) throws InterruptedException {
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static ModalContextThread getCurrentModalContextThread() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ModalContextThread) {
            return (ModalContextThread)thread;
        }
        return null;
    }

    public static int getModalLevel() {
        return modalLevel;
    }

    public static boolean isModalContextThread(Thread thread) {
        return thread instanceof ModalContextThread;
    }

    public static void run(IRunnableWithProgress iRunnableWithProgress, boolean bl, IProgressMonitor iProgressMonitor, Display display) throws InvocationTargetException, InterruptedException {
        Assert.isTrue((iRunnableWithProgress != null && iProgressMonitor != null ? 1 : 0) != 0);
        ++modalLevel;
        try {
            if (iProgressMonitor != null) {
                iProgressMonitor.setCanceled(false);
            }
            if (!bl || !runInSeparateThread) {
                ModalContext.runInCurrentThread(iRunnableWithProgress, iProgressMonitor);
            } else {
                ModalContextThread modalContextThread = ModalContext.getCurrentModalContextThread();
                if (modalContextThread != null) {
                    Assert.isTrue((boolean)ModalContext.canProgressMonitorBeUsed(iProgressMonitor, modalContextThread.progressMonitor));
                    ModalContext.runInCurrentThread(iRunnableWithProgress, iProgressMonitor);
                } else {
                    modalContextThread = new ModalContextThread(iRunnableWithProgress, iProgressMonitor, display);
                    Throwable throwable = null;
                    if (iRunnableWithProgress instanceof IThreadListener) {
                        throwable = ModalContext.invokeThreadListener((IThreadListener)((Object)iRunnableWithProgress), modalContextThread);
                    }
                    if (throwable == null) {
                        modalContextThread.start();
                        modalContextThread.block();
                    } else if (modalContextThread.throwable == null) {
                        modalContextThread.throwable = throwable;
                    }
                    Throwable throwable2 = modalContextThread.throwable;
                    if (throwable2 != null) {
                        if (debug && !(throwable2 instanceof InterruptedException) && !(throwable2 instanceof OperationCanceledException)) {
                            System.err.println("Exception in modal context operation:");
                            throwable2.printStackTrace();
                            System.err.println("Called from:");
                            new InvocationTargetException(null).printStackTrace();
                        }
                        if (throwable2 instanceof InvocationTargetException) {
                            throw (InvocationTargetException)throwable2;
                        }
                        if (throwable2 instanceof InterruptedException) {
                            throw (InterruptedException)throwable2;
                        }
                        if (throwable2 instanceof OperationCanceledException) {
                            throw new InterruptedException(throwable2.getMessage());
                        }
                        throw new InvocationTargetException(throwable2);
                    }
                }
            }
        }
        finally {
            --modalLevel;
        }
    }

    static Throwable invokeThreadListener(IThreadListener iThreadListener, Thread thread) {
        try {
            iThreadListener.threadChange(thread);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Error error) {
            return error;
        }
        catch (RuntimeException runtimeException) {
            return runtimeException;
        }
        return null;
    }

    private static void runInCurrentThread(IRunnableWithProgress iRunnableWithProgress, IProgressMonitor iProgressMonitor) throws InterruptedException, InvocationTargetException {
        try {
            if (iRunnableWithProgress != null) {
                iRunnableWithProgress.run(iProgressMonitor);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (RuntimeException runtimeException) {
            throw new InvocationTargetException(runtimeException);
        }
        catch (Error error) {
            throw new InvocationTargetException(error);
        }
    }

    public static void setDebugMode(boolean bl) {
        debug = bl;
    }

    public static void setAllowReadAndDispatch(boolean bl) {
        runInSeparateThread = bl;
    }

    private static class ModalContextThread
    extends Thread {
        private IRunnableWithProgress runnable;
        private Throwable throwable;
        private IProgressMonitor progressMonitor;
        private Display display;
        private volatile boolean continueEventDispatching = true;
        private Thread callingThread;

        private ModalContextThread(IRunnableWithProgress iRunnableWithProgress, IProgressMonitor iProgressMonitor, Display display) {
            super("ModalContext");
            Assert.isTrue((iProgressMonitor != null && display != null ? 1 : 0) != 0);
            this.runnable = iRunnableWithProgress;
            this.progressMonitor = new AccumulatingProgressMonitor(iProgressMonitor, display);
            this.display = display;
            this.callingThread = Thread.currentThread();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void block() {
            if (this.display == Display.getCurrent()) {
                int n = 0;
                while (this.continueEventDispatching) {
                    try {
                        if (!this.display.readAndDispatch()) {
                            this.display.sleep();
                        }
                        n = 0;
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof VirtualMachineError) {
                            throw (VirtualMachineError)throwable;
                        }
                        if (++n > 50 || this.display.isDisposed()) {
                            if (throwable instanceof RuntimeException) {
                                throw (RuntimeException)throwable;
                            }
                            if (throwable instanceof Error) {
                                throw (Error)throwable;
                            }
                            throw new RuntimeException(throwable);
                        }
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", "Unhandled event loop exception during blocked modal context.", throwable));
                    }
                }
            } else {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    this.throwable = interruptedException;
                }
            }
        }
    }
}

