/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Display;

class AccumulatingProgressMonitor
extends ProgressMonitorWrapper {
    private Display display;
    private Collector collector;
    private String currentTask = "";

    public AccumulatingProgressMonitor(IProgressMonitor iProgressMonitor, Display display) {
        super(iProgressMonitor);
        Assert.isNotNull((Object)display);
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(final String string, final int n) {
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AccumulatingProgressMonitor.this.currentTask = string;
                AccumulatingProgressMonitor.this.getWrappedProgressMonitor().beginTask(string, n);
            }
        });
    }

    private synchronized void clearCollector(Collector collector) {
        if (this.collector == collector) {
            this.collector = null;
        }
    }

    private void createCollector(String string, double d) {
        this.collector = new Collector(string, d, this.getWrappedProgressMonitor());
        this.display.asyncExec((Runnable)this.collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AccumulatingProgressMonitor.this.getWrappedProgressMonitor().done();
            }
        });
    }

    public synchronized void internalWorked(double d) {
        if (this.collector == null) {
            this.createCollector(null, d);
        } else {
            this.collector.worked(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskName(final String string) {
        AccumulatingProgressMonitor accumulatingProgressMonitor = this;
        synchronized (accumulatingProgressMonitor) {
            this.collector = null;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AccumulatingProgressMonitor.this.currentTask = string;
                AccumulatingProgressMonitor.this.getWrappedProgressMonitor().setTaskName(string);
            }
        });
    }

    public synchronized void subTask(String string) {
        if (this.collector == null) {
            this.createCollector(string, 0.0);
        } else {
            this.collector.subTask(string);
        }
    }

    public synchronized void worked(int n) {
        this.internalWorked(n);
    }

    public void clearBlocked() {
        final IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
        if (!(iProgressMonitor instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ((IProgressMonitorWithBlocking)iProgressMonitor).clearBlocked();
                Dialog.getBlockedHandler().clearBlocked();
            }
        });
    }

    public void setBlocked(final IStatus iStatus) {
        final IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
        if (!(iProgressMonitor instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ((IProgressMonitorWithBlocking)iProgressMonitor).setBlocked(iStatus);
                Dialog.getBlockedHandler().showBlocked(iProgressMonitor, iStatus, AccumulatingProgressMonitor.this.currentTask);
            }
        });
    }

    private class Collector
    implements Runnable {
        private String subTask;
        private double worked;
        private IProgressMonitor monitor;

        public Collector(String string, double d, IProgressMonitor iProgressMonitor) {
            this.subTask = string;
            this.worked = d;
            this.monitor = iProgressMonitor;
        }

        public void worked(double d) {
            this.worked += d;
        }

        public void subTask(String string) {
            this.subTask = string;
        }

        @Override
        public void run() {
            AccumulatingProgressMonitor.this.clearCollector(this);
            if (this.subTask != null) {
                this.monitor.subTask(this.subTask);
            }
            if (this.worked > 0.0) {
                this.monitor.internalWorked(this.worked);
            }
        }
    }
}

