/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class TreeColumnLayout
extends AbstractColumnLayout {
    private boolean addListener = true;
    private static final TreeLayoutListener listener = new TreeLayoutListener();

    @Override
    protected void layout(Composite composite, boolean bl) {
        super.layout(composite, bl);
        if (this.addListener) {
            this.addListener = false;
            ((Tree)this.getControl(composite)).addTreeListener((TreeListener)listener);
        }
    }

    @Override
    protected int getColumnCount(Scrollable scrollable) {
        return ((Tree)scrollable).getColumnCount();
    }

    @Override
    protected void setColumnWidths(Scrollable scrollable, int[] nArray) {
        TreeColumn[] treeColumnArray = ((Tree)scrollable).getColumns();
        int n = 0;
        while (n < nArray.length) {
            treeColumnArray[n].setWidth(nArray[n]);
            ++n;
        }
    }

    @Override
    protected ColumnLayoutData getLayoutData(Scrollable scrollable, int n) {
        TreeColumn treeColumn = ((Tree)scrollable).getColumn(n);
        return (ColumnLayoutData)treeColumn.getData("org.eclipse.jface.LAYOUT_DATA");
    }

    @Override
    protected void updateColumnData(Widget widget) {
        TreeColumn treeColumn = (TreeColumn)widget;
        Tree tree = treeColumn.getParent();
        if (!IS_GTK || tree.getColumn(tree.getColumnCount() - 1) != treeColumn) {
            treeColumn.setData("org.eclipse.jface.LAYOUT_DATA", (Object)new ColumnPixelData(treeColumn.getWidth()));
            this.layout(tree.getParent(), true);
        }
    }

    private static class TreeLayoutListener
    implements TreeListener {
        private TreeLayoutListener() {
        }

        public void treeCollapsed(TreeEvent treeEvent) {
            this.update((Tree)treeEvent.widget);
        }

        public void treeExpanded(TreeEvent treeEvent) {
            this.update((Tree)treeEvent.widget);
        }

        private void update(final Tree tree) {
            tree.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    tree.update();
                    tree.getParent().layout();
                }
            });
        }
    }
}

