/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class RowLayoutFactory {
    private RowLayout layout;

    private RowLayoutFactory(RowLayout rowLayout) {
        this.layout = rowLayout;
    }

    public static RowLayoutFactory createFrom(RowLayout rowLayout) {
        return new RowLayoutFactory(RowLayoutFactory.copyLayout(rowLayout));
    }

    public RowLayoutFactory copy() {
        return new RowLayoutFactory(this.create());
    }

    public static RowLayoutFactory swtDefaults() {
        return new RowLayoutFactory(new RowLayout());
    }

    public static RowLayoutFactory fillDefaults() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.spacing = LayoutConstants.getSpacing().x;
        return new RowLayoutFactory(rowLayout);
    }

    public RowLayoutFactory spacing(int n) {
        this.layout.spacing = n;
        return this;
    }

    public RowLayoutFactory margins(Point point) {
        this.layout.marginWidth = point.x;
        this.layout.marginHeight = point.y;
        return this;
    }

    public RowLayoutFactory margins(int n, int n2) {
        this.layout.marginWidth = n;
        this.layout.marginHeight = n2;
        return this;
    }

    public RowLayoutFactory extendedMargins(int n, int n2, int n3, int n4) {
        this.layout.marginLeft = n;
        this.layout.marginRight = n2;
        this.layout.marginTop = n3;
        this.layout.marginBottom = n4;
        return this;
    }

    public RowLayoutFactory fill(boolean bl) {
        this.layout.fill = bl;
        return this;
    }

    public RowLayoutFactory justify(boolean bl) {
        this.layout.justify = bl;
        return this;
    }

    public RowLayoutFactory pack(boolean bl) {
        this.layout.pack = bl;
        return this;
    }

    public RowLayoutFactory wrap(boolean bl) {
        this.layout.wrap = bl;
        return this;
    }

    public RowLayoutFactory type(int n) {
        if (n != 256 && n != 512) {
            throw new IllegalArgumentException();
        }
        this.layout.type = n;
        return this;
    }

    public RowLayout create() {
        return RowLayoutFactory.copyLayout(this.layout);
    }

    public void applyTo(Composite composite) {
        composite.setLayout((Layout)RowLayoutFactory.copyLayout(this.layout));
    }

    public static RowLayout copyLayout(RowLayout rowLayout) {
        RowLayout rowLayout2 = new RowLayout(rowLayout.type);
        rowLayout2.marginBottom = rowLayout.marginBottom;
        rowLayout2.marginTop = rowLayout.marginTop;
        rowLayout2.marginLeft = rowLayout.marginLeft;
        rowLayout2.marginRight = rowLayout.marginRight;
        rowLayout2.marginHeight = rowLayout.marginHeight;
        rowLayout2.marginWidth = rowLayout.marginWidth;
        rowLayout2.fill = rowLayout.fill;
        rowLayout2.justify = rowLayout.justify;
        rowLayout2.pack = rowLayout.pack;
        rowLayout2.spacing = rowLayout.spacing;
        rowLayout2.wrap = rowLayout.wrap;
        rowLayout2.type = rowLayout.type;
        return rowLayout2;
    }
}

