/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class PixelConverter {
    private final FontMetrics fontMetrics;

    public PixelConverter(Control control) {
        this(control.getFont());
    }

    public PixelConverter(Font font) {
        GC gC = new GC((Drawable)font.getDevice());
        gC.setFont(font);
        this.fontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    public int convertHeightInCharsToPixels(int n) {
        return Dialog.convertHeightInCharsToPixels(this.fontMetrics, n);
    }

    public int convertHorizontalDLUsToPixels(int n) {
        return Dialog.convertHorizontalDLUsToPixels(this.fontMetrics, n);
    }

    public int convertVerticalDLUsToPixels(int n) {
        return Dialog.convertVerticalDLUsToPixels(this.fontMetrics, n);
    }

    public int convertWidthInCharsToPixels(int n) {
        return Dialog.convertWidthInCharsToPixels(this.fontMetrics, n);
    }
}

