/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

class LayoutGenerator {
    private static final Point defaultSize = new Point(150, 150);
    private static final int wrapSize = 350;
    private static final GridDataFactory nonWrappingLabelData = GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false);

    LayoutGenerator() {
    }

    private static boolean hasStyle(Control control, int n) {
        return (control.getStyle() & n) != 0;
    }

    public static void generateLayout(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.getLayoutData() == null) {
                LayoutGenerator.applyLayoutDataTo(control);
            }
            ++n;
        }
    }

    private static void applyLayoutDataTo(Control control) {
        LayoutGenerator.defaultsFor(control).applyTo(control);
    }

    public static GridDataFactory defaultsFor(Control control) {
        boolean bl;
        Composite composite;
        Layout layout;
        Scrollable scrollable;
        if (control instanceof Button) {
            Button button = (Button)control;
            if (LayoutGenerator.hasStyle((Control)button, 32)) {
                return nonWrappingLabelData.copy();
            }
            return GridDataFactory.fillDefaults().align(4, 0x1000000).hint(Geometry.max(button.computeSize(-1, -1, true), LayoutConstants.getMinButtonSize()));
        }
        if (control instanceof Scrollable && (scrollable = (Scrollable)control) instanceof Composite && (layout = (composite = (Composite)control).getLayout()) instanceof GridLayout) {
            boolean bl2 = false;
            boolean bl3 = false;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Control control2 = controlArray[n];
                GridData gridData = (GridData)control2.getLayoutData();
                if (gridData != null) {
                    if (gridData.grabExcessHorizontalSpace) {
                        bl2 = true;
                    }
                    if (gridData.grabExcessVerticalSpace) {
                        bl3 = true;
                    }
                }
                ++n;
            }
            return GridDataFactory.fillDefaults().grab(bl2, bl3);
        }
        boolean bl4 = LayoutGenerator.hasStyle(control, 64);
        boolean bl5 = LayoutGenerator.hasStyle(control, 256);
        boolean bl6 = LayoutGenerator.hasStyle(control, 512);
        boolean bl7 = LayoutGenerator.hasMethod(control, "setText", new Class[]{String.class});
        boolean bl8 = bl = !LayoutGenerator.hasStyle(control, 8) && bl7 && LayoutGenerator.hasMethod(control, "addModifyListener", new Class[]{ModifyListener.class});
        if (bl) {
            if (LayoutGenerator.hasStyle(control, 2)) {
                bl6 = true;
            }
            if (!bl4) {
                bl5 = true;
            }
        }
        int n = -1;
        boolean bl9 = bl5;
        if (bl5) {
            n = LayoutGenerator.defaultSize.x;
        } else if (bl4 && bl7) {
            n = 350;
            bl9 = true;
        }
        int n2 = 4;
        if (!bl6 && !bl4 && !bl && bl7) {
            n2 = 0x1000000;
        }
        return GridDataFactory.fillDefaults().grab(bl9, bl6).align(4, n2).hint(n, bl6 ? LayoutGenerator.defaultSize.y : -1);
    }

    private static boolean hasMethod(Control control, String string, Class[] classArray) {
        Class<?> clazz = control.getClass();
        try {
            return clazz.getMethod(string, classArray) != null;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

