/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.jface.layout.LayoutGenerator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public final class GridDataFactory {
    private GridData data;

    private GridDataFactory(GridData gridData) {
        this.data = gridData;
    }

    public static GridDataFactory swtDefaults() {
        return new GridDataFactory(new GridData());
    }

    public static GridDataFactory createFrom(GridData gridData) {
        return new GridDataFactory(GridDataFactory.copyData(gridData));
    }

    public static GridDataFactory fillDefaults() {
        GridData gridData = new GridData();
        gridData.minimumWidth = 1;
        gridData.minimumHeight = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        return new GridDataFactory(gridData);
    }

    public static GridDataFactory defaultsFor(Control control) {
        return LayoutGenerator.defaultsFor(control);
    }

    public static void generate(Control control, int n, int n2) {
        GridDataFactory.defaultsFor(control).span(n, n2).applyTo(control);
    }

    public static void generate(Control control, Point point) {
        GridDataFactory.defaultsFor(control).span(point).applyTo(control);
    }

    public GridDataFactory span(int n, int n2) {
        this.data.horizontalSpan = n;
        this.data.verticalSpan = n2;
        return this;
    }

    public GridDataFactory span(Point point) {
        this.data.horizontalSpan = point.x;
        this.data.verticalSpan = point.y;
        return this;
    }

    public GridDataFactory hint(int n, int n2) {
        this.data.widthHint = n;
        this.data.heightHint = n2;
        return this;
    }

    public GridDataFactory hint(Point point) {
        this.data.widthHint = point.x;
        this.data.heightHint = point.y;
        return this;
    }

    public GridDataFactory align(int n, int n2) {
        if (n != 1 && n != 0x1000000 && n != 2 && n != 0x1000008 && n != 3 && n != 4 && n != 16384 && n != 131072) {
            throw new IllegalArgumentException();
        }
        if (n2 != 1 && n2 != 0x1000000 && n2 != 2 && n2 != 0x1000008 && n2 != 3 && n2 != 4 && n2 != 128 && n2 != 1024) {
            throw new IllegalArgumentException();
        }
        this.data.horizontalAlignment = n;
        this.data.verticalAlignment = n2;
        return this;
    }

    public GridDataFactory indent(int n, int n2) {
        this.data.horizontalIndent = n;
        this.data.verticalIndent = n2;
        return this;
    }

    public GridDataFactory indent(Point point) {
        this.data.horizontalIndent = point.x;
        this.data.verticalIndent = point.y;
        return this;
    }

    public GridDataFactory grab(boolean bl, boolean bl2) {
        this.data.grabExcessHorizontalSpace = bl;
        this.data.grabExcessVerticalSpace = bl2;
        return this;
    }

    public GridDataFactory minSize(int n, int n2) {
        this.data.minimumWidth = n;
        this.data.minimumHeight = n2;
        return this;
    }

    public GridDataFactory minSize(Point point) {
        this.data.minimumWidth = point.x;
        this.data.minimumHeight = point.y;
        return this;
    }

    public GridDataFactory exclude(boolean bl) {
        this.data.exclude = bl;
        return this;
    }

    public GridData create() {
        return GridDataFactory.copyData(this.data);
    }

    public GridDataFactory copy() {
        return new GridDataFactory(this.create());
    }

    public static GridData copyData(GridData gridData) {
        GridData gridData2 = new GridData(gridData.horizontalAlignment, gridData.verticalAlignment, gridData.grabExcessHorizontalSpace, gridData.grabExcessVerticalSpace, gridData.horizontalSpan, gridData.verticalSpan);
        gridData2.exclude = gridData.exclude;
        gridData2.heightHint = gridData.heightHint;
        gridData2.horizontalIndent = gridData.horizontalIndent;
        gridData2.minimumHeight = gridData.minimumHeight;
        gridData2.minimumWidth = gridData.minimumWidth;
        gridData2.verticalIndent = gridData.verticalIndent;
        gridData2.widthHint = gridData.widthHint;
        return gridData2;
    }

    public void applyTo(Control control) {
        control.setLayoutData((Object)this.create());
    }
}

