/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractColumnLayout
extends Layout {
    private static int COLUMN_TRIM = Util.isWindows() ? 4 : (Util.isMac() ? 24 : 3);
    static final boolean IS_GTK = Util.isGtk();
    protected static final String LAYOUT_DATA = "org.eclipse.jface.LAYOUT_DATA";
    private boolean inupdateMode = false;
    private boolean relayout = true;
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (!AbstractColumnLayout.this.inupdateMode) {
                AbstractColumnLayout.this.updateColumnData(event.widget);
            }
        }
    };

    public void setColumnData(Widget widget, ColumnLayoutData columnLayoutData) {
        if (widget.getData(LAYOUT_DATA) == null) {
            widget.addListener(11, this.resizeListener);
        }
        widget.setData(LAYOUT_DATA, (Object)columnLayoutData);
    }

    private Point computeTableTreeSize(Scrollable scrollable, int n, int n2) {
        Point point = scrollable.computeSize(n, n2);
        int n3 = 0;
        int n4 = this.getColumnCount(scrollable);
        int n5 = 0;
        while (n5 < n4) {
            ColumnLayoutData columnLayoutData;
            ColumnLayoutData columnLayoutData2 = this.getLayoutData(scrollable, n5);
            if (columnLayoutData2 instanceof ColumnPixelData) {
                columnLayoutData = (ColumnPixelData)columnLayoutData2;
                n3 += columnLayoutData.width;
                if (columnLayoutData.addTrim) {
                    n3 += this.getColumnTrim();
                }
            } else if (columnLayoutData2 instanceof ColumnWeightData) {
                columnLayoutData = (ColumnWeightData)columnLayoutData2;
                n3 += ((ColumnWeightData)columnLayoutData).minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n5;
        }
        if (n3 > point.x) {
            point.x = n3;
        }
        return point;
    }

    private void layoutTableTree(Scrollable scrollable, int n, Rectangle rectangle, boolean bl) {
        int n2 = this.getColumnCount(scrollable);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            ColumnLayoutData columnLayoutData;
            ColumnLayoutData columnLayoutData2 = this.getLayoutData(scrollable, n6);
            if (columnLayoutData2 instanceof ColumnPixelData) {
                columnLayoutData = (ColumnPixelData)columnLayoutData2;
                int n7 = columnLayoutData.width;
                if (columnLayoutData.addTrim) {
                    n7 += this.getColumnTrim();
                }
                nArray[n6] = n7;
                n4 += n7;
            } else if (columnLayoutData2 instanceof ColumnWeightData) {
                columnLayoutData = (ColumnWeightData)columnLayoutData2;
                nArray2[n3] = n6;
                ++n3;
                n5 += ((ColumnWeightData)columnLayoutData).weight;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n6;
        }
        block1: do {
            n6 = 0;
            int n8 = 0;
            while (n8 < n3) {
                int n9;
                int n10 = nArray2[n8];
                ColumnWeightData columnWeightData = (ColumnWeightData)this.getLayoutData(scrollable, n10);
                int n11 = columnWeightData.minimumWidth;
                int n12 = n9 = n5 == 0 ? 0 : (n - n4) * columnWeightData.weight / n5;
                if (n9 < n11) {
                    n5 -= columnWeightData.weight;
                    n4 += n11;
                    nArray[n10] = n11;
                    System.arraycopy(nArray2, n8 + 1, nArray2, n8, --n3 - n8);
                    n6 = 1;
                    continue block1;
                }
                nArray[n10] = n9;
                ++n8;
            }
        } while (n6 != 0);
        if (bl) {
            scrollable.setSize(rectangle.width, rectangle.height);
        }
        this.inupdateMode = true;
        this.setColumnWidths(scrollable, nArray);
        scrollable.update();
        this.inupdateMode = false;
        if (!bl) {
            scrollable.setSize(rectangle.width, rectangle.height);
        }
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        return this.computeTableTreeSize(this.getControl(composite), n, n2);
    }

    protected void layout(Composite composite, boolean bl) {
        int n;
        Scrollable scrollable;
        Rectangle rectangle = composite.getClientArea();
        int n2 = this.computeTrim(rectangle, scrollable = this.getControl(composite), n = scrollable.getSize().x);
        int n3 = Math.max(0, rectangle.width - n2);
        if (n3 > 1) {
            this.layoutTableTree(scrollable, n3, rectangle, n < rectangle.width);
        }
        if (this.relayout) {
            this.relayout = false;
            composite.layout();
        }
    }

    private int computeTrim(Rectangle rectangle, Scrollable scrollable, int n) {
        int n2 = n > 1 ? n - scrollable.getClientArea().width : 2 * scrollable.getBorderWidth() + 1;
        return n2;
    }

    Scrollable getControl(Composite composite) {
        return (Scrollable)composite.getChildren()[0];
    }

    protected abstract int getColumnCount(Scrollable var1);

    protected abstract void setColumnWidths(Scrollable var1, int[] var2);

    protected abstract ColumnLayoutData getLayoutData(Scrollable var1, int var2);

    protected abstract void updateColumnData(Widget var1);

    protected int getColumnTrim() {
        return COLUMN_TRIM;
    }
}

