/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public class FieldDecorationRegistry {
    public static final String DEC_CONTENT_PROPOSAL = "DEC_CONTENT_PROPOSAL";
    public static final String DEC_REQUIRED = "DEC_REQUIRED";
    public static final String DEC_ERROR = "DEC_ERROR";
    public static final String DEC_WARNING = "DEC_WARNING";
    public static final String DEC_INFORMATION = "DEC_INFORMATION";
    public static final String DEC_ERROR_QUICKFIX = "DEC_ERRORQUICKFIX";
    private static final String IMG_DEC_FIELD_CONTENT_PROPOSAL = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_CONTENT_PROPOSAL";
    private static final String IMG_DEC_FIELD_REQUIRED = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_REQUIRED";
    private static final String IMG_DEC_FIELD_ERROR = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_ERROR";
    private static final String IMG_DEC_FIELD_ERROR_QUICKFIX = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_ERROR_QUICKFIX";
    private static final String IMG_DEC_FIELD_WARNING = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_WARNING";
    private static final String IMG_DEC_FIELD_INFO = "org.eclipse.jface.fieldassist.IMG_DEC_FIELD_INFO";
    private static FieldDecorationRegistry defaultInstance;
    private int maxDecorationWidth = 0;
    private int maxDecorationHeight = 0;
    private HashMap decorations = new HashMap();

    static {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        imageRegistry.put(IMG_DEC_FIELD_CONTENT_PROPOSAL, ImageDescriptor.createFromFile(FieldDecorationRegistry.class, "images/contassist_ovr.gif"));
        imageRegistry.put(IMG_DEC_FIELD_ERROR, ImageDescriptor.createFromFile(FieldDecorationRegistry.class, "images/error_ovr.gif"));
        imageRegistry.put(IMG_DEC_FIELD_WARNING, ImageDescriptor.createFromFile(FieldDecorationRegistry.class, "images/warn_ovr.gif"));
        imageRegistry.put(IMG_DEC_FIELD_REQUIRED, ImageDescriptor.createFromFile(FieldDecorationRegistry.class, "images/required_field_cue.gif"));
        imageRegistry.put(IMG_DEC_FIELD_ERROR_QUICKFIX, ImageDescriptor.createFromFile(FieldDecorationRegistry.class, "images/errorqf_ovr.gif"));
        imageRegistry.put(IMG_DEC_FIELD_INFO, ImageDescriptor.createFromFile(FieldDecorationRegistry.class, "images/info_ovr.gif"));
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_CONTENT_PROPOSAL, JFaceResources.getString("FieldDecorationRegistry.contentAssistMessage"), IMG_DEC_FIELD_CONTENT_PROPOSAL, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_ERROR, JFaceResources.getString("FieldDecorationRegistry.errorMessage"), IMG_DEC_FIELD_ERROR, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_ERROR_QUICKFIX, JFaceResources.getString("FieldDecorationRegistry.errorQuickFixMessage"), IMG_DEC_FIELD_ERROR_QUICKFIX, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_WARNING, null, IMG_DEC_FIELD_WARNING, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_INFORMATION, null, IMG_DEC_FIELD_INFO, imageRegistry);
        FieldDecorationRegistry.getDefault().registerFieldDecoration(DEC_REQUIRED, JFaceResources.getString("FieldDecorationRegistry.requiredFieldMessage"), IMG_DEC_FIELD_REQUIRED, imageRegistry);
    }

    public static FieldDecorationRegistry getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new FieldDecorationRegistry();
        }
        return defaultInstance;
    }

    public static void setDefault(FieldDecorationRegistry fieldDecorationRegistry) {
        defaultInstance = fieldDecorationRegistry;
    }

    public int getMaximumDecorationWidth() {
        return this.maxDecorationWidth;
    }

    public int getMaximumDecorationHeight() {
        return this.maxDecorationHeight;
    }

    public void registerFieldDecoration(String string, String string2, Image image) {
        this.decorations.put(string, new Entry(string2, image));
        this.recomputeMaximums();
    }

    public void registerFieldDecoration(String string, String string2, String string3) {
        this.decorations.put(string, new Entry(string2, string3, JFaceResources.getImageRegistry()));
        this.recomputeMaximums();
    }

    public void registerFieldDecoration(String string, String string2, String string3, ImageRegistry imageRegistry) {
        this.decorations.put(string, new Entry(string2, string3, imageRegistry));
        this.recomputeMaximums();
    }

    public void unregisterFieldDecoration(String string) {
        this.decorations.remove(string);
        this.recomputeMaximums();
    }

    public FieldDecoration getFieldDecoration(String string) {
        Object v = this.decorations.get(string);
        if (v == null) {
            return null;
        }
        return ((Entry)v).getDecoration();
    }

    private void recomputeMaximums() {
        Iterator iterator = this.decorations.values().iterator();
        this.maxDecorationHeight = 0;
        this.maxDecorationWidth = 0;
        while (iterator.hasNext()) {
            Image image = ((Entry)iterator.next()).getDecoration().getImage();
            if (image == null) continue;
            this.maxDecorationHeight = Math.max(this.maxDecorationHeight, image.getBounds().height);
            this.maxDecorationWidth = Math.max(this.maxDecorationWidth, image.getBounds().width);
        }
    }

    class Entry {
        private String description;
        private String imageId;
        private ImageRegistry imageRegistry;
        private Image image;
        private FieldDecoration decoration;

        Entry(String string, String string2, ImageRegistry imageRegistry) {
            this.description = string;
            this.imageId = string2;
            this.imageRegistry = imageRegistry;
        }

        Entry(String string, Image image) {
            this.description = string;
            this.image = image;
        }

        FieldDecoration getDecoration() {
            if (this.decoration == null) {
                if (this.image == null) {
                    if (this.imageRegistry == null) {
                        this.imageRegistry = JFaceResources.getImageRegistry();
                    }
                    this.image = this.imageRegistry.get(this.imageId);
                }
                this.decoration = new FieldDecoration(this.image, this.description);
            }
            this.description = null;
            this.imageId = null;
            this.imageRegistry = null;
            this.image = null;
            return this.decoration;
        }
    }
}

