/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class FieldAssistColors {
    private static boolean DEBUG = false;
    private static Map requiredFieldColorMap = new HashMap();
    private static Map displays = new HashMap();

    public static RGB computeErrorFieldBackgroundRGB(Control control) {
        Color color = control.getBackground();
        Color color2 = JFaceColors.getErrorText(control.getDisplay());
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 25;
        n += (color2.getRed() - n) * n4 / 255;
        n2 += (color2.getGreen() - n2) * n4 / 255;
        n3 += (color2.getBlue() - n3) * n4 / 255;
        return new RGB(n, n2, n3);
    }

    public static Color getRequiredFieldBackgroundColor(Control control) {
        final Display display = control.getDisplay();
        if (display.getHighContrast()) {
            return control.getBackground();
        }
        Object v = requiredFieldColorMap.get(control.getBackground());
        if (v != null) {
            return (Color)v;
        }
        Color color = control.getBackground();
        Color color2 = display.getSystemColor(7);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 38;
        n += (color2.getRed() - n) * n4 / 255;
        n2 += (color2.getGreen() - n2) * n4 / 255;
        n3 += (color2.getBlue() - n3) * n4 / 255;
        Color color3 = new Color((Device)display, n, n2, n3);
        requiredFieldColorMap.put(color, color3);
        if (!displays.containsValue(display)) {
            display.disposeExec(new Runnable(){

                @Override
                public void run() {
                    FieldAssistColors.disposeColors(display);
                }
            });
        }
        displays.put(color3, display);
        return color3;
    }

    private static void disposeColors(Display display) {
        ArrayList<Color> arrayList = new ArrayList<Color>(1);
        if (DEBUG) {
            System.out.println("Display map is " + displays.toString());
            System.out.println("Color map is " + requiredFieldColorMap.toString());
        }
        for (Color color : displays.keySet()) {
            if (!((Display)displays.get(color)).equals(display)) continue;
            arrayList.add(color);
            ArrayList<Color> arrayList2 = new ArrayList<Color>(1);
            for (Color color2 : requiredFieldColorMap.keySet()) {
                if (!((Color)requiredFieldColorMap.get(color2)).equals((Object)color)) continue;
                arrayList2.add(color2);
            }
            int n = 0;
            while (n < arrayList2.size()) {
                requiredFieldColorMap.remove(arrayList2.get(n));
                ++n;
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            Color color;
            color = (Color)arrayList.get(n);
            displays.remove(color);
            if (DEBUG) {
                System.out.println("Disposing color " + color.toString());
            }
            color.dispose();
            ++n;
        }
        if (DEBUG) {
            System.out.println("Display map is " + displays.toString());
            System.out.println("Color map is " + requiredFieldColorMap.toString());
        }
    }
}

