/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DecoratedField {
    private static boolean MAC = Util.isMac();
    private static final int LEFT_TOP = 0;
    private static final int LEFT_BOTTOM = 1;
    private static final int RIGHT_TOP = 2;
    private static final int RIGHT_BOTTOM = 3;
    private static final int DECORATION_SLOTS = 4;
    private FieldDecorationData[] decDatas = new FieldDecorationData[4];
    private Control control;
    private Composite form;
    private boolean useMaxDecorationWidth = true;
    private Hover hover;

    public DecoratedField(Composite composite, int n, IControlCreator iControlCreator) {
        this.form = this.createForm(composite);
        this.control = iControlCreator.createControl(this.form, n);
        this.addControlListeners();
        this.form.setTabList(new Control[]{this.control});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.control.setLayoutData((Object)formData);
    }

    public void addFieldDecoration(FieldDecoration fieldDecoration, int n, boolean bl) {
        Label label;
        FormData formData;
        int n2 = this.indexForPosition(n);
        if (this.decDatas[n2] == null) {
            formData = this.createFormDataForIndex(n2, fieldDecoration.getImage());
            label = new Label(this.form, 0x1000300);
            label.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent mouseEvent) {
                    FieldDecorationData fieldDecorationData = (FieldDecorationData)mouseEvent.widget.getData();
                    String string = fieldDecorationData.decoration.getDescription();
                    if (string != null) {
                        DecoratedField.this.showHoverText(string, (Control)label);
                    }
                }

                public void mouseEnter(MouseEvent mouseEvent) {
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    DecoratedField.this.hideHover();
                }
            });
            this.decDatas[n2] = new FieldDecorationData(fieldDecoration, label, formData, bl);
        } else {
            label = this.decDatas[n2].label;
            formData = this.decDatas[n2].data;
            this.decDatas[n2].decoration = fieldDecoration;
            this.decDatas[n2].showOnFocus = bl;
        }
        label.setImage(this.decDatas[n2].decoration.getImage());
        label.setData((Object)this.decDatas[n2]);
        label.setLayoutData((Object)formData);
        label.setVisible(!bl);
        this.updateControlAttachments(n2, this.decDatas[n2]);
    }

    private void updateControlAttachments(int n, FieldDecorationData fieldDecorationData) {
        FormData formData = (FormData)this.control.getLayoutData();
        int n2 = this.widthOf(fieldDecorationData.decoration.getImage());
        switch (n) {
            case 0: 
            case 1: {
                int n3 = n == 0 ? 1 : 0;
                if (this.decDatas[n3] == null) {
                    formData.left = new FormAttachment((Control)fieldDecorationData.label);
                    break;
                }
                if (this.decDatas[n3].data.width < n2) {
                    formData.left = new FormAttachment((Control)fieldDecorationData.label);
                    this.decDatas[n3].data.left.alignment = 0x1000000;
                    this.decDatas[n3].data.left.control = fieldDecorationData.label;
                    break;
                }
                formData = null;
                fieldDecorationData.data.left.alignment = 0x1000000;
                fieldDecorationData.data.left.control = this.decDatas[n3].label;
                break;
            }
            case 2: 
            case 3: {
                int n4 = n == 2 ? 3 : 2;
                if (this.decDatas[n4] == null) {
                    formData.right = new FormAttachment((Control)fieldDecorationData.label);
                    break;
                }
                if (this.decDatas[n4].data.width < n2) {
                    formData.right = new FormAttachment((Control)fieldDecorationData.label);
                    this.decDatas[n4].data.right.alignment = 0x1000000;
                    this.decDatas[n4].data.right.control = fieldDecorationData.label;
                    break;
                }
                formData = null;
                fieldDecorationData.data.right.alignment = 0x1000000;
                fieldDecorationData.data.right.control = this.decDatas[n4].label;
                break;
            }
            default: {
                return;
            }
        }
        if (formData != null) {
            this.control.setLayoutData((Object)formData);
            this.form.layout();
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Control getLayoutControl() {
        return this.form;
    }

    private Composite createForm(Composite composite) {
        Composite composite2 = new Composite(composite, 524288);
        composite2.setBackgroundMode(1);
        composite2.setLayout((Layout)new FormLayout());
        return composite2;
    }

    private void addControlListeners() {
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (DecoratedField.this.hover != null) {
                    DecoratedField.this.hover.dispose();
                }
            }
        });
        this.control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                DecoratedField.this.controlFocusGained();
            }

            public void focusLost(FocusEvent focusEvent) {
                DecoratedField.this.controlFocusLost();
            }
        });
    }

    private int indexForPosition(int n) {
        switch (n) {
            case 17408: {
                return 1;
            }
            case 131200: {
                return 2;
            }
            case 132096: {
                return 3;
            }
        }
        return 0;
    }

    private FormData createFormDataForIndex(int n, Image image) {
        Assert.isTrue((n >= 0 && n < 4 ? 1 : 0) != 0, (String)"Index out of range");
        FormData formData = new FormData();
        switch (n) {
            case 0: {
                formData.left = new FormAttachment(0, 0);
                formData.top = new FormAttachment(0, 0);
                break;
            }
            case 1: {
                formData.left = new FormAttachment(0, 0);
                formData.bottom = new FormAttachment(100, 0);
                break;
            }
            case 2: {
                formData.right = new FormAttachment(100, 0);
                formData.top = new FormAttachment(0, 0);
                break;
            }
            case 3: {
                formData.right = new FormAttachment(100, 0);
                formData.bottom = new FormAttachment(100, 0);
            }
        }
        formData.width = this.widthOf(image);
        formData.height = -1;
        return formData;
    }

    public void showHoverText(String string) {
        this.showHoverText(string, this.control);
    }

    public void hideHover() {
        if (this.hover != null) {
            this.hover.setVisible(false);
        }
    }

    private void controlFocusGained() {
        int n = 0;
        while (n < 4) {
            if (this.decDatas[n] != null && this.decDatas[n].showOnFocus) {
                this.setVisible(this.decDatas[n], true);
            }
            ++n;
        }
    }

    private void controlFocusLost() {
        int n = 0;
        while (n < 4) {
            if (this.decDatas[n] != null && this.decDatas[n].showOnFocus) {
                this.setVisible(this.decDatas[n], false);
            }
            ++n;
        }
    }

    public void showDecoration(FieldDecoration fieldDecoration) {
        FieldDecorationData fieldDecorationData = this.getDecorationData(fieldDecoration);
        if (fieldDecorationData == null) {
            return;
        }
        fieldDecorationData.visible = true;
        if (!fieldDecorationData.showOnFocus || this.control.isFocusControl()) {
            this.setVisible(fieldDecorationData, true);
        }
    }

    public void hideDecoration(FieldDecoration fieldDecoration) {
        FieldDecorationData fieldDecorationData = this.getDecorationData(fieldDecoration);
        if (fieldDecorationData == null) {
            return;
        }
        fieldDecorationData.visible = false;
        this.setVisible(fieldDecorationData, false);
    }

    public void updateDecoration(FieldDecoration fieldDecoration) {
        FieldDecorationData fieldDecorationData = this.getDecorationData(fieldDecoration);
        if (fieldDecorationData == null) {
            return;
        }
        if (fieldDecorationData.label != null) {
            fieldDecorationData.label.setImage(fieldDecoration.getImage());
            if (fieldDecorationData.label.getVisible() && this.hover != null) {
                this.showHoverText(fieldDecoration.getDescription(), (Control)fieldDecorationData.label);
            }
        }
    }

    private void setVisible(FieldDecorationData fieldDecorationData, boolean bl) {
        if (bl && fieldDecorationData.visible) {
            fieldDecorationData.label.setVisible(true);
        } else {
            fieldDecorationData.label.setVisible(false);
        }
    }

    private FieldDecorationData getDecorationData(FieldDecoration fieldDecoration) {
        int n = 0;
        while (n < 4) {
            if (this.decDatas[n] != null && fieldDecoration == this.decDatas[n].decoration && this.decDatas[n].label != null && !this.decDatas[n].label.isDisposed()) {
                return this.decDatas[n];
            }
            ++n;
        }
        return null;
    }

    private void showHoverText(String string, Control control) {
        if (string == null) {
            this.hideHover();
            return;
        }
        if (this.hover == null) {
            this.hover = new Hover(control.getShell());
        }
        this.hover.setText(string, control, this.control);
        this.hover.setVisible(true);
    }

    public void setUseMaximumDecorationWidth(boolean bl) {
        this.useMaxDecorationWidth = bl;
    }

    private int widthOf(Image image) {
        if (image == null) {
            return 0;
        }
        return this.useMaxDecorationWidth ? FieldDecorationRegistry.getDefault().getMaximumDecorationWidth() : image.getBounds().width;
    }

    private class FieldDecorationData {
        FieldDecoration decoration;
        Label label;
        FormData data;
        boolean showOnFocus;
        boolean visible = true;

        FieldDecorationData(FieldDecoration fieldDecoration, Label label, FormData formData, boolean bl) {
            this.decoration = fieldDecoration;
            this.label = label;
            this.data = formData;
            this.showOnFocus = bl;
        }
    }

    class Hover {
        private static final String EMPTY = "";
        private int hao = 10;
        private int haw = 8;
        private int hah = 10;
        private int hm = 2;
        Shell hoverShell;
        String text = "";
        Region region;
        boolean arrowOnLeft = true;

        Hover(Shell shell) {
            Display display = shell.getDisplay();
            this.hoverShell = new Shell(shell, 540684);
            this.hoverShell.setBackground(display.getSystemColor(29));
            this.hoverShell.setForeground(display.getSystemColor(28));
            this.hoverShell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    paintEvent.gc.drawString(Hover.this.text, Hover.this.hm, Hover.this.hm);
                    if (!MAC) {
                        paintEvent.gc.drawPolygon(Hover.this.getPolygon(true));
                    }
                }
            });
            this.hoverShell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    DecoratedField.this.hideHover();
                }
            });
        }

        int[] getPolygon(boolean bl) {
            int n;
            Point point = this.getExtent();
            int n2 = n = bl ? 1 : 0;
            if (this.arrowOnLeft) {
                int[] nArray = new int[16];
                nArray[2] = point.x - n;
                nArray[4] = point.x - n;
                nArray[5] = point.y - n;
                nArray[6] = this.hao + this.haw;
                nArray[7] = point.y - n;
                nArray[8] = this.hao + this.haw / 2;
                nArray[9] = point.y + this.hah - n;
                nArray[10] = this.hao;
                nArray[11] = point.y - n;
                nArray[13] = point.y - n;
                return nArray;
            }
            int[] nArray = new int[16];
            nArray[2] = point.x - n;
            nArray[4] = point.x - n;
            nArray[5] = point.y - n;
            nArray[6] = point.x - this.hao - n;
            nArray[7] = point.y - n;
            nArray[8] = point.x - this.hao - this.haw / 2;
            nArray[9] = point.y + this.hah - n;
            nArray[10] = point.x - this.hao - this.haw;
            nArray[11] = point.y - n;
            nArray[13] = point.y - n;
            return nArray;
        }

        void dispose() {
            if (!this.hoverShell.isDisposed()) {
                this.hoverShell.dispose();
            }
            if (this.region != null) {
                this.region.dispose();
            }
        }

        void setVisible(boolean bl) {
            if (bl) {
                if (!this.hoverShell.isVisible()) {
                    this.hoverShell.setVisible(true);
                }
            } else if (this.hoverShell.isVisible()) {
                this.hoverShell.setVisible(false);
            }
        }

        void setText(String string, Control control, Control control2) {
            Point point;
            if (string == null) {
                string = EMPTY;
            }
            if (!string.equals(this.text)) {
                point = this.getExtent();
                this.text = string;
                this.hoverShell.redraw();
                Point point2 = this.getExtent();
                if (!point.equals((Object)point2)) {
                    this.arrowOnLeft = control.getLocation().x <= control2.getLocation().x;
                    this.setNewShape();
                }
            }
            if (control != null) {
                point = this.getExtent();
                int n = -point.y - this.hah + 1;
                int n2 = this.arrowOnLeft ? -this.hao + this.haw / 2 : -point.x + this.hao + this.haw / 2;
                this.hoverShell.setLocation(control.toDisplay(n2, n));
            }
        }

        boolean isVisible() {
            return this.hoverShell.isVisible();
        }

        Point getExtent() {
            GC gC = new GC((Drawable)this.hoverShell);
            Point point = gC.textExtent(this.text);
            gC.dispose();
            point.x += this.hm * 2;
            point.y += this.hm * 2;
            return point;
        }

        void setNewShape() {
            Region region = this.region;
            this.region = new Region();
            this.region.add(this.getPolygon(false));
            this.hoverShell.setRegion(this.region);
            if (region != null) {
                region.dispose();
            }
        }
    }
}

