/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlDecoration {
    private static boolean DEBUG = false;
    private static boolean MAC = Util.isMac();
    private Control control;
    private Composite composite;
    private Image image;
    private String descriptionText;
    private int position;
    private boolean visible = true;
    private boolean showOnlyOnFocus = false;
    private boolean showHover = true;
    private int marginWidth = 0;
    private ListenerList selectionListeners = new ListenerList();
    private ListenerList menuDetectListeners = new ListenerList();
    private FocusListener focusListener;
    private DisposeListener disposeListener;
    private PaintListener paintListener;
    private MouseTrackListener mouseTrackListener;
    private MouseMoveListener mouseMoveListener;
    private Listener compositeListener;
    private Control moveListeningTarget = null;
    private int listenerInstalls = 0;
    private Rectangle decorationRectangle;
    private Rectangle previousDecorationRectangle;
    private boolean hasFocus = false;
    private Hover hover;

    public ControlDecoration(Control control, int n) {
        this(control, n, null);
    }

    public ControlDecoration(Control control, int n, Composite composite) {
        this.position = n;
        this.control = control;
        this.composite = composite;
        this.addControlListeners();
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.menuDetectListeners.add((Object)menuDetectListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.menuDetectListeners.remove((Object)menuDetectListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add((Object)selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove((Object)selectionListener);
    }

    public void dispose() {
        if (this.control == null) {
            return;
        }
        if (this.hover != null) {
            this.hover.dispose();
            this.hover = null;
        }
        this.removeControlListeners();
        this.control = null;
    }

    public Control getControl() {
        return this.control;
    }

    private void addControlListeners() {
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ControlDecoration.this.dispose();
            }
        };
        this.printAddListener((Widget)this.control, "DISPOSE");
        this.control.addDisposeListener(this.disposeListener);
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ControlDecoration.this.hasFocus = true;
                if (ControlDecoration.this.showOnlyOnFocus) {
                    ControlDecoration.this.update();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                ControlDecoration.this.hasFocus = false;
                if (ControlDecoration.this.showOnlyOnFocus) {
                    ControlDecoration.this.update();
                }
            }
        };
        this.printAddListener((Widget)this.control, "FOCUS");
        this.control.addFocusListener(this.focusListener);
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Control control = (Control)paintEvent.widget;
                Rectangle rectangle = ControlDecoration.this.getDecorationRectangle(control);
                if (ControlDecoration.this.shouldShowDecoration()) {
                    paintEvent.gc.drawImage(ControlDecoration.this.getImage(), rectangle.x, rectangle.y);
                }
            }
        };
        this.mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (ControlDecoration.this.showHover && !ControlDecoration.this.decorationRectangle.contains(mouseEvent.x, mouseEvent.y)) {
                    ControlDecoration.this.hideHover();
                    ControlDecoration.this.printRemoveListener(mouseEvent.widget, "MOUSEMOVE");
                    ((Control)mouseEvent.widget).removeMouseMoveListener(ControlDecoration.this.mouseMoveListener);
                    ControlDecoration.this.moveListeningTarget = null;
                }
            }
        };
        this.mouseTrackListener = new MouseTrackListener(){

            public void mouseExit(MouseEvent mouseEvent) {
                Control control = (Control)mouseEvent.widget;
                if (control == ControlDecoration.this.moveListeningTarget) {
                    ControlDecoration.this.printRemoveListener((Widget)control, "MOUSEMOVE");
                    control.removeMouseMoveListener(ControlDecoration.this.mouseMoveListener);
                    ControlDecoration.this.moveListeningTarget = null;
                }
                ControlDecoration.this.hideHover();
            }

            public void mouseHover(MouseEvent mouseEvent) {
                if (ControlDecoration.this.showHover) {
                    ControlDecoration.this.decorationRectangle = ControlDecoration.this.getDecorationRectangle((Control)mouseEvent.widget);
                    if (ControlDecoration.this.decorationRectangle.contains(mouseEvent.x, mouseEvent.y)) {
                        ControlDecoration.this.showHoverText(ControlDecoration.this.getDescriptionText());
                        Control control = (Control)mouseEvent.widget;
                        if (ControlDecoration.this.moveListeningTarget == null) {
                            ControlDecoration.this.printAddListener((Widget)control, "MOUSEMOVE");
                            control.addMouseMoveListener(ControlDecoration.this.mouseMoveListener);
                            ControlDecoration.this.moveListeningTarget = control;
                        } else if (control != ControlDecoration.this.moveListeningTarget) {
                            ControlDecoration.this.printRemoveListener((Widget)ControlDecoration.this.moveListeningTarget, "MOUSEMOVE");
                            ControlDecoration.this.moveListeningTarget.removeMouseMoveListener(ControlDecoration.this.mouseMoveListener);
                            ControlDecoration.this.printAddListener((Widget)control, "MOUSEMOVE");
                            control.addMouseMoveListener(ControlDecoration.this.mouseMoveListener);
                            ControlDecoration.this.moveListeningTarget = control;
                        }
                    }
                }
            }

            public void mouseEnter(MouseEvent mouseEvent) {
            }
        };
        this.compositeListener = new Listener(){

            public void handleEvent(Event event) {
                if (!ControlDecoration.this.visible) {
                    return;
                }
                switch (event.type) {
                    case 3: {
                        if (ControlDecoration.this.selectionListeners.isEmpty()) break;
                        ControlDecoration.this.notifySelectionListeners(event);
                        break;
                    }
                    case 8: {
                        if (ControlDecoration.this.selectionListeners.isEmpty()) break;
                        ControlDecoration.this.notifySelectionListeners(event);
                        break;
                    }
                    case 35: {
                        if (ControlDecoration.this.menuDetectListeners.isEmpty()) break;
                        ControlDecoration.this.notifyMenuDetectListeners(event);
                    }
                }
            }
        };
        Object object = this.control.getParent();
        while (object != null) {
            this.installCompositeListeners((Composite)object);
            object = this.composite != null && this.composite == object ? null : (object instanceof Shell ? null : object.getParent());
        }
        this.update();
    }

    private void installCompositeListeners(Composite composite) {
        if (!composite.isDisposed()) {
            this.printAddListener((Widget)composite, "PAINT");
            composite.addPaintListener(this.paintListener);
            this.printAddListener((Widget)composite, "MOUSETRACK");
            composite.addMouseTrackListener(this.mouseTrackListener);
            this.printAddListener((Widget)composite, "SWT.MenuDetect");
            composite.addListener(35, this.compositeListener);
            this.printAddListener((Widget)composite, "SWT.MouseDown");
            composite.addListener(3, this.compositeListener);
            this.printAddListener((Widget)composite, "SWT.MouseDoubleClick");
            composite.addListener(8, this.compositeListener);
        }
    }

    private void removeCompositeListeners(Composite composite) {
        if (!composite.isDisposed()) {
            this.printRemoveListener((Widget)composite, "PAINT");
            composite.removePaintListener(this.paintListener);
            this.printRemoveListener((Widget)composite, "MOUSETRACK");
            composite.removeMouseTrackListener(this.mouseTrackListener);
            this.printRemoveListener((Widget)composite, "SWT.MenuDetect");
            composite.removeListener(35, this.compositeListener);
            this.printRemoveListener((Widget)composite, "SWT.MouseDown");
            composite.removeListener(3, this.compositeListener);
            this.printRemoveListener((Widget)composite, "SWT.MouseDoubleClick");
            composite.removeListener(8, this.compositeListener);
        }
    }

    private void notifySelectionListeners(Event event) {
        if (!(event.widget instanceof Control)) {
            return;
        }
        if (this.getDecorationRectangle((Control)event.widget).contains(event.x, event.y)) {
            SelectionEvent selectionEvent = new SelectionEvent(event);
            selectionEvent.data = this;
            if (this.getImage() != null) {
                selectionEvent.height = this.getImage().getBounds().height;
                selectionEvent.width = this.getImage().getBounds().width;
            }
            switch (event.type) {
                case 8: {
                    if (event.button != 1) break;
                    Object[] objectArray = this.selectionListeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        ((SelectionListener)objectArray[n]).widgetDefaultSelected(selectionEvent);
                        ++n;
                    }
                    break;
                }
                case 3: {
                    if (event.button != 1) break;
                    Object[] objectArray = this.selectionListeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        ((SelectionListener)objectArray[n]).widgetSelected(selectionEvent);
                        ++n;
                    }
                    break;
                }
            }
        }
    }

    private void notifyMenuDetectListeners(Event event) {
        if (this.getDecorationRectangle(null).contains(event.x, event.y)) {
            MenuDetectEvent menuDetectEvent = new MenuDetectEvent(event);
            menuDetectEvent.data = this;
            Object[] objectArray = this.menuDetectListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((MenuDetectListener)objectArray[n]).menuDetected(menuDetectEvent);
                ++n;
            }
        }
    }

    public void showHoverText(String string) {
        if (this.control == null) {
            return;
        }
        this.showHoverText(string, this.control);
    }

    public void hideHover() {
        if (this.hover != null) {
            this.hover.setVisible(false);
        }
    }

    public void show() {
        if (!this.visible) {
            this.visible = true;
            this.update();
        }
    }

    public void hide() {
        if (this.visible) {
            this.visible = false;
            this.hideHover();
            this.update();
        }
    }

    public String getDescriptionText() {
        return this.descriptionText;
    }

    public void setDescriptionText(String string) {
        this.descriptionText = string;
        this.update();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.previousDecorationRectangle = this.getDecorationRectangle((Control)this.control.getShell());
        this.image = image;
        this.update();
    }

    public boolean getShowOnlyOnFocus() {
        return this.showOnlyOnFocus;
    }

    public void setShowOnlyOnFocus(boolean bl) {
        this.showOnlyOnFocus = bl;
        this.update();
    }

    public boolean getShowHover() {
        return this.showHover;
    }

    public void setShowHover(boolean bl) {
        this.showHover = bl;
        this.update();
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginWidth(int n) {
        this.previousDecorationRectangle = this.getDecorationRectangle((Control)this.control.getShell());
        this.marginWidth = n;
        this.update();
    }

    protected void update() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        Rectangle rectangle = this.getDecorationRectangle((Control)this.control.getShell());
        if (this.previousDecorationRectangle != null) {
            rectangle = rectangle.union(this.previousDecorationRectangle);
        }
        this.control.getShell().redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        this.control.getShell().update();
        if (this.hover != null && this.getDescriptionText() != null) {
            this.hover.setText(this.getDescriptionText(), this.getDecorationRectangle((Control)this.control.getParent()), this.control);
        }
        this.previousDecorationRectangle = null;
    }

    private void showHoverText(String string, Control control) {
        if (this.control.isDisposed() || !this.control.isVisible()) {
            return;
        }
        if (!this.showHover) {
            return;
        }
        if (!this.visible) {
            return;
        }
        if (string == null || string.length() == 0) {
            this.hideHover();
            return;
        }
        if (this.hover == null) {
            this.hover = new Hover(control.getShell());
        }
        this.hover.setText(string, this.getDecorationRectangle((Control)this.control.getParent()), this.control);
        this.hover.setVisible(true);
    }

    private void removeControlListeners() {
        if (this.control == null) {
            return;
        }
        this.printRemoveListener((Widget)this.control, "FOCUS");
        this.control.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.printRemoveListener((Widget)this.control, "DISPOSE");
        this.control.removeDisposeListener(this.disposeListener);
        this.disposeListener = null;
        Object object = this.control.getParent();
        while (object != null) {
            this.removeCompositeListeners((Composite)object);
            object = this.composite != null && this.composite == object ? null : (object instanceof Shell ? null : object.getParent());
        }
        this.paintListener = null;
        this.mouseTrackListener = null;
        this.compositeListener = null;
        if (this.moveListeningTarget != null) {
            this.printRemoveListener((Widget)this.moveListeningTarget, "MOUSEMOVE");
            this.moveListeningTarget.removeMouseMoveListener(this.mouseMoveListener);
            this.moveListeningTarget = null;
            this.mouseMoveListener = null;
        }
        if (DEBUG) {
            if (this.listenerInstalls > 0) {
                System.out.println("LISTENER LEAK>>>CHECK TRACE ABOVE");
            } else if (this.listenerInstalls < 0) {
                System.out.println("REMOVED UNREGISTERED LISTENERS>>>CHECK TRACE ABOVE");
            } else {
                System.out.println("ALL INSTALLED LISTENERS WERE REMOVED.");
            }
        }
    }

    protected Rectangle getDecorationRectangle(Control control) {
        if (this.getImage() == null || this.control == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.getImage().getBounds();
        Rectangle rectangle2 = this.control.getBounds();
        int n = (this.position & 0x20000) == 131072 ? rectangle2.x + rectangle2.width + this.marginWidth : rectangle2.x - rectangle.width - this.marginWidth;
        int n2 = (this.position & 0x80) == 128 ? rectangle2.y : ((this.position & 0x400) == 1024 ? rectangle2.y + this.control.getBounds().height - rectangle.height : rectangle2.y + (this.control.getBounds().height - rectangle.height) / 2);
        Point point = this.control.getParent().toDisplay(n, n2);
        Point point2 = control == null ? point : control.toControl(point);
        return new Rectangle(point2.x, point2.y, rectangle.width, rectangle.height);
    }

    private boolean shouldShowDecoration() {
        if (!this.visible) {
            return false;
        }
        if (this.control == null || this.control.isDisposed() || this.getImage() == null) {
            return false;
        }
        if (!this.control.isVisible()) {
            return false;
        }
        if (this.showOnlyOnFocus) {
            return this.hasFocus;
        }
        return true;
    }

    private void printAddListener(Widget widget, String string) {
        ++this.listenerInstalls;
        if (DEBUG) {
            System.out.println("Added listener>>>" + string + " to>>>" + widget);
        }
    }

    private void printRemoveListener(Widget widget, String string) {
        --this.listenerInstalls;
        if (DEBUG) {
            System.out.println("Removed listener>>>" + string + " from>>>" + widget);
        }
    }

    public boolean isVisible() {
        return this.shouldShowDecoration();
    }

    class Hover {
        private static final String EMPTY = "";
        private int hao = 10;
        private int haw = 8;
        private int hah = 10;
        private int hm = 2;
        Shell hoverShell;
        String text = "";
        Region region;
        boolean arrowOnLeft = true;

        Hover(Shell shell) {
            Display display = shell.getDisplay();
            this.hoverShell = new Shell(shell, 540684);
            this.hoverShell.setBackground(display.getSystemColor(29));
            this.hoverShell.setForeground(display.getSystemColor(28));
            this.hoverShell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    paintEvent.gc.drawText(Hover.this.text, Hover.this.hm, Hover.this.hm);
                    if (!MAC) {
                        paintEvent.gc.drawPolygon(Hover.this.getPolygon(true));
                    }
                }
            });
            this.hoverShell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    ControlDecoration.this.hideHover();
                }
            });
        }

        int[] getPolygon(boolean bl) {
            int n;
            Point point = this.getExtent();
            int n2 = n = bl ? 1 : 0;
            if (this.arrowOnLeft) {
                int[] nArray = new int[16];
                nArray[2] = point.x - n;
                nArray[4] = point.x - n;
                nArray[5] = point.y - n;
                nArray[6] = this.hao + this.haw;
                nArray[7] = point.y - n;
                nArray[8] = this.hao + this.haw / 2;
                nArray[9] = point.y + this.hah - n;
                nArray[10] = this.hao;
                nArray[11] = point.y - n;
                nArray[13] = point.y - n;
                return nArray;
            }
            int[] nArray = new int[16];
            nArray[2] = point.x - n;
            nArray[4] = point.x - n;
            nArray[5] = point.y - n;
            nArray[6] = point.x - this.hao - n;
            nArray[7] = point.y - n;
            nArray[8] = point.x - this.hao - this.haw / 2;
            nArray[9] = point.y + this.hah - n;
            nArray[10] = point.x - this.hao - this.haw;
            nArray[11] = point.y - n;
            nArray[13] = point.y - n;
            return nArray;
        }

        void dispose() {
            if (!this.hoverShell.isDisposed()) {
                this.hoverShell.dispose();
            }
            if (this.region != null) {
                this.region.dispose();
            }
        }

        void setVisible(boolean bl) {
            if (bl) {
                if (!this.hoverShell.isVisible()) {
                    this.hoverShell.setVisible(true);
                }
            } else if (this.hoverShell.isVisible()) {
                this.hoverShell.setVisible(false);
            }
        }

        void setText(String string, Rectangle rectangle, Control control) {
            Point point;
            if (string == null) {
                string = EMPTY;
            }
            if (!string.equals(this.text)) {
                point = this.getExtent();
                this.text = string;
                this.hoverShell.redraw();
                Point point2 = this.getExtent();
                if (!point.equals((Object)point2)) {
                    this.arrowOnLeft = rectangle.x <= control.getLocation().x;
                    this.setNewShape();
                }
            }
            point = this.getExtent();
            int n = -point.y - this.hah + 1;
            int n2 = this.arrowOnLeft ? -this.hao + this.haw / 2 : -point.x + this.hao + this.haw / 2;
            this.hoverShell.setLocation(ControlDecoration.this.control.getParent().toDisplay(rectangle.x + n2, rectangle.y + n));
        }

        boolean isVisible() {
            return this.hoverShell.isVisible();
        }

        Point getExtent() {
            GC gC = new GC((Drawable)this.hoverShell);
            Point point = gC.textExtent(this.text);
            gC.dispose();
            point.x += this.hm * 2;
            point.y += this.hm * 2;
            return point;
        }

        void setNewShape() {
            Region region = this.region;
            this.region = new Region();
            this.region.add(this.getPolygon(false));
            this.hoverShell.setRegion(this.region);
            if (region != null) {
                region.dispose();
            }
        }
    }
}

