/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ContentProposalAdapter {
    public static final boolean DEBUG = false;
    public static final int PROPOSAL_INSERT = 1;
    public static final int PROPOSAL_REPLACE = 2;
    public static final int PROPOSAL_IGNORE = 3;
    public static final int FILTER_NONE = 1;
    public static final int FILTER_CHARACTER = 2;
    public static final int FILTER_CUMULATIVE = 3;
    private static final boolean USE_VIRTUAL = !Util.isMotif();
    private static final int POPUP_DELAY = 750;
    private static final int POPUP_CHAR_HEIGHT = 10;
    private static final int POPUP_MINIMUM_WIDTH = 300;
    private static final int POPUP_OFFSET = 3;
    private static final String EMPTY = "";
    private IContentProposalProvider proposalProvider;
    private ILabelProvider labelProvider;
    private Control control;
    private IControlContentAdapter controlContentAdapter;
    private ContentProposalPopup popup;
    private KeyStroke triggerKeyStroke;
    private String autoActivateString;
    private int proposalAcceptanceStyle = 1;
    private boolean propagateKeys = true;
    private int filterStyle = 1;
    private Listener controlListener;
    private ListenerList proposalListeners = new ListenerList();
    private ListenerList proposalListeners2 = new ListenerList();
    private boolean isEnabled = true;
    private int autoActivationDelay = 0;
    private boolean receivedKeyDown;
    private Point popupSize;
    private int insertionPos = -1;
    private Point selectionRange = new Point(-1, -1);
    private boolean watchModify = false;

    public ContentProposalAdapter(Control control, IControlContentAdapter iControlContentAdapter, IContentProposalProvider iContentProposalProvider, KeyStroke keyStroke, char[] cArray) {
        Assert.isNotNull((Object)control);
        Assert.isNotNull((Object)iControlContentAdapter);
        this.control = control;
        this.controlContentAdapter = iControlContentAdapter;
        this.proposalProvider = iContentProposalProvider;
        this.triggerKeyStroke = keyStroke;
        if (cArray != null) {
            this.autoActivateString = new String(cArray);
        }
        this.addControlListener(control);
    }

    public Control getControl() {
        return this.control;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setLabelProvider(ILabelProvider iLabelProvider) {
        this.labelProvider = iLabelProvider;
    }

    public IContentProposalProvider getContentProposalProvider() {
        return this.proposalProvider;
    }

    public void setContentProposalProvider(IContentProposalProvider iContentProposalProvider) {
        this.proposalProvider = iContentProposalProvider;
    }

    public char[] getAutoActivationCharacters() {
        if (this.autoActivateString == null) {
            return null;
        }
        return this.autoActivateString.toCharArray();
    }

    public void setAutoActivationCharacters(char[] cArray) {
        this.autoActivateString = cArray == null ? null : new String(cArray);
    }

    public int getAutoActivationDelay() {
        return this.autoActivationDelay;
    }

    public void setAutoActivationDelay(int n) {
        this.autoActivationDelay = n;
    }

    public int getProposalAcceptanceStyle() {
        return this.proposalAcceptanceStyle;
    }

    public void setProposalAcceptanceStyle(int n) {
        this.proposalAcceptanceStyle = n;
    }

    public int getFilterStyle() {
        return this.filterStyle;
    }

    public void setFilterStyle(int n) {
        this.filterStyle = n;
    }

    public Point getPopupSize() {
        return this.popupSize;
    }

    public void setPopupSize(Point point) {
        this.popupSize = point;
    }

    public boolean getPropagateKeys() {
        return this.propagateKeys;
    }

    public void setPropagateKeys(boolean bl) {
        this.propagateKeys = bl;
    }

    public IControlContentAdapter getControlContentAdapter() {
        return this.controlContentAdapter;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled && !bl && this.popup != null) {
            this.popup.close();
        }
        this.isEnabled = bl;
    }

    public void addContentProposalListener(IContentProposalListener iContentProposalListener) {
        this.proposalListeners.add((Object)iContentProposalListener);
    }

    public void removeContentProposalListener(IContentProposalListener iContentProposalListener) {
        this.proposalListeners.remove((Object)iContentProposalListener);
    }

    public void addContentProposalListener(IContentProposalListener2 iContentProposalListener2) {
        this.proposalListeners2.add((Object)iContentProposalListener2);
    }

    public void removeContentProposalListener(IContentProposalListener2 iContentProposalListener2) {
        this.proposalListeners2.remove((Object)iContentProposalListener2);
    }

    private void addControlListener(Control control) {
        if (this.controlListener != null) {
            return;
        }
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!ContentProposalAdapter.this.isEnabled) {
                    return;
                }
                switch (event.type) {
                    case 1: 
                    case 31: {
                        if (ContentProposalAdapter.this.popup != null) {
                            ContentProposalAdapter.this.popup.getTargetControlListener().handleEvent(event);
                            if (ContentProposalAdapter.this.propagateKeys && event.character != '\u0000') {
                                ContentProposalAdapter.this.watchModify = true;
                            }
                            return;
                        }
                        if (event.type == 31) {
                            return;
                        }
                        if (ContentProposalAdapter.this.triggerKeyStroke != null && (ContentProposalAdapter.this.triggerKeyStroke.getModifierKeys() == 0 && ContentProposalAdapter.this.triggerKeyStroke.getNaturalKey() == event.character || ContentProposalAdapter.this.triggerKeyStroke.getNaturalKey() == event.keyCode && (ContentProposalAdapter.this.triggerKeyStroke.getModifierKeys() & event.stateMask) == ContentProposalAdapter.this.triggerKeyStroke.getModifierKeys())) {
                            event.doit = false;
                            ContentProposalAdapter.this.openProposalPopup(false);
                            return;
                        }
                        if (event.character != '\u0000') {
                            if (ContentProposalAdapter.this.autoActivateString != null) {
                                if (ContentProposalAdapter.this.autoActivateString.indexOf(event.character) >= 0) {
                                    ContentProposalAdapter.this.autoActivate();
                                    break;
                                }
                                ContentProposalAdapter.this.receivedKeyDown = true;
                                ContentProposalAdapter.this.watchModify = true;
                                break;
                            }
                            if (ContentProposalAdapter.this.triggerKeyStroke != null) break;
                            ContentProposalAdapter.this.watchModify = true;
                            break;
                        }
                        ContentProposalAdapter.this.receivedKeyDown = true;
                        break;
                    }
                    case 24: {
                        if (!ContentProposalAdapter.this.allowsAutoActivate() || !ContentProposalAdapter.this.watchModify) break;
                        ContentProposalAdapter.this.watchModify = false;
                        if (ContentProposalAdapter.this.isControlContentEmpty()) {
                            ContentProposalAdapter.this.closeProposalPopup();
                            break;
                        }
                        if (ContentProposalAdapter.this.autoActivateString == null) {
                            ContentProposalAdapter.this.autoActivate();
                            break;
                        }
                        if (ContentProposalAdapter.this.shouldPopupRemainOpen()) break;
                        ContentProposalAdapter.this.closeProposalPopup();
                        break;
                    }
                }
            }

            private void dump(String string, Event event) {
                StringBuffer stringBuffer = new StringBuffer("--- [ContentProposalAdapter]\n");
                stringBuffer.append(string);
                stringBuffer.append(" - e: keyCode=" + event.keyCode + this.hex(event.keyCode));
                stringBuffer.append("; character=" + event.character + this.hex(event.character));
                stringBuffer.append("; stateMask=" + event.stateMask + this.hex(event.stateMask));
                stringBuffer.append("; doit=" + event.doit);
                stringBuffer.append("; detail=" + event.detail + this.hex(event.detail));
                stringBuffer.append("; widget=" + event.widget);
                System.out.println(stringBuffer);
            }

            private String hex(int n) {
                return "[0x" + Integer.toHexString(n) + ']';
            }
        };
        control.addListener(1, this.controlListener);
        control.addListener(31, this.controlListener);
        control.addListener(24, this.controlListener);
    }

    private void openProposalPopup(boolean bl) {
        if (this.isValid() && this.popup == null) {
            this.recordCursorPosition();
            IContentProposal[] iContentProposalArray = this.getProposals();
            if (iContentProposalArray.length > 0) {
                this.recordCursorPosition();
                this.popup = new ContentProposalPopup(null, iContentProposalArray);
                this.popup.open();
                this.popup.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        ContentProposalAdapter.this.popup = null;
                    }
                });
                this.internalPopupOpened();
                this.notifyPopupOpened();
            } else if (!bl) {
                this.getControl().getDisplay().beep();
            }
        }
    }

    protected void openProposalPopup() {
        this.openProposalPopup(false);
    }

    protected void closeProposalPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
    }

    private void proposalAccepted(IContentProposal iContentProposal) {
        switch (this.proposalAcceptanceStyle) {
            case 2: {
                this.setControlContent(iContentProposal.getContent(), iContentProposal.getCursorPosition());
                break;
            }
            case 1: {
                this.insertControlContent(iContentProposal.getContent(), iContentProposal.getCursorPosition());
                break;
            }
        }
        this.notifyProposalAccepted(iContentProposal);
    }

    private void setControlContent(String string, int n) {
        if (this.isValid()) {
            this.watchModify = false;
            this.controlContentAdapter.setControlContents(this.control, string, n);
        }
    }

    private void insertControlContent(String string, int n) {
        if (this.isValid()) {
            this.watchModify = false;
            if (this.controlContentAdapter instanceof IControlContentAdapter2 && this.selectionRange.x != -1) {
                ((IControlContentAdapter2)((Object)this.controlContentAdapter)).setSelection(this.control, this.selectionRange);
            } else if (this.insertionPos != -1) {
                this.controlContentAdapter.setCursorPosition(this.control, this.insertionPos);
            }
            this.controlContentAdapter.insertControlContents(this.control, string, n);
        }
    }

    private boolean isValid() {
        return this.control != null && !this.control.isDisposed() && this.controlContentAdapter != null;
    }

    private void recordCursorPosition() {
        if (this.isValid()) {
            IControlContentAdapter iControlContentAdapter = this.getControlContentAdapter();
            this.insertionPos = iControlContentAdapter.getCursorPosition(this.control);
            if (iControlContentAdapter instanceof IControlContentAdapter2) {
                this.selectionRange = ((IControlContentAdapter2)((Object)iControlContentAdapter)).getSelection(this.control);
            }
        }
    }

    private IContentProposal[] getProposals() {
        if (this.proposalProvider == null || !this.isValid()) {
            return null;
        }
        int n = this.insertionPos;
        if (n == -1) {
            n = this.getControlContentAdapter().getCursorPosition(this.getControl());
        }
        String string = this.getControlContentAdapter().getControlContents(this.getControl());
        IContentProposal[] iContentProposalArray = this.proposalProvider.getProposals(string, n);
        return iContentProposalArray;
    }

    private void autoActivate() {
        if (this.autoActivationDelay > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ContentProposalAdapter.this.receivedKeyDown = false;
                    try {
                        Thread.sleep(ContentProposalAdapter.this.autoActivationDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!ContentProposalAdapter.this.isValid() || ContentProposalAdapter.this.receivedKeyDown) {
                        return;
                    }
                    ContentProposalAdapter.this.getControl().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ContentProposalAdapter.this.openProposalPopup(true);
                        }
                    });
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        } else {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ContentProposalAdapter.this.isValid()) {
                        ContentProposalAdapter.this.openProposalPopup(true);
                    }
                }
            });
        }
    }

    private void notifyProposalAccepted(IContentProposal iContentProposal) {
        Object[] objectArray = this.proposalListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IContentProposalListener)objectArray[n]).proposalAccepted(iContentProposal);
            ++n;
        }
    }

    private void notifyPopupOpened() {
        Object[] objectArray = this.proposalListeners2.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IContentProposalListener2)objectArray[n]).proposalPopupOpened(this);
            ++n;
        }
    }

    private void notifyPopupClosed() {
        Object[] objectArray = this.proposalListeners2.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IContentProposalListener2)objectArray[n]).proposalPopupClosed(this);
            ++n;
        }
    }

    public boolean hasProposalPopupFocus() {
        return this.popup != null && this.popup.hasFocus();
    }

    private boolean isControlContentEmpty() {
        return this.getControlContentAdapter().getControlContents(this.getControl()).length() == 0;
    }

    private void internalPopupOpened() {
        if (this.control instanceof Combo) {
            ((Combo)this.control).setListVisible(false);
        }
    }

    private boolean shouldPopupRemainOpen() {
        if (this.autoActivateString == null || this.autoActivateString.length() == 0) {
            return true;
        }
        String string = this.getControlContentAdapter().getControlContents(this.getControl());
        int n = 0;
        while (n < this.autoActivateString.length()) {
            if (string.indexOf(this.autoActivateString.charAt(n)) >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean allowsAutoActivate() {
        return this.autoActivateString != null && this.autoActivateString.length() > 0 || this.autoActivateString == null && this.triggerKeyStroke == null;
    }

    public void setProposalPopupFocus() {
        if (this.isValid() && this.popup != null) {
            this.popup.getShell().setFocus();
        }
    }

    public boolean isProposalPopupOpen() {
        return this.isValid() && this.popup != null;
    }

    class ContentProposalPopup
    extends PopupDialog {
        private Listener targetControlListener;
        private PopupCloserListener popupCloser;
        private Table proposalTable;
        private IContentProposal[] proposals;
        private InfoPopupDialog infoPopup;
        private boolean pendingDescriptionUpdate;
        private String filterText;

        ContentProposalPopup(String string, IContentProposal[] iContentProposalArray) {
            super(ContentProposalAdapter.this.control.getShell(), 16400, false, false, false, false, false, null, string);
            this.pendingDescriptionUpdate = false;
            this.filterText = ContentProposalAdapter.EMPTY;
            this.proposals = iContentProposalArray;
        }

        @Override
        protected Color getForeground() {
            return JFaceResources.getColorRegistry().get("CONTENT_ASSIST_FOREGROUND_COLOR");
        }

        @Override
        protected Color getBackground() {
            return JFaceResources.getColorRegistry().get("CONTENT_ASSIST_BACKGROUND_COLOR");
        }

        @Override
        protected final Control createDialogArea(Composite composite) {
            if (USE_VIRTUAL) {
                this.proposalTable = new Table(composite, 0x10000300);
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        ContentProposalPopup.this.handleSetData(event);
                    }
                };
                this.proposalTable.addListener(36, listener);
            } else {
                this.proposalTable = new Table(composite, 768);
            }
            this.setProposals(this.filterProposals(this.proposals, this.filterText));
            this.proposalTable.setHeaderVisible(false);
            this.proposalTable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.item == null) {
                        if (ContentProposalPopup.this.infoPopup != null) {
                            ContentProposalPopup.this.infoPopup.close();
                        }
                    } else {
                        ContentProposalPopup.this.showProposalDescription();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ContentProposalPopup.this.acceptCurrentProposal();
                }
            });
            return this.proposalTable;
        }

        @Override
        protected void adjustBounds() {
            Rectangle rectangle;
            Point point = ContentProposalAdapter.this.control.getDisplay().map((Control)ContentProposalAdapter.this.control.getParent(), null, ContentProposalAdapter.this.control.getLocation());
            int n = point.x + 3;
            int n2 = point.y + ((ContentProposalAdapter)ContentProposalAdapter.this).control.getSize().y + 3;
            if (ContentProposalAdapter.this.getProposalAcceptanceStyle() == 1) {
                rectangle = ContentProposalAdapter.this.controlContentAdapter.getInsertionBounds(ContentProposalAdapter.this.control);
                n += rectangle.x;
                n2 = point.y + rectangle.y + rectangle.height;
            }
            if (ContentProposalAdapter.this.popupSize == null) {
                rectangle = new GridData(1808);
                rectangle.heightHint = this.proposalTable.getItemHeight() * 10;
                rectangle.widthHint = Math.max(((ContentProposalAdapter)ContentProposalAdapter.this).control.getSize().x, 300);
                this.proposalTable.setLayoutData((Object)rectangle);
                this.getShell().pack();
                ContentProposalAdapter.this.popupSize = this.getShell().getSize();
            }
            rectangle = this.getConstrainedShellBounds(new Rectangle(n, n2, ((ContentProposalAdapter)ContentProposalAdapter.this).popupSize.x, ((ContentProposalAdapter)ContentProposalAdapter.this).popupSize.y));
            if (rectangle.y < n2) {
                this.getShell().setBounds(n, point.y - ((ContentProposalAdapter)ContentProposalAdapter.this).popupSize.y, ((ContentProposalAdapter)ContentProposalAdapter.this).popupSize.x, ((ContentProposalAdapter)ContentProposalAdapter.this).popupSize.y);
            } else {
                this.getShell().setBounds(n, n2, ((ContentProposalAdapter)ContentProposalAdapter.this).popupSize.x, ((ContentProposalAdapter)ContentProposalAdapter.this).popupSize.y);
            }
            this.getShell().addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    ContentProposalAdapter.this.popupSize = ContentProposalPopup.this.getShell().getSize();
                    if (ContentProposalPopup.this.infoPopup != null) {
                        ContentProposalPopup.this.infoPopup.adjustBounds();
                    }
                }
            });
        }

        private void handleSetData(Event event) {
            TableItem tableItem = (TableItem)event.item;
            int n = this.proposalTable.indexOf(tableItem);
            if (n >= 0 && n < this.proposals.length) {
                IContentProposal iContentProposal = this.proposals[n];
                tableItem.setText(this.getString(iContentProposal));
                tableItem.setImage(this.getImage(iContentProposal));
                tableItem.setData((Object)iContentProposal);
            }
        }

        private void setProposals(IContentProposal[] iContentProposalArray) {
            if (iContentProposalArray == null || iContentProposalArray.length == 0) {
                iContentProposalArray = this.getEmptyProposalArray();
            }
            this.proposals = iContentProposalArray;
            if (this.isValid()) {
                int n = iContentProposalArray.length;
                if (USE_VIRTUAL) {
                    this.proposalTable.setItemCount(n);
                    this.proposalTable.clearAll();
                } else {
                    this.proposalTable.setRedraw(false);
                    this.proposalTable.setItemCount(n);
                    TableItem[] tableItemArray = this.proposalTable.getItems();
                    int n2 = 0;
                    while (n2 < tableItemArray.length) {
                        TableItem tableItem = tableItemArray[n2];
                        IContentProposal iContentProposal = iContentProposalArray[n2];
                        tableItem.setText(this.getString(iContentProposal));
                        tableItem.setImage(this.getImage(iContentProposal));
                        tableItem.setData((Object)iContentProposal);
                        ++n2;
                    }
                    this.proposalTable.setRedraw(true);
                }
                if (iContentProposalArray.length > 0) {
                    this.selectProposal(0);
                } else if (this.infoPopup != null) {
                    this.infoPopup.close();
                }
            }
        }

        private String getString(IContentProposal iContentProposal) {
            if (iContentProposal == null) {
                return ContentProposalAdapter.EMPTY;
            }
            if (ContentProposalAdapter.this.labelProvider == null) {
                return iContentProposal.getLabel() == null ? iContentProposal.getContent() : iContentProposal.getLabel();
            }
            return ContentProposalAdapter.this.labelProvider.getText(iContentProposal);
        }

        private Image getImage(IContentProposal iContentProposal) {
            if (iContentProposal == null || ContentProposalAdapter.this.labelProvider == null) {
                return null;
            }
            return ContentProposalAdapter.this.labelProvider.getImage(iContentProposal);
        }

        private IContentProposal[] getEmptyProposalArray() {
            return new IContentProposal[0];
        }

        private boolean isValid() {
            return this.proposalTable != null && !this.proposalTable.isDisposed();
        }

        private boolean hasFocus() {
            if (!this.isValid()) {
                return false;
            }
            if (this.getShell().isFocusControl() || this.proposalTable.isFocusControl()) {
                return true;
            }
            return this.infoPopup != null && this.infoPopup.hasFocus();
        }

        private IContentProposal getSelectedProposal() {
            if (this.isValid()) {
                int n = this.proposalTable.getSelectionIndex();
                if (this.proposals == null || n < 0 || n >= this.proposals.length) {
                    return null;
                }
                return this.proposals[n];
            }
            return null;
        }

        private void selectProposal(int n) {
            Assert.isTrue((n >= 0 ? 1 : 0) != 0, (String)"Proposal index should never be negative");
            if (!this.isValid() || this.proposals == null || n >= this.proposals.length) {
                return;
            }
            this.proposalTable.setSelection(n);
            this.proposalTable.showSelection();
            this.showProposalDescription();
        }

        @Override
        public int open() {
            int n = super.open();
            if (this.popupCloser == null) {
                this.popupCloser = new PopupCloserListener();
            }
            this.popupCloser.installListeners();
            IContentProposal iContentProposal = this.getSelectedProposal();
            if (iContentProposal != null) {
                this.showProposalDescription();
            }
            return n;
        }

        @Override
        public boolean close() {
            this.popupCloser.removeListeners();
            if (this.infoPopup != null) {
                this.infoPopup.close();
            }
            boolean bl = super.close();
            ContentProposalAdapter.this.notifyPopupClosed();
            return bl;
        }

        private void showProposalDescription() {
            if (!this.pendingDescriptionUpdate) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ContentProposalPopup.this.pendingDescriptionUpdate = true;
                        try {
                            Thread.sleep(750L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (!ContentProposalPopup.this.isValid()) {
                            return;
                        }
                        ContentProposalPopup.this.getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IContentProposal iContentProposal = ContentProposalPopup.this.getSelectedProposal();
                                if (iContentProposal != null) {
                                    String string = iContentProposal.getDescription();
                                    if (string != null) {
                                        if (ContentProposalPopup.this.infoPopup == null) {
                                            ContentProposalPopup.this.infoPopup = new InfoPopupDialog(ContentProposalPopup.this.getShell());
                                            ContentProposalPopup.this.infoPopup.open();
                                            ContentProposalPopup.this.infoPopup.getShell().addDisposeListener(new DisposeListener(){

                                                public void widgetDisposed(DisposeEvent disposeEvent) {
                                                    ContentProposalPopup.this.infoPopup = null;
                                                }
                                            });
                                        }
                                        ContentProposalPopup.this.infoPopup.setContents(iContentProposal.getDescription());
                                    } else if (ContentProposalPopup.this.infoPopup != null) {
                                        ContentProposalPopup.this.infoPopup.close();
                                    }
                                    ContentProposalPopup.this.pendingDescriptionUpdate = false;
                                }
                            }
                        });
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }
        }

        private void acceptCurrentProposal() {
            IContentProposal iContentProposal = this.getSelectedProposal();
            this.close();
            ContentProposalAdapter.this.proposalAccepted(iContentProposal);
        }

        private void recomputeProposals(String string) {
            IContentProposal[] iContentProposalArray = ContentProposalAdapter.this.getProposals();
            if (iContentProposalArray == null) {
                iContentProposalArray = this.getEmptyProposalArray();
            }
            if (iContentProposalArray.length == 0) {
                this.proposals = iContentProposalArray;
                this.close();
            } else {
                this.setProposals(this.filterProposals(iContentProposalArray, string));
            }
        }

        private void asyncRecomputeProposals(final String string) {
            if (this.isValid()) {
                ContentProposalAdapter.this.control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ContentProposalAdapter.this.recordCursorPosition();
                        ContentProposalPopup.this.recomputeProposals(string);
                    }
                });
            } else {
                this.recomputeProposals(string);
            }
        }

        private IContentProposal[] filterProposals(IContentProposal[] iContentProposalArray, String string) {
            if (string.length() == 0) {
                return iContentProposalArray;
            }
            ArrayList<IContentProposal> arrayList = new ArrayList<IContentProposal>();
            int n = 0;
            while (n < iContentProposalArray.length) {
                String string2 = this.getString(iContentProposalArray[n]);
                if (string2.length() >= string.length() && string2.substring(0, string.length()).equalsIgnoreCase(string)) {
                    arrayList.add(iContentProposalArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new IContentProposal[arrayList.size()]);
        }

        Listener getTargetControlListener() {
            if (this.targetControlListener == null) {
                this.targetControlListener = new TargetControlListener();
            }
            return this.targetControlListener;
        }

        private class InfoPopupDialog
        extends PopupDialog {
            private Text text;
            private String contents;

            InfoPopupDialog(Shell shell) {
                super(shell, 540676, false, false, false, false, false, null, null);
                this.contents = ContentProposalAdapter.EMPTY;
            }

            @Override
            protected Control createDialogArea(Composite composite) {
                this.text = new Text(composite, 524362);
                GridData gridData = new GridData(1809);
                gridData.horizontalIndent = 1;
                gridData.verticalIndent = 1;
                this.text.setLayoutData((Object)gridData);
                this.text.setText(this.contents);
                this.text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        ContentProposalPopup.this.close();
                    }
                });
                return this.text;
            }

            @Override
            protected void adjustBounds() {
                Rectangle rectangle;
                Rectangle rectangle2 = this.getParentShell().getBounds();
                Rectangle rectangle3 = new Rectangle(rectangle2.x + rectangle2.width + 1, rectangle2.y + 1, rectangle2.width, rectangle2.height);
                if ((rectangle3 = this.getConstrainedShellBounds(rectangle3)).intersects(rectangle2)) {
                    Rectangle rectangle4 = new Rectangle(rectangle2.x - rectangle2.width - 1 - 1, rectangle2.y, rectangle2.width, rectangle2.height);
                    if ((rectangle4 = this.getConstrainedShellBounds(rectangle4)).intersects(rectangle2)) {
                        if (rectangle3.x - rectangle2.x >= rectangle2.x - rectangle4.x) {
                            rectangle3.x = rectangle2.x + rectangle2.width + 1;
                            rectangle = rectangle3;
                        } else {
                            rectangle4.width = rectangle2.x - 1 - rectangle4.x;
                            rectangle = rectangle4;
                        }
                    } else {
                        rectangle = rectangle4;
                    }
                } else {
                    rectangle = rectangle3;
                }
                this.getShell().setBounds(rectangle);
            }

            @Override
            protected Color getForeground() {
                return ContentProposalAdapter.this.control.getDisplay().getSystemColor(28);
            }

            @Override
            protected Color getBackground() {
                return ContentProposalAdapter.this.control.getDisplay().getSystemColor(29);
            }

            void setContents(String string) {
                if (string == null) {
                    string = ContentProposalAdapter.EMPTY;
                }
                this.contents = string;
                if (this.text != null && !this.text.isDisposed()) {
                    this.text.setText(this.contents);
                }
            }

            boolean hasFocus() {
                if (this.text == null || this.text.isDisposed()) {
                    return false;
                }
                return this.text.getShell().isFocusControl() || this.text.isFocusControl();
            }
        }

        private final class PopupCloserListener
        implements Listener {
            private boolean scrollbarClicked = false;

            private PopupCloserListener() {
            }

            public void handleEvent(final Event event) {
                if (event.type == 16) {
                    this.scrollbarClicked = false;
                    event.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ContentProposalPopup.this.isValid()) {
                                if (PopupCloserListener.this.scrollbarClicked || ContentProposalPopup.this.hasFocus()) {
                                    return;
                                }
                                Shell shell = event.display.getActiveShell();
                                if (shell == ContentProposalPopup.this.getShell() || ContentProposalPopup.this.infoPopup != null && ContentProposalPopup.this.infoPopup.getShell() == shell) {
                                    return;
                                }
                                ContentProposalPopup.this.close();
                            }
                        }
                    });
                    return;
                }
                if (event.type == 13) {
                    this.scrollbarClicked = true;
                    return;
                }
                ContentProposalPopup.this.close();
            }

            void installListeners() {
                ContentProposalPopup.this.proposalTable.addListener(16, (Listener)this);
                ScrollBar scrollBar = ContentProposalPopup.this.proposalTable.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.addListener(13, (Listener)this);
                }
                ContentProposalPopup.this.getShell().addListener(27, (Listener)this);
                ContentProposalPopup.this.getShell().addListener(21, (Listener)this);
                ContentProposalAdapter.this.control.addListener(8, (Listener)this);
                ContentProposalAdapter.this.control.addListener(3, (Listener)this);
                ContentProposalAdapter.this.control.addListener(12, (Listener)this);
                ContentProposalAdapter.this.control.addListener(16, (Listener)this);
                Shell shell = ContentProposalAdapter.this.control.getShell();
                shell.addListener(10, (Listener)this);
                shell.addListener(11, (Listener)this);
            }

            void removeListeners() {
                ScrollBar scrollBar;
                if (ContentProposalPopup.this.isValid()) {
                    ContentProposalPopup.this.proposalTable.removeListener(16, (Listener)this);
                    scrollBar = ContentProposalPopup.this.proposalTable.getVerticalBar();
                    if (scrollBar != null) {
                        scrollBar.removeListener(13, (Listener)this);
                    }
                    ContentProposalPopup.this.getShell().removeListener(27, (Listener)this);
                    ContentProposalPopup.this.getShell().removeListener(21, (Listener)this);
                }
                if (ContentProposalAdapter.this.control != null && !ContentProposalAdapter.this.control.isDisposed()) {
                    ContentProposalAdapter.this.control.removeListener(8, (Listener)this);
                    ContentProposalAdapter.this.control.removeListener(3, (Listener)this);
                    ContentProposalAdapter.this.control.removeListener(12, (Listener)this);
                    ContentProposalAdapter.this.control.removeListener(16, (Listener)this);
                    scrollBar = ContentProposalAdapter.this.control.getShell();
                    scrollBar.removeListener(10, (Listener)this);
                    scrollBar.removeListener(11, (Listener)this);
                }
            }
        }

        private final class TargetControlListener
        implements Listener {
            private TargetControlListener() {
            }

            public void handleEvent(Event event) {
                if (!ContentProposalPopup.this.isValid()) {
                    return;
                }
                char c = event.character;
                if (event.type == 31) {
                    if (c != '\u0000') {
                        event.doit = false;
                        return;
                    }
                    event.detail = 0;
                    event.doit = true;
                } else {
                    event.doit = ContentProposalAdapter.this.propagateKeys;
                }
                if (c == '\u0000') {
                    int n = ContentProposalPopup.this.proposalTable.getSelectionIndex();
                    int n2 = ((ContentProposalPopup)ContentProposalPopup.this).proposalTable.getSize().y / ContentProposalPopup.this.proposalTable.getItemHeight() - 1;
                    switch (event.keyCode) {
                        case 0x1000001: {
                            if (--n < 0) {
                                n = ContentProposalPopup.this.proposalTable.getItemCount() - 1;
                            }
                            if (event.type != 1) break;
                            event.doit = false;
                            break;
                        }
                        case 0x1000002: {
                            if (++n > ContentProposalPopup.this.proposalTable.getItemCount() - 1) {
                                n = 0;
                            }
                            if (event.type != 1) break;
                            event.doit = false;
                            break;
                        }
                        case 0x1000006: {
                            if ((n += n2) >= ContentProposalPopup.this.proposalTable.getItemCount()) {
                                n = ContentProposalPopup.this.proposalTable.getItemCount() - 1;
                            }
                            if (event.type != 1) break;
                            event.doit = false;
                            break;
                        }
                        case 0x1000005: {
                            if ((n -= n2) < 0) {
                                n = 0;
                            }
                            if (event.type != 1) break;
                            event.doit = false;
                            break;
                        }
                        case 0x1000007: {
                            n = 0;
                            if (event.type != 1) break;
                            event.doit = false;
                            break;
                        }
                        case 0x1000008: {
                            n = ContentProposalPopup.this.proposalTable.getItemCount() - 1;
                            if (event.type != 1) break;
                            event.doit = false;
                            break;
                        }
                        case 0x1000003: 
                        case 0x1000004: {
                            if (event.type == 31) {
                                event.doit = false;
                                break;
                            }
                            event.doit = true;
                            String string = ContentProposalAdapter.this.getControlContentAdapter().getControlContents(ContentProposalAdapter.this.getControl());
                            if (string.length() <= 0) break;
                            ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                            break;
                        }
                        default: {
                            if (event.keyCode != 16777298 && event.keyCode != 16777299 && event.keyCode != SWT.MOD1 && event.keyCode != SWT.MOD2 && event.keyCode != SWT.MOD3 && event.keyCode != SWT.MOD4) {
                                ContentProposalPopup.this.close();
                            }
                            return;
                        }
                    }
                    if (n >= 0) {
                        ContentProposalPopup.this.selectProposal(n);
                    }
                    return;
                }
                switch (c) {
                    case '\u001b': {
                        event.doit = false;
                        ContentProposalPopup.this.close();
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        event.doit = false;
                        IContentProposal iContentProposal = ContentProposalPopup.this.getSelectedProposal();
                        if (iContentProposal != null) {
                            ContentProposalPopup.this.acceptCurrentProposal();
                            break;
                        }
                        ContentProposalPopup.this.close();
                        break;
                    }
                    case '\t': {
                        event.doit = false;
                        ContentProposalPopup.this.getShell().setFocus();
                        return;
                    }
                    case '\b': {
                        if (ContentProposalAdapter.this.filterStyle != 1) {
                            if (ContentProposalPopup.this.filterText.length() == 0) {
                                return;
                            }
                            ContentProposalPopup.this.filterText = ContentProposalPopup.this.filterText.substring(0, ContentProposalPopup.this.filterText.length() - 1);
                            ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                            return;
                        }
                        int n = ContentProposalAdapter.this.getControlContentAdapter().getCursorPosition(ContentProposalAdapter.this.getControl());
                        if (n <= 0) break;
                        ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                        break;
                    }
                    default: {
                        if (!Character.isDefined(c)) break;
                        if (ContentProposalAdapter.this.filterStyle == 3) {
                            ContentProposalPopup contentProposalPopup = ContentProposalPopup.this;
                            contentProposalPopup.filterText = String.valueOf(contentProposalPopup.filterText) + String.valueOf(c);
                        } else if (ContentProposalAdapter.this.filterStyle == 2) {
                            ContentProposalPopup.this.filterText = String.valueOf(c);
                        }
                        ContentProposalPopup.this.asyncRecomputeProposals(ContentProposalPopup.this.filterText);
                    }
                }
            }
        }
    }
}

