/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.fieldassist;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class ComboContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    private static final boolean COMPUTE_TEXT_USING_CLIENTAREA = !Util.isCarbon();

    @Override
    public String getControlContents(Control control) {
        return ((Combo)control).getText();
    }

    @Override
    public void setControlContents(Control control, String string, int n) {
        ((Combo)control).setText(string);
        ((Combo)control).setSelection(new Point(n, n));
    }

    @Override
    public void insertControlContents(Control control, String string, int n) {
        Combo combo = (Combo)control;
        String string2 = combo.getText();
        Point point = combo.getSelection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.substring(0, point.x));
        stringBuffer.append(string);
        if (point.y < string2.length()) {
            stringBuffer.append(string2.substring(point.y, string2.length()));
        }
        combo.setText(stringBuffer.toString());
        point.x += n;
        point.y = point.x;
        combo.setSelection(point);
    }

    @Override
    public int getCursorPosition(Control control) {
        return ((Combo)control).getSelection().x;
    }

    @Override
    public Rectangle getInsertionBounds(Control control) {
        Combo combo = (Combo)control;
        int n = combo.getSelection().y;
        String string = combo.getText();
        GC gC = new GC((Drawable)combo);
        gC.setFont(combo.getFont());
        Point point = gC.textExtent(string.substring(0, Math.min(n, string.length())));
        gC.dispose();
        if (COMPUTE_TEXT_USING_CLIENTAREA) {
            return new Rectangle(combo.getClientArea().x + point.x, combo.getClientArea().y, 1, combo.getClientArea().height);
        }
        return new Rectangle(point.x, 0, 1, combo.getSize().y);
    }

    @Override
    public void setCursorPosition(Control control, int n) {
        ((Combo)control).setSelection(new Point(n, n));
    }

    @Override
    public Point getSelection(Control control) {
        return ((Combo)control).getSelection();
    }

    @Override
    public void setSelection(Control control, Point point) {
        ((Combo)control).setSelection(point);
    }
}

