/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class TrayDialog
extends Dialog {
    private static boolean dialogHelpAvailable;
    private DialogTray tray;
    private Control trayControl;
    private Control nonTrayFocusControl;
    private Label leftSeparator;
    private Label rightSeparator;
    private Sash sash;
    private boolean helpAvailable = TrayDialog.isDialogHelpAvailable();
    private int shellWidth;
    private ControlAdapter resizeListener;
    private ToolItem fHelpButton;

    protected TrayDialog(Shell shell) {
        super(shell);
    }

    protected TrayDialog(IShellProvider iShellProvider) {
        super(iShellProvider);
    }

    public void closeTray() throws IllegalStateException {
        if (this.getTray() == null) {
            throw new IllegalStateException("Tray was not open");
        }
        Shell shell = this.getShell();
        Control control = shell.getDisplay().getFocusControl();
        if (control != null && this.isContained(this.trayControl, control)) {
            if (this.nonTrayFocusControl != null && !this.nonTrayFocusControl.isDisposed()) {
                this.nonTrayFocusControl.setFocus();
            } else {
                shell.setFocus();
            }
        }
        this.nonTrayFocusControl = null;
        shell.removeControlListener((ControlListener)this.resizeListener);
        this.resizeListener = null;
        int n = this.trayControl.getSize().x + this.leftSeparator.getSize().x + this.sash.getSize().x + this.rightSeparator.getSize().x;
        this.trayControl.dispose();
        this.trayControl = null;
        this.tray = null;
        this.leftSeparator.dispose();
        this.leftSeparator = null;
        this.rightSeparator.dispose();
        this.rightSeparator = null;
        this.sash.dispose();
        this.sash = null;
        Rectangle rectangle = shell.getBounds();
        shell.setBounds(rectangle.x + (TrayDialog.getDefaultOrientation() == 0x4000000 ? n : 0), rectangle.y, rectangle.width - n, rectangle.height);
        if (this.fHelpButton != null) {
            this.fHelpButton.setSelection(false);
        }
    }

    private boolean isContained(Control control, Control control2) {
        Composite composite;
        while ((composite = control2.getParent()) != null) {
            if (composite == control) {
                return true;
            }
            control2 = composite;
        }
        return false;
    }

    @Override
    protected void handleShellCloseEvent() {
        if (this.getTray() != null) {
            this.closeTray();
        }
        super.handleShellCloseEvent();
    }

    @Override
    protected Control createButtonBar(Composite composite) {
        Control control;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite2.setFont(composite.getFont());
        if (this.isHelpAvailable()) {
            control = this.createHelpControl(composite2);
            ((GridData)control.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        }
        control = super.createButtonBar(composite2);
        ((GridData)control.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite2;
    }

    protected Control createHelpControl(Composite composite) {
        Image image = JFaceResources.getImage("dialog_help_image");
        if (image != null) {
            return this.createHelpImageButton(composite, image);
        }
        return this.createHelpLink(composite);
    }

    private ToolBar createHelpImageButton(Composite composite, Image image) {
        ToolBar toolBar = new ToolBar(composite, 0x880000);
        ++((GridLayout)composite.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)composite.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                cursor.dispose();
            }
        });
        this.fHelpButton = new ToolItem(toolBar, 8);
        this.fHelpButton.setImage(image);
        this.fHelpButton.setToolTipText(JFaceResources.getString("helpToolTip"));
        this.fHelpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrayDialog.this.helpPressed();
            }
        });
        return toolBar;
    }

    private Link createHelpLink(Composite composite) {
        Link link = new Link(composite, 524352);
        ++((GridLayout)composite.getLayout()).numColumns;
        link.setLayoutData((Object)new GridData(64));
        link.setText("<a>" + IDialogConstants.HELP_LABEL + "</a>");
        link.setToolTipText(IDialogConstants.HELP_LABEL);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrayDialog.this.helpPressed();
            }
        });
        return link;
    }

    private boolean isCompatibleLayout(Layout layout) {
        if (layout != null && layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            return !gridLayout.makeColumnsEqualWidth && gridLayout.horizontalSpacing == 0 && gridLayout.marginWidth == 0 && gridLayout.marginHeight == 0 && gridLayout.numColumns == 5;
        }
        return false;
    }

    public boolean isHelpAvailable() {
        return this.helpAvailable;
    }

    @Override
    protected Layout getLayout() {
        GridLayout gridLayout = (GridLayout)super.getLayout();
        gridLayout.numColumns = 5;
        gridLayout.horizontalSpacing = 0;
        return gridLayout;
    }

    public DialogTray getTray() {
        return this.tray;
    }

    protected void helpPressed() {
        if (this.getTray() == null || this.fHelpButton != null && this.fHelpButton.getSelection()) {
            if (this.getShell() != null) {
                Control control = this.getShell().getDisplay().getFocusControl();
                while (control != null) {
                    if (control.isListening(28)) {
                        control.notifyListeners(28, new Event());
                        break;
                    }
                    control = control.getParent();
                }
                if (this.fHelpButton != null && this.getTray() != null) {
                    this.fHelpButton.setSelection(true);
                }
            }
        } else {
            this.closeTray();
        }
    }

    public void openTray(DialogTray dialogTray) throws IllegalStateException, UnsupportedOperationException {
        if (dialogTray == null) {
            throw new NullPointerException("Tray was null");
        }
        if (this.getTray() != null) {
            throw new IllegalStateException("Tray was already open");
        }
        if (!this.isCompatibleLayout(this.getShell().getLayout())) {
            throw new UnsupportedOperationException("Trays not supported with custom layouts");
        }
        final Shell shell = this.getShell();
        Control control = shell.getDisplay().getFocusControl();
        if (control != null && this.isContained((Control)shell, control)) {
            this.nonTrayFocusControl = control;
        }
        this.leftSeparator = new Label((Composite)shell, 514);
        this.leftSeparator.setLayoutData((Object)new GridData(1040));
        this.sash = new Sash((Composite)shell, 512);
        this.sash.setLayoutData((Object)new GridData(1040));
        this.rightSeparator = new Label((Composite)shell, 514);
        this.rightSeparator.setLayoutData((Object)new GridData(1040));
        this.trayControl = dialogTray.createContents((Composite)shell);
        Rectangle rectangle = shell.getClientArea();
        final GridData gridData = new GridData(1040);
        gridData.widthHint = this.trayControl.computeSize((int)-1, (int)rectangle.height).x;
        this.trayControl.setLayoutData((Object)gridData);
        int n = this.leftSeparator.computeSize((int)-1, (int)rectangle.height).x + this.sash.computeSize((int)-1, (int)rectangle.height).x + this.rightSeparator.computeSize((int)-1, (int)rectangle.height).x + gridData.widthHint;
        Rectangle rectangle2 = shell.getBounds();
        shell.setBounds(rectangle2.x - (TrayDialog.getDefaultOrientation() == 0x4000000 ? n : 0), rectangle2.y, rectangle2.width + n, rectangle2.height);
        this.sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 1) {
                    Rectangle rectangle = shell.getClientArea();
                    int n = rectangle.width - event.x - (((TrayDialog)TrayDialog.this).sash.getSize().x + ((TrayDialog)TrayDialog.this).rightSeparator.getSize().x);
                    if (n != gridData.widthHint) {
                        gridData.widthHint = n;
                        shell.layout();
                    }
                }
            }
        });
        this.shellWidth = shell.getSize().x;
        this.resizeListener = new ResizeListener(gridData, shell);
        shell.addControlListener((ControlListener)this.resizeListener);
        this.tray = dialogTray;
    }

    public void setHelpAvailable(boolean bl) {
        this.helpAvailable = bl;
    }

    public static boolean isDialogHelpAvailable() {
        return dialogHelpAvailable;
    }

    public static void setDialogHelpAvailable(boolean bl) {
        dialogHelpAvailable = bl;
    }

    private final class ResizeListener
    extends ControlAdapter {
        private final GridData data;
        private final Shell shell;
        private final int TRAY_RATIO = 100;
        private int remainder = 0;

        private ResizeListener(GridData gridData, Shell shell) {
            this.data = gridData;
            this.shell = shell;
        }

        public void controlResized(ControlEvent controlEvent) {
            int n = this.shell.getSize().x;
            if (n != TrayDialog.this.shellWidth) {
                int n2 = n - TrayDialog.this.shellWidth;
                int n3 = n2 * 100 + this.remainder;
                int n4 = n3 / 100;
                this.remainder = n3 - 100 * n4;
                this.data.widthHint += n4;
                TrayDialog.this.shellWidth = n;
                if (!this.shell.isDisposed()) {
                    this.shell.layout();
                }
            }
        }
    }
}

