/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TitleAreaDialog
extends TrayDialog {
    public static final String DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    public static final String INFO_MESSAGE = "INFO_MESSAGE";
    public static final String WARNING_MESSAGE = "WARNING_MESSAGE";
    private static final int H_GAP_IMAGE = 5;
    private static final int MIN_DIALOG_WIDTH = 350;
    private static final int MIN_DIALOG_HEIGHT = 150;
    private Label titleLabel;
    private Label titleImageLabel;
    private Label bottomFillerLabel;
    private Label leftFillerLabel;
    private RGB titleAreaRGB;
    Color titleAreaColor;
    private String message = "";
    private String errorMessage;
    private StyledText messageLabel;
    private Composite workArea;
    private Label messageImageLabel;
    private Image messageImage;
    private boolean showingError = false;
    private boolean titleImageLargest = true;
    private int messageLabelHeight;
    private Image titleAreaImage;
    private int xTrim;
    private int yTrim;

    public TitleAreaDialog(Shell shell) {
        super(shell);
    }

    @Override
    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)composite2);
        FormLayout formLayout = new FormLayout();
        composite2.setLayout((Layout)formLayout);
        this.workArea = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.workArea.setLayout((Layout)gridLayout);
        Control control = this.createTitleArea(composite2);
        this.resetWorkAreaAttachments(control);
        this.workArea.setFont(JFaceResources.getDialogFont());
        this.initializeDialogUnits((Control)this.workArea);
        this.dialogArea = this.createDialogArea(this.workArea);
        this.buttonBar = this.createButtonBar(this.workArea);
        Rectangle rectangle = this.messageLabel.computeTrim(0, 0, 100, 100);
        this.xTrim = rectangle.width - 100;
        this.yTrim = rectangle.height - 100;
        this.getShell().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TitleAreaDialog.this.layoutForNewMessage(true);
            }
        });
        return composite2;
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(768));
        return composite2;
    }

    private Control createTitleArea(Composite composite) {
        Color color;
        Color color2;
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TitleAreaDialog.this.titleAreaColor != null) {
                    TitleAreaDialog.this.titleAreaColor.dispose();
                }
            }
        });
        Display display = composite.getDisplay();
        if (this.titleAreaRGB != null) {
            color2 = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            color = null;
        } else {
            color2 = JFaceColors.getBannerBackground(display);
            color = JFaceColors.getBannerForeground(display);
        }
        composite.setBackground(color2);
        int n = this.convertVerticalDLUsToPixels(4);
        int n2 = this.convertHorizontalDLUsToPixels(4);
        this.titleImageLabel = new Label(composite, 0x1000000);
        this.titleImageLabel.setBackground(color2);
        if (this.titleAreaImage == null) {
            this.titleImageLabel.setImage(JFaceResources.getImage(DLG_IMG_TITLE_BANNER));
        } else {
            this.titleImageLabel.setImage(this.titleAreaImage);
        }
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.titleImageLabel.setLayoutData((Object)formData);
        this.titleLabel = new Label(composite, 16384);
        JFaceColors.setColors((Control)this.titleLabel, color, color2);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0, n);
        formData2.right = new FormAttachment((Control)this.titleImageLabel);
        formData2.left = new FormAttachment(0, n2);
        this.titleLabel.setLayoutData((Object)formData2);
        this.messageImageLabel = new Label(composite, 0x1000000);
        this.messageImageLabel.setBackground(color2);
        this.messageLabel = new StyledText(composite, 72);
        JFaceColors.setColors((Control)this.messageLabel, color, color2);
        this.messageLabel.setText(" \n ");
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(composite, 0x1000000);
        this.leftFillerLabel.setBackground(color2);
        this.bottomFillerLabel = new Label(composite, 0x1000000);
        this.bottomFillerLabel.setBackground(color2);
        this.setLayoutsForNormalMessage(n, n2);
        this.determineTitleImageLargest();
        if (this.titleImageLargest) {
            return this.titleImageLabel;
        }
        return this.messageLabel;
    }

    private void determineTitleImageLargest() {
        int n = this.titleImageLabel.computeSize((int)-1, (int)-1).y;
        int n2 = this.convertVerticalDLUsToPixels(4);
        int n3 = this.titleLabel.computeSize((int)-1, (int)-1).y;
        n3 += n2;
        n3 += this.messageLabelHeight;
        this.titleImageLargest = n > (n3 += n2);
    }

    private void setLayoutsForNormalMessage(int n, int n2) {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.titleLabel, n);
        formData.left = new FormAttachment(0, 5);
        this.messageImageLabel.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.titleLabel, n);
        formData2.right = new FormAttachment((Control)this.titleImageLabel);
        formData2.left = new FormAttachment((Control)this.messageImageLabel, n2);
        formData2.height = this.messageLabelHeight;
        if (this.titleImageLargest) {
            formData2.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(0, n2);
        formData3.top = new FormAttachment((Control)this.messageImageLabel, 0);
        formData3.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.bottomFillerLabel.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
        formData4.left = new FormAttachment(0, 0);
        formData4.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
        formData4.right = new FormAttachment((Control)this.messageImageLabel, 0);
        this.leftFillerLabel.setLayoutData((Object)formData4);
    }

    @Override
    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(350), point.x), Math.max(this.convertVerticalDLUsToPixels(150), point.y));
    }

    protected Composite getTitleArea() {
        return this.getShell();
    }

    protected Label getTitleImageLabel() {
        return this.titleImageLabel;
    }

    public void setErrorMessage(String string) {
        if (this.errorMessage == null ? string == null : this.errorMessage.equals(string)) {
            return;
        }
        this.errorMessage = string;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
        } else {
            String string2 = " " + this.errorMessage;
            this.updateMessage(string2);
            if (!this.showingError) {
                this.showingError = true;
                this.messageImageLabel.setImage(JFaceResources.getImage(DLG_IMG_TITLE_ERROR));
                this.setImageLabelVisible(true);
            }
        }
        this.layoutForNewMessage(false);
    }

    private void layoutForNewMessage(boolean bl) {
        ToolTip toolTip;
        boolean bl2;
        int n = this.convertVerticalDLUsToPixels(4);
        int n2 = this.convertHorizontalDLUsToPixels(4);
        if (this.errorMessage == null && this.messageImage == null) {
            this.setImageLabelVisible(false);
            this.setLayoutsForNormalMessage(n, n2);
        } else {
            this.messageImageLabel.setVisible(true);
            this.bottomFillerLabel.setVisible(true);
            this.leftFillerLabel.setVisible(true);
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 5);
            formData.top = new FormAttachment((Control)this.titleLabel, n);
            this.messageImageLabel.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.messageImageLabel, 0);
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
            formData.right = new FormAttachment((Control)this.messageImageLabel, 0, 131072);
            this.bottomFillerLabel.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
            formData.right = new FormAttachment((Control)this.messageImageLabel, 0);
            this.leftFillerLabel.setLayoutData((Object)formData);
            FormData formData2 = new FormData();
            formData2.top = new FormAttachment((Control)this.titleLabel, n);
            formData2.right = new FormAttachment((Control)this.titleImageLabel);
            formData2.left = new FormAttachment((Control)this.messageImageLabel, 0);
            formData2.height = this.messageLabelHeight;
            if (this.titleImageLargest) {
                formData2.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
            }
            this.messageLabel.setLayoutData((Object)formData2);
        }
        if (bl) {
            this.getShell().layout();
        } else if (this.dialogArea != null) {
            this.workArea.getParent().layout(true);
        }
        int n3 = this.messageLabel.computeSize((int)(this.messageLabel.getSize().x - this.xTrim), (int)-1, (boolean)true).y;
        boolean bl3 = bl2 = n3 > this.messageLabel.getSize().y - this.yTrim;
        if (this.messageLabel.getData() instanceof ToolTip) {
            toolTip = (ToolTip)this.messageLabel.getData();
            toolTip.hide();
            toolTip.deactivate();
            this.messageLabel.setData(null);
        }
        if (bl2) {
            toolTip = new ToolTip((Control)this.messageLabel, 2, false){

                @Override
                protected Composite createToolTipContentArea(Event event, Composite composite) {
                    Composite composite2 = new Composite(composite, 0);
                    composite2.setBackground(composite.getDisplay().getSystemColor(29));
                    composite2.setLayout((Layout)new GridLayout());
                    Text text = new Text(composite2, 64);
                    text.setBackground(composite.getDisplay().getSystemColor(29));
                    text.setForeground(composite.getDisplay().getSystemColor(28));
                    text.setText(TitleAreaDialog.this.messageLabel.getText());
                    GridData gridData = new GridData();
                    gridData.widthHint = ((TitleAreaDialog)TitleAreaDialog.this).messageLabel.getSize().x;
                    text.setLayoutData((Object)gridData);
                    Dialog.applyDialogFont((Control)composite2);
                    return composite2;
                }

                @Override
                public Point getLocation(Point point, Event event) {
                    return TitleAreaDialog.this.messageLabel.getShell().toDisplay(TitleAreaDialog.this.messageLabel.getLocation());
                }
            };
            this.messageLabel.setData((Object)toolTip);
            toolTip.setPopupDelay(0);
            toolTip.activate();
        }
    }

    public void setMessage(String string) {
        this.setMessage(string, 0);
    }

    public void setMessage(String string, int n) {
        Image image = null;
        if (string != null) {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    image = JFaceResources.getImage("dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    image = JFaceResources.getImage("dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    image = JFaceResources.getImage(DLG_IMG_TITLE_ERROR);
                }
            }
        }
        this.showMessage(string, image);
    }

    private void showMessage(String string, Image image) {
        if (string == null) {
            string = "";
        }
        if (this.message.equals(string) && this.messageImage == image) {
            return;
        }
        this.message = string;
        String string2 = image == null ? this.message : " " + this.message;
        this.messageImage = image;
        if (!this.showingError) {
            this.updateMessage(string2);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            this.layoutForNewMessage(false);
        }
    }

    private void updateMessage(String string) {
        this.messageLabel.setText(string);
    }

    public void setTitle(String string) {
        if (this.titleLabel == null) {
            return;
        }
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        this.titleLabel.setText(string2);
    }

    public void setTitleAreaColor(RGB rGB) {
        this.titleAreaRGB = rGB;
    }

    public void setTitleImage(Image image) {
        this.titleAreaImage = image;
        if (this.titleImageLabel != null) {
            this.titleImageLabel.setImage(image);
            this.determineTitleImageLargest();
            Object object = this.titleImageLargest ? this.titleImageLabel : this.messageLabel;
            this.resetWorkAreaAttachments((Control)object);
        }
    }

    private void setImageLabelVisible(boolean bl) {
        this.messageImageLabel.setVisible(bl);
        this.bottomFillerLabel.setVisible(bl);
        this.leftFillerLabel.setVisible(bl);
    }

    private void resetWorkAreaAttachments(Control control) {
        FormData formData = new FormData();
        formData.top = new FormAttachment(control);
        formData.right = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.workArea.setLayoutData((Object)formData);
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void makeMessageBold(int n, int n2) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = n;
        styleRange.length = n2;
        styleRange.fontStyle = 1;
        this.messageLabel.setStyleRange(styleRange);
    }
}

