/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class StatusDialog
extends TrayDialog {
    private Button fOkButton;
    private MessageLine fStatusLine;
    private IStatus fLastStatus = new Status(0, "org.eclipse.jface", 0, "", null);
    private String fTitle;
    private Image fImage;
    private boolean fStatusLineAboveButtons = true;

    public StatusDialog(Shell shell) {
        super(shell);
    }

    public void setStatusLineAboveButtons(boolean bl) {
        this.fStatusLineAboveButtons = bl;
    }

    protected void updateStatus(IStatus iStatus) {
        this.fLastStatus = iStatus;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(iStatus);
            this.fStatusLine.setErrorStatus(iStatus);
        }
    }

    public IStatus getStatus() {
        return this.fLastStatus;
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        if (this.fOkButton != null && !this.fOkButton.isDisposed()) {
            this.fOkButton.setEnabled(!iStatus.matches(4));
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    @Override
    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            if (this.fLastStatus.matches(4)) {
                this.fLastStatus = new Status(4, this.fLastStatus.getPlugin(), this.fLastStatus.getCode(), "", this.fLastStatus.getException());
            }
            this.updateStatus(this.fLastStatus);
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.fOkButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.fStatusLineAboveButtons ? 1 : 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        if (!this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            this.createHelpControl(composite2);
        }
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        GridData gridData = new GridData(768);
        this.fStatusLine.setErrorStatus(null);
        if (this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            gridData.horizontalSpan = 2;
            this.createHelpControl(composite2);
        }
        this.fStatusLine.setLayoutData(gridData);
        StatusDialog.applyDialogFont((Control)composite2);
        boolean bl = this.isHelpAvailable();
        this.setHelpAvailable(false);
        super.createButtonBar(composite2);
        this.setHelpAvailable(bl);
        return composite2;
    }

    public void setTitle(String string) {
        this.fTitle = string != null ? string : "";
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(this.fTitle);
        }
    }

    public void setImage(Image image) {
        this.fImage = image;
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setImage(this.fImage);
        }
    }

    private class MessageLine
    extends CLabel {
        private Color fNormalMsgAreaBackground;

        public MessageLine(Composite composite) {
            this(composite, 16384);
        }

        public MessageLine(Composite composite, int n) {
            super(composite, n);
            this.fNormalMsgAreaBackground = this.getBackground();
        }

        private Image findImage(IStatus iStatus) {
            if (iStatus.isOK()) {
                return null;
            }
            if (iStatus.matches(4)) {
                return JFaceResources.getImage("dialog_message_error_image");
            }
            if (iStatus.matches(2)) {
                return JFaceResources.getImage("dialog_messasge_warning_image");
            }
            if (iStatus.matches(1)) {
                return JFaceResources.getImage("dialog_messasge_info_image");
            }
            return null;
        }

        public void setErrorStatus(IStatus iStatus) {
            String string;
            if (iStatus != null && !iStatus.isOK() && (string = iStatus.getMessage()) != null && string.length() > 0) {
                this.setText(string);
                this.setImage(this.findImage(iStatus));
                this.setBackground(JFaceColors.getErrorBackground(this.getDisplay()));
                return;
            }
            this.setText("");
            this.setImage(null);
            this.setBackground(this.fNormalMsgAreaBackground);
        }
    }
}

